/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class FixedSizeBitSet {
    protected static final int ADDRESS_BITS_PER_WORD = 6;
    protected static final int BITS_PER_WORD = 64;
    protected static final long WORD_MASK = -1L;
    protected long[] words;
    protected int size;

    public FixedSizeBitSet() {
    }

    public FixedSizeBitSet(int size) {
        if (size < 0) {
            throw new NegativeArraySizeException("size < 0: " + size);
        }
        this.size = size;
        this.words = new long[FixedSizeBitSet.wordIndex(size - 1) + 1];
    }

    public boolean set(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        int wordIndex = FixedSizeBitSet.wordIndex(index);
        boolean already_set = (this.words[wordIndex] & 1L << index) != 0L;
        int n = wordIndex;
        this.words[n] = this.words[n] | 1L << index;
        return !already_set;
    }

    public void set(int from, int to) {
        if (from < 0 || to < 0 || to < from || to >= this.size) {
            throw new IndexOutOfBoundsException("from=" + from + ", to=" + to);
        }
        int startWordIndex = FixedSizeBitSet.wordIndex(from);
        int endWordIndex = FixedSizeBitSet.wordIndex(to);
        long firstWordMask = -1L << from;
        long lastWordMask = -1L >>> -(to + 1);
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] | firstWordMask & lastWordMask;
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] | firstWordMask;
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i] = -1L;
            }
            int n2 = endWordIndex;
            this.words[n2] = this.words[n2] | lastWordMask;
        }
    }

    public void clear(int index) {
        int wordIndex;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        int n = wordIndex = FixedSizeBitSet.wordIndex(index);
        this.words[n] = this.words[n] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(int from, int to) {
        if (from < 0 || to < 0 || to < from || to >= this.size) {
            return;
        }
        int startWordIndex = FixedSizeBitSet.wordIndex(from);
        int endWordIndex = FixedSizeBitSet.wordIndex(to);
        long firstWordMask = -1L << from;
        long lastWordMask = -1L >>> -(to + 1);
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] & (firstWordMask & lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] & (firstWordMask ^ 0xFFFFFFFFFFFFFFFFL);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i] = 0L;
            }
            int n2 = endWordIndex;
            this.words[n2] = this.words[n2] & (lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        int wordIndex = FixedSizeBitSet.wordIndex(index);
        return (this.words[wordIndex] & 1L << index) != 0L;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex);
        }
        if (fromIndex >= this.size) {
            return -1;
        }
        int u = FixedSizeBitSet.wordIndex(fromIndex);
        long word = this.words[u] & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.words.length) {
                return -1;
            }
            word = this.words[u];
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex);
        }
        if (fromIndex >= this.size) {
            return -1;
        }
        int u = FixedSizeBitSet.wordIndex(fromIndex);
        if (u >= this.words.length) {
            return fromIndex;
        }
        long word = (this.words[u] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.words.length) {
                return -1;
            }
            word = this.words[u] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public int previousSetBit(int from) {
        if (from < 0 || from >= this.size) {
            throw new IndexOutOfBoundsException("index: " + from);
        }
        int u = FixedSizeBitSet.wordIndex(from);
        long word = this.words[u] & -1L >>> -(from + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u];
        }
        return (u + 1) * 64 - 1 - Long.numberOfLeadingZeros(word);
    }

    public int cardinality() {
        int sum = 0;
        for (int i = 0; i < this.words.length; ++i) {
            sum += Long.bitCount(this.words[i]);
        }
        return sum;
    }

    public int size() {
        return this.size;
    }

    public void flip() {
        int fromIndex = 0;
        int toIndex = this.size();
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = FixedSizeBitSet.wordIndex(fromIndex);
        int endWordIndex = FixedSizeBitSet.wordIndex(toIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] ^ firstWordMask & lastWordMask;
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] ^ firstWordMask;
            int i = startWordIndex + 1;
            while (i < endWordIndex) {
                int n2 = i++;
                this.words[n2] = this.words[n2] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            int n3 = endWordIndex;
            this.words[n3] = this.words[n3] ^ lastWordMask;
        }
    }

    public String toString() {
        if (this.cardinality() == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("(").append(this.cardinality()).append("): {");
        boolean first = true;
        int num = Util.MAX_LIST_PRINT_SIZE;
        int i = this.nextSetBit(0);
        while (i >= 0) {
            int endOfRun = this.nextClearBit(i);
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (endOfRun != -1 && endOfRun - 1 != i) {
                sb.append(i).append('-').append(endOfRun - 1);
                i = endOfRun;
            } else {
                sb.append(i);
            }
            if (--num <= 0) {
                sb.append(", ... ");
                break;
            }
            i = this.nextSetBit(i + 1);
        }
        sb.append('}');
        return sb.toString();
    }

    protected static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }
}

