/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.hornetq;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.core.protocol.core.impl.CoreProtocolManager;
import org.apache.activemq.artemis.core.protocol.core.impl.CoreProtocolManagerFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.server.ActiveMQServer;

class HornetQProtocolManager
extends CoreProtocolManager {
    HornetQProtocolManager(CoreProtocolManagerFactory factory, ActiveMQServer server, List<Interceptor> incomingInterceptors, List<Interceptor> outgoingInterceptors) {
        super(factory, server, incomingInterceptors, outgoingInterceptors);
    }

    public void handshake(NettyServerConnection connection, ActiveMQBuffer buffer) {
        if (buffer.getByte(0) == 72 && buffer.getByte(1) == 79 && buffer.getByte(2) == 82 && buffer.getByte(3) == 78 && buffer.getByte(4) == 69 && buffer.getByte(5) == 84 && buffer.getByte(6) == 81) {
            buffer.skipBytes(7);
        }
    }

    public boolean acceptsNoHandshake() {
        return true;
    }

    public boolean isProtocol(byte[] array) {
        String frameStart = new String(array, StandardCharsets.US_ASCII);
        return frameStart.startsWith("HORNETQ");
    }
}

