/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.critical;

import java.lang.invoke.MethodHandles;
import java.security.AccessController;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.critical.CriticalAction;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriticalAnalyzerImpl
implements CriticalAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private volatile long timeoutNanoSeconds;
    private volatile long checkTimeNanoSeconds = TimeUnit.SECONDS.toNanos(60L);
    private final ActiveMQScheduledComponent scheduledComponent;
    private List<CriticalAction> actions = new CopyOnWriteArrayList<CriticalAction>();
    private final ConcurrentHashSet<CriticalComponent> components = new ConcurrentHashSet();

    public CriticalAnalyzerImpl() {
        this.scheduledComponent = new ActiveMQScheduledComponent(null, null, this.checkTimeNanoSeconds, TimeUnit.NANOSECONDS, false){

            @Override
            public void run() {
                logger.trace("Checking critical analyzer");
                CriticalAnalyzerImpl.this.check();
            }

            @Override
            protected ActiveMQThreadFactory getThreadFactory() {
                return new ActiveMQThreadFactory("critical-analyzer", true, this.getThisClassLoader());
            }

            private ClassLoader getThisClassLoader() {
                return AccessController.doPrivileged(() -> CriticalAnalyzerImpl.this.getClass().getClassLoader());
            }
        };
    }

    @Override
    public void clear() {
        this.actions.clear();
        this.components.clear();
    }

    @Override
    public int getNumberOfComponents() {
        return this.components.size();
    }

    @Override
    public boolean isMeasuring() {
        return true;
    }

    @Override
    public void add(CriticalComponent component) {
        this.components.add(component);
    }

    @Override
    public void remove(CriticalComponent component) {
        this.components.remove(component);
    }

    @Override
    public CriticalAnalyzer setCheckTime(long timeout, TimeUnit unit) {
        this.checkTimeNanoSeconds = unit.toNanos(timeout);
        this.scheduledComponent.setPeriod(timeout, unit);
        return this;
    }

    @Override
    public long getCheckTimeNanoSeconds() {
        if (this.checkTimeNanoSeconds == 0L) {
            this.checkTimeNanoSeconds = this.getTimeout(TimeUnit.NANOSECONDS) / 2L;
        }
        return this.checkTimeNanoSeconds;
    }

    @Override
    public CriticalAnalyzer setTimeout(long timeout, TimeUnit unit) {
        if (this.checkTimeNanoSeconds <= 0L) {
            this.setCheckTime(timeout / 2L, unit);
        }
        this.timeoutNanoSeconds = unit.toNanos(timeout);
        return this;
    }

    @Override
    public long getTimeout(TimeUnit unit) {
        if (this.timeoutNanoSeconds == 0L) {
            this.timeoutNanoSeconds = TimeUnit.MINUTES.toNanos(2L);
        }
        return unit.convert(this.timeoutNanoSeconds, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getTimeoutNanoSeconds() {
        return this.timeoutNanoSeconds;
    }

    @Override
    public CriticalAnalyzer addAction(CriticalAction action) {
        this.actions.add(action);
        return this;
    }

    @Override
    public void check() {
        boolean retry = true;
        while (retry) {
            try {
                for (CriticalComponent component : this.components) {
                    if (!component.checkExpiration(this.timeoutNanoSeconds, true)) continue;
                    this.fireActions(component);
                    return;
                }
                retry = false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
    }

    protected void fireActions(CriticalComponent component) {
        for (CriticalAction action : this.actions) {
            try {
                action.run(component);
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
            }
        }
    }

    @Override
    public void start() {
        this.scheduledComponent.start();
    }

    @Override
    public void stop() {
        this.scheduledComponent.stop();
    }

    @Override
    public boolean isStarted() {
        return this.scheduledComponent.isStarted();
    }
}

