/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.util;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.jlibaio.LibaioContext;
import org.apache.activemq.artemis.utils.ReusableLatch;

public class SyncCalculation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long syncTest(File datafolder, int blockSize, int blocks, int tries, boolean verbose, boolean fsync, JournalType journalType) throws Exception {
        SequentialFileFactory factory = SyncCalculation.newFactory(datafolder, fsync, journalType, blockSize * blocks);
        if (verbose) {
            System.out.println("Using " + factory.getClass().getName() + " to calculate sync times");
        }
        SequentialFile file = factory.createSequentialFile("test.tmp");
        try {
            file.delete();
            file.open();
            file.fill(blockSize * blocks);
            file.close();
            long[] result = new long[tries];
            byte[] block = new byte[blockSize];
            for (int i = 0; i < block.length; ++i) {
                block[i] = 116;
            }
            ByteBuffer bufferBlock = factory.newBuffer(blockSize);
            bufferBlock.put(block);
            bufferBlock.position(0);
            final ReusableLatch latch = new ReusableLatch(0);
            IOCallback callback = new IOCallback(){

                public void done() {
                    latch.countDown();
                }

                public void onError(int errorCode, String errorMessage) {
                }
            };
            DecimalFormat dcformat = new DecimalFormat("###.##");
            for (int ntry = 0; ntry < tries; ++ntry) {
                if (verbose) {
                    System.out.println("**************************************************");
                    System.out.println(ntry + " of " + tries + " calculation");
                }
                file.open();
                file.position(0L);
                long start = System.currentTimeMillis();
                for (int i = 0; i < blocks; ++i) {
                    bufferBlock.position(0);
                    latch.countUp();
                    file.writeDirect(bufferBlock, true, callback);
                    if (latch.await(5L, TimeUnit.SECONDS)) continue;
                    throw new IOException("Callback wasn't called");
                }
                long end = System.currentTimeMillis();
                result[ntry] = end - start;
                if (verbose) {
                    double writesPerMillisecond = (double)blocks / (double)result[ntry];
                    System.out.println("Time = " + result[ntry] + " milliseconds");
                    System.out.println("Writes / millisecond = " + dcformat.format(writesPerMillisecond));
                    System.out.println("bufferTimeout = " + SyncCalculation.toNanos(result[ntry], blocks, verbose));
                    System.out.println("**************************************************");
                }
                file.close();
            }
            factory.releaseDirectBuffer(bufferBlock);
            long totalTime = Long.MAX_VALUE;
            for (int i = 0; i < tries; ++i) {
                if (result[i] >= totalTime) continue;
                totalTime = result[i];
            }
            long l = totalTime;
            return l;
        }
        finally {
            try {
                file.close();
            }
            catch (Exception exception) {}
            try {
                file.delete();
            }
            catch (Exception exception) {}
            try {
                factory.stop();
            }
            catch (Exception exception) {}
        }
    }

    public static long toNanos(long time, long blocks, boolean verbose) {
        double blocksPerMillisecond = (double)blocks / (double)time;
        if (verbose) {
            System.out.println("Blocks per millisecond::" + blocksPerMillisecond);
        }
        long nanoSeconds = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
        long timeWait = (long)((double)nanoSeconds / blocksPerMillisecond);
        if (verbose) {
            System.out.println("your system could make a sync every " + timeWait + " nanoseconds, and this will be your timeout");
        }
        return timeWait;
    }

    private static SequentialFileFactory newFactory(File datafolder, boolean datasync, JournalType journalType, int fileSize) {
        if (journalType == JournalType.ASYNCIO && !LibaioContext.isLoaded()) {
            journalType = JournalType.NIO;
        }
        switch (journalType) {
            case NIO: {
                SequentialFileFactory factory = new NIOSequentialFileFactory(datafolder, 1).setDatasync(datasync);
                factory.start();
                return factory;
            }
            case ASYNCIO: {
                SequentialFileFactory factory = new AIOSequentialFileFactory(datafolder, 1).setDatasync(datasync);
                factory.start();
                ((AIOSequentialFileFactory)factory).disableBufferReuse();
                return factory;
            }
        }
        throw ActiveMQMessageBundle.BUNDLE.invalidJournalType2(journalType);
    }
}

