/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.activemq.artemis.cli.Artemis;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.LockAbstract;
import org.apache.activemq.artemis.components.ExternalComponent;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.dto.BrokerDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.factory.BrokerFactory;
import org.apache.activemq.artemis.factory.SecurityManagerFactory;
import org.apache.activemq.artemis.integration.Broker;
import org.apache.activemq.artemis.integration.bootstrap.ActiveMQBootstrapLogger;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.utils.ReusableLatch;

@Command(name="run", description="runs the broker instance")
public class Run
extends LockAbstract {
    @Option(name={"--allow-kill"}, description="This will allow the server to kill itself. Useful for tests (failover tests for instance)")
    boolean allowKill;
    static boolean embedded = false;
    public static final ReusableLatch latchRunning = new ReusableLatch(0);
    private Broker server;

    public static void setEmbedded(boolean embedded) {
        Run.embedded = true;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        FileConfiguration fileConfiguration = this.getFileConfiguration();
        Artemis.printBanner();
        this.createDirectories(this.getFileConfiguration());
        BrokerDTO broker = this.getBrokerDTO();
        this.addShutdownHook(broker.server.getConfigurationFile().getParentFile());
        ActiveMQSecurityManager security = SecurityManagerFactory.create(broker.security);
        this.server = BrokerFactory.createServer(broker.server, security);
        this.server.start();
        if (broker.web != null) {
            broker.components.add(broker.web);
        }
        for (ComponentDTO componentDTO : broker.components) {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(componentDTO.componentClassName);
            ExternalComponent component = (ExternalComponent)clazz.newInstance();
            component.configure(componentDTO, this.getBrokerInstance(), this.getBrokerHome());
            component.start();
            this.server.getServer().addExternalComponent((ActiveMQComponent)component);
        }
        return null;
    }

    private void createDirectories(FileConfiguration fileConfiguration) {
        fileConfiguration.getPagingLocation().mkdirs();
        fileConfiguration.getJournalLocation().mkdirs();
        fileConfiguration.getBindingsLocation().mkdirs();
        fileConfiguration.getLargeMessagesLocation().mkdirs();
    }

    private void addShutdownHook(File configurationDir) {
        File fileKill;
        latchRunning.countUp();
        final File file = new File(configurationDir, "STOP_ME");
        if (file.exists() && !file.delete()) {
            ActiveMQBootstrapLogger.LOGGER.errorDeletingFile(file.getAbsolutePath());
        }
        if ((fileKill = new File(configurationDir, "KILL_ME")).exists() && !fileKill.delete()) {
            ActiveMQBootstrapLogger.LOGGER.errorDeletingFile(fileKill.getAbsolutePath());
        }
        final Timer timer = new Timer("ActiveMQ Artemis Server Shutdown Timer", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (Run.this.allowKill && fileKill.exists()) {
                    try {
                        System.err.println("Halting by user request");
                        fileKill.delete();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Runtime.getRuntime().halt(0);
                }
                if (file.exists()) {
                    try {
                        try {
                            Run.this.server.stop();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        timer.cancel();
                    }
                    finally {
                        System.out.println("Server stopped!");
                        System.out.flush();
                        latchRunning.countDown();
                        if (!embedded) {
                            Runtime.getRuntime().exit(0);
                        }
                    }
                }
            }
        }, 500L, 500L);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Run.this.server.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

