/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.cli.CLIException;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.InputAbstract;
import org.apache.activemq.artemis.cli.commands.util.HashUtil;
import org.apache.activemq.artemis.cli.commands.util.SyncCalculation;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.jlibaio.LibaioContext;
import org.apache.activemq.artemis.jlibaio.LibaioFile;
import org.apache.activemq.artemis.utils.FileUtil;

@Command(name="create", description="creates a new broker instance")
public class Create
extends InputAbstract {
    private static final Integer DEFAULT_PORT = 61616;
    private static final Integer AMQP_PORT = 5672;
    private static final Integer STOMP_PORT = 61613;
    private static final Integer HQ_PORT = 5445;
    public static final Integer HTTP_PORT = 8161;
    private static final Integer MQTT_PORT = 1883;
    public static final String BIN_ARTEMIS_CMD = "bin/artemis.cmd";
    public static final String BIN_ARTEMIS_SERVICE_EXE = "bin/artemis-service.exe";
    public static final String BIN_ARTEMIS_SERVICE_XML = "bin/artemis-service.xml";
    public static final String ETC_ARTEMIS_PROFILE_CMD = "etc/artemis.profile.cmd";
    public static final String BIN_ARTEMIS = "bin/artemis";
    public static final String BIN_ARTEMIS_SERVICE = "bin/artemis-service";
    public static final String ETC_ARTEMIS_PROFILE = "etc/artemis.profile";
    public static final String ETC_LOGGING_PROPERTIES = "etc/logging.properties";
    public static final String ETC_BOOTSTRAP_XML = "etc/bootstrap.xml";
    public static final String ETC_BROKER_XML = "etc/broker.xml";
    public static final String ETC_ARTEMIS_ROLES_PROPERTIES = "etc/artemis-roles.properties";
    public static final String ETC_ARTEMIS_USERS_PROPERTIES = "etc/artemis-users.properties";
    public static final String ETC_LOGIN_CONFIG = "etc/login.config";
    public static final String ETC_LOGIN_CONFIG_WITH_GUEST = "etc/login-with-guest.config";
    public static final String ETC_LOGIN_CONFIG_WITHOUT_GUEST = "etc/login-without-guest.config";
    public static final String ETC_REPLICATED_SETTINGS_TXT = "etc/replicated-settings.txt";
    public static final String ETC_SHARED_STORE_SETTINGS_TXT = "etc/shared-store-settings.txt";
    public static final String ETC_CLUSTER_SECURITY_SETTINGS_TXT = "etc/cluster-security-settings.txt";
    public static final String ETC_CLUSTER_SETTINGS_TXT = "etc/cluster-settings.txt";
    public static final String ETC_CONNECTOR_SETTINGS_TXT = "etc/connector-settings.txt";
    public static final String ETC_BOOTSTRAP_WEB_SETTINGS_TXT = "etc/bootstrap-web-settings.txt";
    public static final String ETC_JOURNAL_BUFFER_SETTINGS = "etc/journal-buffer-settings.txt";
    public static final String ETC_AMQP_ACCEPTOR_TXT = "etc/amqp-acceptor.txt";
    public static final String ETC_HORNETQ_ACCEPTOR_TXT = "etc/hornetq-acceptor.txt";
    public static final String ETC_MQTT_ACCEPTOR_TXT = "etc/mqtt-acceptor.txt";
    public static final String ETC_STOMP_ACCEPTOR_TXT = "etc/stomp-acceptor.txt";
    @Arguments(description="The instance directory to hold the broker's configuration and data.  Path must be writable.", required=true)
    File directory;
    @Option(name={"--host"}, description="The host name of the broker (Default: 0.0.0.0 or input if clustered)")
    String host;
    @Option(name={"--default-port"}, description="The port number to use for the main 'artemis' acceptor (Default: 61616)")
    int defaultPort = DEFAULT_PORT;
    @Option(name={"--http-port"}, description="The port number to use for embedded web server (Default: 8161)")
    int httpPort = HTTP_PORT;
    @Option(name={"--ssl-key"}, description="The key store path for embedded web server")
    String sslKey;
    @Option(name={"--ssl-key-password"}, description="The key store password")
    String sslKeyPassword;
    @Option(name={"--use-client-auth"}, description="If the embedded server requires client authentication")
    boolean useClientAuth;
    @Option(name={"--ssl-trust"}, description="The trust store path in case of client authentication")
    String sslTrust;
    @Option(name={"--ssl-trust-password"}, description="The trust store password")
    String sslTrustPassword;
    @Option(name={"--name"}, description="The name of the broker (Default: same as host)")
    String name;
    @Option(name={"--port-offset"}, description="Off sets the ports of every acceptor")
    int portOffset;
    @Option(name={"--force"}, description="Overwrite configuration at destination directory")
    boolean force;
    @Option(name={"--home"}, description="Directory where ActiveMQ Artemis is installed")
    File home;
    @Option(name={"--data"}, description="Directory where ActiveMQ Data is used. Paths are relative to artemis.instance")
    String data = "./data";
    @Option(name={"--clustered"}, description="Enable clustering")
    boolean clustered = false;
    @Option(name={"--max-hops"}, description="Number of hops on the cluster configuration")
    int maxHops = 0;
    @Option(name={"--message-load-balancing"}, description="Load balancing policy on cluster. [ON_DEMAND (default) | STRICT | OFF]")
    MessageLoadBalancingType messageLoadBalancing = MessageLoadBalancingType.ON_DEMAND;
    @Option(name={"--replicated"}, description="Enable broker replication")
    boolean replicated = false;
    @Option(name={"--shared-store"}, description="Enable broker shared store")
    boolean sharedStore = false;
    @Option(name={"--slave"}, description="Valid for shared store or replication: this is a slave server?")
    boolean slave;
    @Option(name={"--failover-on-shutdown"}, description="Valid for shared store: will shutdown trigger a failover? (Default: false)")
    boolean failoverOnShutodwn;
    @Option(name={"--cluster-user"}, description="The cluster user to use for clustering. (Default: input)")
    String clusterUser = null;
    @Option(name={"--cluster-password"}, description="The cluster password to use for clustering. (Default: input)")
    String clusterPassword = null;
    @Option(name={"--encoding"}, description="The encoding that text files should use")
    String encoding = "UTF-8";
    @Option(name={"--java-options"}, description="Extra java options to be passed to the profile")
    String javaOptions = "";
    @Option(name={"--allow-anonymous"}, description="Enables anonymous configuration on security, opposite of --require-login (Default: input)")
    Boolean allowAnonymous = null;
    @Option(name={"--require-login"}, description="This will configure security to require user / password, opposite of --allow-anonymous")
    Boolean requireLogin = null;
    @Option(name={"--no-autotune"}, description="Disable auto tuning on the journal.")
    boolean noAutoTune;
    @Option(name={"--user"}, description="The username (Default: input)")
    String user;
    @Option(name={"--password"}, description="The user's password (Default: input)")
    String password;
    @Option(name={"--role"}, description="The name for the role created (Default: input)")
    String role;
    @Option(name={"--no-web"}, description="This will remove the web server definition from bootstrap.xml")
    boolean noWeb;
    @Option(name={"--queues"}, description="comma separated list of jms queues.")
    String queues;
    @Option(name={"--topics"}, description="comma separated list of jms topics ")
    String topics;
    @Option(name={"--aio"}, description="Force aio journal on the configuration regardless of the library being available or not.")
    boolean forceLibaio;
    @Option(name={"--nio"}, description="Force nio journal on the configuration regardless of the library being available or not.")
    boolean forceNIO;
    @Option(name={"--disable-persistence"}, description="Disable message persistence to the journal")
    boolean disablePersistence;
    @Option(name={"--no-amqp-acceptor"}, description="Disable the AMQP specific acceptor.")
    boolean noAmqpAcceptor;
    @Option(name={"--no-mqtt-acceptor"}, description="Disable the MQTT specific acceptor.")
    boolean noMqttAcceptor;
    @Option(name={"--no-stomp-acceptor"}, description="Disable the STOMP specific acceptor.")
    boolean noStompAcceptor;
    @Option(name={"--no-hornetq-acceptor"}, description="Disable the HornetQ specific acceptor.")
    boolean noHornetQAcceptor;
    @Option(name={"--no-fsync"}, description="Disable usage of fdatasync (channel.force(false) from java nio) on the journal")
    boolean noJournalSync;
    boolean IS_WINDOWS;
    boolean IS_CYGWIN;

    public int getMaxHops() {
        return this.maxHops;
    }

    public void setMaxHops(int maxHops) {
        this.maxHops = maxHops;
    }

    public boolean isNoWeb() {
        return this.noWeb;
    }

    public void setNoWeb(boolean noWeb) {
        this.noWeb = noWeb;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public void setPortOffset(int portOffset) {
        this.portOffset = portOffset;
    }

    public MessageLoadBalancingType getMessageLoadBalancing() {
        return this.messageLoadBalancing;
    }

    public void setMessageLoadBalancing(MessageLoadBalancingType messageLoadBalancing) {
        this.messageLoadBalancing = messageLoadBalancing;
    }

    public String getJavaOptions() {
        return this.javaOptions;
    }

    public void setJavaOptions(String javaOptions) {
        this.javaOptions = javaOptions;
    }

    public File getInstance() {
        return this.directory;
    }

    public void setInstance(File directory) {
        this.directory = directory;
    }

    public String getHost() {
        if (this.host == null) {
            this.host = "0.0.0.0";
        }
        return this.host;
    }

    public String getHostForClustered() {
        if (this.getHost().equals("0.0.0.0")) {
            this.host = this.input("--host", "Host " + this.host + " is not valid for clustering, please provide a valid IP or hostname", "localhost");
        }
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public File getHome() {
        if (this.home == null) {
            this.home = new File(this.getBrokerHome());
        }
        return this.home;
    }

    public void setHome(File home) {
        this.home = home;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    public boolean isSharedStore() {
        return this.sharedStore;
    }

    public void setSharedStore(boolean sharedStore) {
        this.sharedStore = sharedStore;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getClusterUser() {
        if (this.clusterUser == null) {
            this.clusterUser = this.input("--cluster-user", "Please provide the username:", "cluster-admin");
        }
        return this.clusterUser;
    }

    public void setClusterUser(String clusterUser) {
        this.clusterUser = clusterUser;
    }

    public String getClusterPassword() {
        if (this.clusterPassword == null) {
            this.clusterPassword = this.inputPassword("--cluster-password", "Please enter the password:", "password-admin");
        }
        return this.clusterPassword;
    }

    public String getSslKeyPassword() {
        if (this.sslKeyPassword == null) {
            this.sslKeyPassword = this.inputPassword("--ssl-key-password", "Please enter the keystore password:", "password");
        }
        return this.sslKeyPassword;
    }

    public String getSslTrust() {
        if (this.sslTrust == null) {
            this.sslTrust = this.input("--ssl-trust", "Please enter the trust store path:", "/etc/truststore.jks");
        }
        return this.sslTrust;
    }

    public String getSslTrustPassword() {
        if (this.sslTrustPassword == null) {
            this.sslTrustPassword = this.inputPassword("--ssl-key-password", "Please enter the keystore password:", "password");
        }
        return this.sslTrustPassword;
    }

    public void setClusterPassword(String clusterPassword) {
        this.clusterPassword = clusterPassword;
    }

    public boolean isAllowAnonymous() {
        if (this.allowAnonymous == null) {
            String value = this.input("--allow-anonymous | --require-login", "Allow anonymous access? (Y/N):", "Y");
            this.allowAnonymous = value.toLowerCase().equals("y");
        }
        return this.allowAnonymous;
    }

    public void setAllowAnonymous(boolean allowGuest) {
        this.allowAnonymous = allowGuest;
    }

    public Boolean getRequireLogin() {
        if (this.requireLogin == null) {
            this.requireLogin = !this.isAllowAnonymous();
        }
        return this.requireLogin;
    }

    public void setRequireLogin(Boolean requireLogin) {
        this.requireLogin = requireLogin;
    }

    public String getPassword() {
        if (this.password == null) {
            this.password = this.inputPassword("--password", "Please provide the default password:", "admin");
        }
        this.password = HashUtil.tryHash(this.context, this.password);
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        if (this.user == null) {
            this.user = this.input("--user", "Please provide the default username:", "admin");
        }
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getRole() {
        if (this.role == null) {
            this.role = this.input("--role", "Please provide the default role:", "amq");
        }
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public boolean isSlave() {
        return this.slave;
    }

    public void setSlave(boolean slave) {
        this.slave = slave;
    }

    public boolean isFailoverOnShutodwn() {
        return this.failoverOnShutodwn;
    }

    public void setFailoverOnShutodwn(boolean failoverOnShutodwn) {
        this.failoverOnShutodwn = failoverOnShutodwn;
    }

    public Boolean getAllowAnonymous() {
        return this.allowAnonymous;
    }

    public void setAllowAnonymous(Boolean allowAnonymous) {
        this.allowAnonymous = allowAnonymous;
    }

    public boolean isDisablePersistence() {
        return this.disablePersistence;
    }

    public void setDisablePersistence(boolean disablePersistence) {
        this.disablePersistence = disablePersistence;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        this.checkDirectory();
        super.execute(context);
        return this.run(context);
    }

    public InputStream openStream(String source) {
        return this.getClass().getResourceAsStream(source);
    }

    private void checkDirectory() {
        if (!this.directory.exists()) {
            boolean created = this.directory.mkdirs();
            if (!created) {
                throw new RuntimeException(String.format("Unable to create the path '%s'.", this.directory));
            }
        } else if (!this.directory.canWrite()) {
            throw new RuntimeException(String.format("The path '%s' is not writable.", this.directory));
        }
    }

    public Object run(ActionContext context) throws Exception {
        boolean aio;
        if (this.forceLibaio && this.forceNIO) {
            throw new RuntimeException("You can't specify --nio and --aio in the same execution.");
        }
        this.IS_WINDOWS = System.getProperty("os.name").toLowerCase().trim().startsWith("win");
        boolean bl = this.IS_CYGWIN = this.IS_WINDOWS && "cygwin".equals(System.getenv("OSTYPE"));
        if (this.requireLogin != null && this.requireLogin.booleanValue()) {
            this.allowAnonymous = Boolean.FALSE;
        }
        context.out.println(String.format("Creating ActiveMQ Artemis instance at: %s", this.directory.getCanonicalPath()));
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("${master-slave}", this.isSlave() ? "slave" : "master");
        filters.put("${failover-on-shutdown}", this.isFailoverOnShutodwn() ? "true" : "false");
        filters.put("${persistence-enabled}", this.isDisablePersistence() ? "false" : "true");
        if (this.replicated) {
            this.clustered = true;
            filters.put("${replicated.settings}", this.applyFilters(this.readTextFile(ETC_REPLICATED_SETTINGS_TXT), filters));
        } else {
            filters.put("${replicated.settings}", "");
        }
        if (this.sharedStore) {
            this.clustered = true;
            filters.put("${shared-store.settings}", this.applyFilters(this.readTextFile(ETC_SHARED_STORE_SETTINGS_TXT), filters));
        } else {
            filters.put("${shared-store.settings}", "");
        }
        if (this.IS_WINDOWS || !this.supportsLibaio()) {
            aio = false;
            filters.put("${journal.settings}", "NIO");
        } else {
            aio = true;
            filters.put("${journal.settings}", "ASYNCIO");
        }
        if (this.sslKey != null) {
            filters.put("${web.protocol}", "https");
            this.getSslKeyPassword();
            String extraWebAttr = " keyStorePath=\"" + this.sslKey + "\" keyStorePassword=\"" + this.sslKeyPassword + "\"";
            if (this.useClientAuth) {
                this.getSslTrust();
                this.getSslTrustPassword();
                extraWebAttr = extraWebAttr + " clientAuth=\"true\" trustStorePath=\"" + this.sslTrust + "\" trustStorePassword=\"" + this.sslTrustPassword + "\"";
            }
            filters.put("${extra.web.attributes}", extraWebAttr);
        } else {
            filters.put("${web.protocol}", "http");
            filters.put("${extra.web.attributes}", "");
        }
        filters.put("${fsync}", String.valueOf(!this.noJournalSync));
        filters.put("${user}", System.getProperty("user.name", ""));
        filters.put("${default.port}", String.valueOf(this.defaultPort + this.portOffset));
        filters.put("${amqp.port}", String.valueOf(AMQP_PORT + this.portOffset));
        filters.put("${stomp.port}", String.valueOf(STOMP_PORT + this.portOffset));
        filters.put("${hq.port}", String.valueOf(HQ_PORT + this.portOffset));
        filters.put("${mqtt.port}", String.valueOf(MQTT_PORT + this.portOffset));
        filters.put("${http.port}", String.valueOf(this.httpPort + this.portOffset));
        filters.put("${data.dir}", this.data);
        filters.put("${max-hops}", String.valueOf(this.maxHops));
        filters.put("${message-load-balancing}", this.messageLoadBalancing.toString());
        filters.put("${user}", this.getUser());
        filters.put("${password}", this.getPassword());
        filters.put("${role}", this.getRole());
        if (this.clustered) {
            filters.put("${host}", this.getHostForClustered());
            if (this.name == null) {
                this.name = this.getHostForClustered();
            }
            String connectorSettings = this.readTextFile(ETC_CONNECTOR_SETTINGS_TXT);
            connectorSettings = this.applyFilters(connectorSettings, filters);
            filters.put("${name}", this.name);
            filters.put("${connector-config.settings}", connectorSettings);
            filters.put("${cluster-security.settings}", this.readTextFile(ETC_CLUSTER_SECURITY_SETTINGS_TXT));
            filters.put("${cluster.settings}", this.applyFilters(this.readTextFile(ETC_CLUSTER_SETTINGS_TXT), filters));
            filters.put("${cluster-user}", this.getClusterUser());
            filters.put("${cluster-password}", this.getClusterPassword());
        } else {
            if (this.name == null) {
                this.name = this.getHost();
            }
            filters.put("${name}", this.name);
            filters.put("${host}", this.getHost());
            filters.put("${connector-config.settings}", "");
            filters.put("${cluster-security.settings}", "");
            filters.put("${cluster.settings}", "");
            filters.put("${cluster-user}", "");
            filters.put("${cluster-password}", "");
        }
        this.applyJMSObjects(filters);
        if (this.home != null) {
            filters.put("${home}", this.path(this.home, false));
        }
        filters.put("${artemis.home}", this.path(this.getHome().toString(), false));
        filters.put("${artemis.instance}", this.path(this.directory, false));
        filters.put("${artemis.instance.name}", this.directory.getName());
        filters.put("${java.home}", this.path(System.getProperty("java.home"), false));
        new File(this.directory, "bin").mkdirs();
        new File(this.directory, "etc").mkdirs();
        new File(this.directory, "log").mkdirs();
        new File(this.directory, "tmp").mkdirs();
        File dataFolder = new File(this.directory, "data");
        dataFolder.mkdirs();
        filters.put("${logmanager}", this.getLogManager());
        if (this.javaOptions == null || this.javaOptions.length() == 0) {
            this.javaOptions = "";
        }
        filters.put("${java-opts}", this.javaOptions);
        if (this.isAllowAnonymous()) {
            this.write(ETC_LOGIN_CONFIG_WITH_GUEST, filters, false);
            new File(this.directory, ETC_LOGIN_CONFIG_WITH_GUEST).renameTo(new File(this.directory, ETC_LOGIN_CONFIG));
        } else {
            this.write(ETC_LOGIN_CONFIG_WITHOUT_GUEST, filters, false);
            new File(this.directory, ETC_LOGIN_CONFIG_WITHOUT_GUEST).renameTo(new File(this.directory, ETC_LOGIN_CONFIG));
        }
        this.write(ETC_ARTEMIS_ROLES_PROPERTIES, filters, false);
        if (this.IS_WINDOWS) {
            this.write(BIN_ARTEMIS_CMD, null, false);
            this.write(BIN_ARTEMIS_SERVICE_EXE);
            this.write(BIN_ARTEMIS_SERVICE_XML, filters, false);
            this.write(ETC_ARTEMIS_PROFILE_CMD, filters, false);
        }
        if (!this.IS_WINDOWS || this.IS_CYGWIN) {
            this.write(BIN_ARTEMIS, filters, true);
            this.makeExec(BIN_ARTEMIS);
            this.write(BIN_ARTEMIS_SERVICE, filters, true);
            this.makeExec(BIN_ARTEMIS_SERVICE);
            this.write(ETC_ARTEMIS_PROFILE, filters, true);
        }
        this.write(ETC_LOGGING_PROPERTIES, null, false);
        if (this.noWeb) {
            filters.put("${bootstrap-web-settings}", "");
        } else {
            filters.put("${bootstrap-web-settings}", this.applyFilters(this.readTextFile(ETC_BOOTSTRAP_WEB_SETTINGS_TXT), filters));
        }
        if (this.noAmqpAcceptor) {
            filters.put("${amqp-acceptor}", "");
        } else {
            filters.put("${amqp-acceptor}", this.applyFilters(this.readTextFile(ETC_AMQP_ACCEPTOR_TXT), filters));
        }
        if (this.noMqttAcceptor) {
            filters.put("${mqtt-acceptor}", "");
        } else {
            filters.put("${mqtt-acceptor}", this.applyFilters(this.readTextFile(ETC_MQTT_ACCEPTOR_TXT), filters));
        }
        if (this.noStompAcceptor) {
            filters.put("${stomp-acceptor}", "");
        } else {
            filters.put("${stomp-acceptor}", this.applyFilters(this.readTextFile(ETC_STOMP_ACCEPTOR_TXT), filters));
        }
        if (this.noHornetQAcceptor) {
            filters.put("${hornetq-acceptor}", "");
        } else {
            filters.put("${hornetq-acceptor}", this.applyFilters(this.readTextFile(ETC_HORNETQ_ACCEPTOR_TXT), filters));
        }
        this.performAutoTune(filters, aio, dataFolder);
        this.write(ETC_BROKER_XML, filters, false);
        this.write(ETC_ARTEMIS_USERS_PROPERTIES, filters, false);
        filters.remove("${artemis.instance}");
        this.write(ETC_BOOTSTRAP_XML, filters, false);
        context.out.println("");
        context.out.println("You can now start the broker by executing:  ");
        context.out.println("");
        context.out.println(String.format("   \"%s\" run", this.path(new File(this.directory, BIN_ARTEMIS), true)));
        File service = new File(this.directory, BIN_ARTEMIS_SERVICE);
        context.out.println("");
        if (!this.IS_WINDOWS || this.IS_CYGWIN) {
            context.out.println("Or you can run the broker in the background using:");
            context.out.println("");
            context.out.println(String.format("   \"%s\" start", this.path(service, true)));
            context.out.println("");
        }
        if (this.IS_WINDOWS) {
            service = new File(this.directory, BIN_ARTEMIS_SERVICE_EXE);
            context.out.println("Or you can setup the broker as Windows service and run it in the background:");
            context.out.println("");
            context.out.println(String.format("   \"%s\" install", this.path(service, true)));
            context.out.println(String.format("   \"%s\" start", this.path(service, true)));
            context.out.println("");
            context.out.println("   To stop the windows service:");
            context.out.println(String.format("      \"%s\" stop", this.path(service, true)));
            context.out.println("");
            context.out.println("   To uninstall the windows service");
            context.out.println(String.format("      \"%s\" uninstall", this.path(service, true)));
        }
        return null;
    }

    private String getLogManager() throws IOException {
        String logManager = "";
        File dir = new File(this.path(this.getHome().toString(), false) + "/lib");
        File[] matches = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("jboss-logmanager") && name.endsWith(".jar");
            }
        });
        if (matches != null && matches.length > 0) {
            logManager = matches[0].getName();
        }
        return logManager;
    }

    private void applyJMSObjects(HashMap<String, String> filters) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println();
        for (String str : this.getQueueList()) {
            printWriter.println("      <queue name=\"" + str + "\"/>");
        }
        for (String str : this.getTopicList()) {
            printWriter.println("      <topic name=\"" + str + "\"/>");
        }
        filters.put("${jms-list.settings}", writer.toString());
    }

    private void performAutoTune(HashMap<String, String> filters, boolean aio, File dataFolder) {
        if (this.noAutoTune) {
            filters.put("${journal-buffer.settings}", "");
        } else {
            try {
                int writes = 250;
                System.out.println("");
                System.out.println("Auto tuning journal ...");
                long time = SyncCalculation.syncTest(dataFolder, 4096, writes, 5, this.verbose, !this.noJournalSync, aio);
                long nanoseconds = SyncCalculation.toNanos(time, writes);
                double writesPerMillisecond = (double)writes / (double)time;
                String writesPerMillisecondStr = new DecimalFormat("###.##").format(writesPerMillisecond);
                HashMap<String, String> syncFilter = new HashMap<String, String>();
                syncFilter.put("${nanoseconds}", Long.toString(nanoseconds));
                syncFilter.put("${writesPerMillisecond}", writesPerMillisecondStr);
                System.out.println("done! Your system can make " + writesPerMillisecondStr + " writes per millisecond, your journal-buffer-timeout will be " + nanoseconds);
                filters.put("${journal-buffer.settings}", this.applyFilters(this.readTextFile(ETC_JOURNAL_BUFFER_SETTINGS), syncFilter));
            }
            catch (Exception e) {
                filters.put("${journal-buffer.settings}", "");
                e.printStackTrace();
                System.err.println("Couldn't perform sync calculation, using default values");
            }
        }
    }

    public boolean supportsLibaio() {
        if (this.forceLibaio) {
            return true;
        }
        if (this.forceNIO) {
            return false;
        }
        if (LibaioContext.isLoaded()) {
            try (LibaioContext context = new LibaioContext(1, true, true);){
                File tmpFile = new File(this.directory, "validateAIO.bin");
                boolean supportsLibaio = true;
                try {
                    LibaioFile file = context.openFile(tmpFile, true);
                    file.close();
                }
                catch (Exception e) {
                    supportsLibaio = false;
                }
                tmpFile.delete();
                if (!supportsLibaio) {
                    System.err.println("The filesystem used on " + this.directory + " doesn't support libAIO and O_DIRECT files, switching journal-type to NIO");
                }
                boolean bl = supportsLibaio;
                return bl;
            }
        }
        return false;
    }

    private void makeExec(String path) throws IOException {
        FileUtil.makeExec((File)new File(this.directory, path));
    }

    private String[] getQueueList() {
        if (this.queues == null) {
            return new String[0];
        }
        return this.queues.split(",");
    }

    private String[] getTopicList() {
        if (this.topics == null) {
            return new String[0];
        }
        return this.topics.split(",");
    }

    String path(String value, boolean unixPaths) throws IOException {
        return this.path(new File(value), unixPaths);
    }

    private String path(File value, boolean unixPaths) throws IOException {
        if (unixPaths && this.IS_CYGWIN) {
            return value.getCanonicalPath();
        }
        return value.getCanonicalPath();
    }

    private void write(String source, HashMap<String, String> filters, boolean unixTarget) throws Exception {
        this.write(source, new File(this.directory, source), filters, unixTarget);
    }

    private void write(String source, File target, HashMap<String, String> filters, boolean unixTarget) throws Exception {
        if (target.exists() && !this.force) {
            throw new CLIException(String.format("The file '%s' already exists.  Use --force to overwrite.", target));
        }
        String content = this.applyFilters(this.readTextFile(source), filters);
        String separator = unixTarget && this.IS_CYGWIN ? "\n" : System.getProperty("line.separator");
        content = content.replaceAll("\\r?\\n", Matcher.quoteReplacement(separator));
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes(this.encoding));
        try (FileOutputStream fout = new FileOutputStream(target);){
            this.copy(in, fout);
        }
    }

    private String applyFilters(String content, HashMap<String, String> filters) throws IOException {
        if (filters != null) {
            for (Map.Entry<String, String> entry : filters.entrySet()) {
                content = this.replace(content, entry.getKey(), entry.getValue());
            }
        }
        return content;
    }

    private String readTextFile(String source) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream in = this.openStream(source);){
            this.copy(in, out);
        }
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    private void write(String source) throws IOException {
        File target = new File(this.directory, source);
        if (target.exists() && !this.force) {
            throw new RuntimeException(String.format("The file '%s' already exists.  Use --force to overwrite.", target));
        }
        try (FileOutputStream fout = new FileOutputStream(target);
             InputStream in = this.openStream(source);){
            this.copy(in, fout);
        }
    }

    private String replace(String content, String key, String value) {
        return content.replaceAll(Pattern.quote(key), Matcher.quoteReplacement(value));
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[4096];
        int c = is.read(buffer);
        while (c >= 0) {
            os.write(buffer, 0, c);
            c = is.read(buffer);
        }
    }
}

