/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientRequestor;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.ActionAbstract;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.core.message.impl.MessageImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.utils.Base64;
import org.apache.activemq.artemis.utils.UUIDGenerator;

@Command(name="imp", description="Import all message-data using an XML that could be interpreted by any system.")
public final class XmlDataImporter
extends ActionAbstract {
    private XMLStreamReader reader;
    ClientSession managementSession;
    boolean localSession;
    final Map<String, String> addressMap = new HashMap<String, String>();
    final Map<String, Long> queueIDs = new HashMap<String, Long>();
    String tempFileName = "";
    private ClientSession session;
    @Option(name={"--host"}, description="The host used to import the data (default localhost)")
    public String host = "localhost";
    @Option(name={"--port"}, description="The port used to import the data (default 61616)")
    public int port = 61616;
    @Option(name={"--transaction"}, description="If this is set to true you will need a whole transaction to commit at the end. (default false)")
    public boolean transactional;
    @Option(name={"--user"}, description="User name used to import the data. (default null)")
    public String user = null;
    @Option(name={"--password"}, description="User name used to import the data. (default null)")
    public String password = null;
    @Option(name={"--input"}, description="The input file name (default=exp.dmp)", required=true)
    public String input = "exp.dmp";

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        this.process(this.input, this.host, this.port, this.transactional);
        return null;
    }

    public void process(String inputFile, String host, int port, boolean transactional) throws Exception {
        this.process(new FileInputStream(inputFile), host, port, transactional);
    }

    public void process(InputStream inputStream, ClientSession session) throws Exception {
        this.process(inputStream, session, null);
    }

    public void process(InputStream inputStream, ClientSession session, ClientSession managementSession) throws Exception {
        this.reader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        this.session = session;
        this.managementSession = managementSession != null ? managementSession : session;
        this.localSession = false;
        this.processXml();
    }

    public void process(InputStream inputStream, String host, int port, boolean transactional) throws Exception {
        this.reader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        HashMap<String, String> connectionParams = new HashMap<String, String>();
        connectionParams.put("host", host);
        connectionParams.put("port", Integer.toString(port));
        ServerLocator serverLocator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(NettyConnectorFactory.class.getName(), connectionParams)});
        ClientSessionFactory sf = serverLocator.createSessionFactory();
        if (this.user != null || this.password != null) {
            this.session = sf.createSession(this.user, this.password, false, !transactional, true, false, 0);
            this.managementSession = sf.createSession(this.user, this.password, false, true, true, false, 0);
        } else {
            this.session = sf.createSession(false, !transactional, true);
            this.managementSession = sf.createSession(false, true, true);
        }
        this.localSession = true;
        this.processXml();
    }

    private void processXml() throws Exception {
        try {
            while (this.reader.hasNext()) {
                ActiveMQServerLogger.LOGGER.debug((Object)("EVENT:[" + this.reader.getLocation().getLineNumber() + "][" + this.reader.getLocation().getColumnNumber() + "] "));
                if (this.reader.getEventType() == 1) {
                    if ("binding".equals(this.reader.getLocalName())) {
                        this.bindQueue();
                    } else if ("message".equals(this.reader.getLocalName())) {
                        this.processMessage();
                    } else if ("jms-connection-factories".equals(this.reader.getLocalName())) {
                        this.createJmsConnectionFactories();
                    } else if ("jms-destinations".equals(this.reader.getLocalName())) {
                        this.createJmsDestinations();
                    }
                }
                this.reader.next();
            }
            if (!this.session.isAutoCommitSends()) {
                this.session.commit();
            }
        }
        finally {
            if (this.localSession) {
                this.session.close();
                this.managementSession.close();
            }
        }
    }

    private void processMessage() throws Exception {
        Byte type = 0;
        Byte priority = 0;
        Long expiration = 0L;
        Long timestamp = 0L;
        org.apache.activemq.artemis.utils.UUID userId = null;
        ArrayList<String> queues = new ArrayList<String>();
        block18: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName;
            switch (attributeName = this.reader.getAttributeLocalName(i)) {
                case "type": {
                    type = this.getMessageType(this.reader.getAttributeValue(i));
                    continue block18;
                }
                case "priority": {
                    priority = Byte.parseByte(this.reader.getAttributeValue(i));
                    continue block18;
                }
                case "expiration": {
                    expiration = Long.parseLong(this.reader.getAttributeValue(i));
                    continue block18;
                }
                case "timestamp": {
                    timestamp = Long.parseLong(this.reader.getAttributeValue(i));
                    continue block18;
                }
                case "user-id": {
                    userId = UUIDGenerator.getInstance().generateUUID();
                }
            }
        }
        ClientMessage message = this.session.createMessage(type.byteValue(), true, expiration.longValue(), timestamp.longValue(), priority.byteValue());
        message.setUserID(userId);
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if ("body".equals(this.reader.getLocalName())) {
                        this.processMessageBody((Message)message);
                        break;
                    }
                    if ("property".equals(this.reader.getLocalName())) {
                        this.processMessageProperties((Message)message);
                        break;
                    }
                    if (!"queue".equals(this.reader.getLocalName())) break;
                    this.processMessageQueues(queues);
                    break;
                }
                case 2: {
                    if (!"message".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
        this.sendMessage(queues, (Message)message);
    }

    private Byte getMessageType(String value) {
        Byte type = 0;
        switch (value) {
            case "default": {
                type = 0;
                break;
            }
            case "bytes": {
                type = 4;
                break;
            }
            case "map": {
                type = 5;
                break;
            }
            case "object": {
                type = 2;
                break;
            }
            case "stream": {
                type = 6;
                break;
            }
            case "text": {
                type = 3;
            }
        }
        return type;
    }

    private void sendMessage(ArrayList<String> queues, Message message) throws Exception {
        StringBuilder logMessage = new StringBuilder();
        String destination = this.addressMap.get(queues.get(0));
        logMessage.append("Sending ").append(message).append(" to address: ").append(destination).append("; routed to queues: ");
        ByteBuffer buffer = ByteBuffer.allocate(queues.size() * 8);
        for (String queue : queues) {
            long queueID;
            if (this.queueIDs.containsKey(queue)) {
                queueID = this.queueIDs.get(queue);
            } else {
                ClientRequestor requestor = new ClientRequestor(this.managementSession, "jms.queue.activemq.management");
                ClientMessage managementMessage = this.managementSession.createMessage(false);
                ManagementHelper.putAttribute((Message)managementMessage, (String)("core.queue." + queue), (String)"ID");
                this.managementSession.start();
                ActiveMQServerLogger.LOGGER.debug((Object)("Requesting ID for: " + queue));
                ClientMessage reply = requestor.request(managementMessage);
                queueID = ((Integer)ManagementHelper.getResult((Message)reply)).intValue();
                requestor.close();
                ActiveMQServerLogger.LOGGER.debug((Object)("ID for " + queue + " is: " + queueID));
                this.queueIDs.put(queue, queueID);
            }
            logMessage.append(queue).append(", ");
            buffer.putLong(queueID);
        }
        logMessage.delete(logMessage.length() - 2, logMessage.length());
        ActiveMQServerLogger.LOGGER.debug((Object)logMessage);
        message.putBytesProperty(MessageImpl.HDR_ROUTE_TO_IDS, buffer.array());
        ClientProducer producer = this.session.createProducer(destination);
        producer.send(message);
        producer.close();
        if (this.tempFileName.length() > 0) {
            File tempFile = new File(this.tempFileName);
            if (!tempFile.delete()) {
                ActiveMQServerLogger.LOGGER.couldNotDeleteTempFile(this.tempFileName);
            }
            this.tempFileName = "";
        }
    }

    private void processMessageQueues(ArrayList<String> queues) {
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (!"name".equals(this.reader.getAttributeLocalName(i))) continue;
            queues.add(this.reader.getAttributeValue(i));
        }
    }

    private void processMessageProperties(Message message) {
        String key = "";
        String value = "";
        String propertyType = "";
        String realValue = null;
        block34: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName;
            switch (attributeName = this.reader.getAttributeLocalName(i)) {
                case "name": {
                    key = this.reader.getAttributeValue(i);
                    continue block34;
                }
                case "value": {
                    value = this.reader.getAttributeValue(i);
                    continue block34;
                }
                case "type": {
                    propertyType = this.reader.getAttributeValue(i);
                }
            }
        }
        switch (propertyType) {
            case "short": {
                message.putShortProperty(key, Short.parseShort(value));
                break;
            }
            case "boolean": {
                message.putBooleanProperty(key, Boolean.parseBoolean(value));
                break;
            }
            case "byte": {
                message.putByteProperty(key, Byte.parseByte(value));
                break;
            }
            case "bytes": {
                message.putBytesProperty(key, XmlDataImporter.decode(value));
                break;
            }
            case "double": {
                message.putDoubleProperty(key, Double.parseDouble(value));
                break;
            }
            case "float": {
                message.putFloatProperty(key, Float.parseFloat(value));
                break;
            }
            case "integer": {
                message.putIntProperty(key, Integer.parseInt(value));
                break;
            }
            case "long": {
                message.putLongProperty(key, Long.parseLong(value));
                break;
            }
            case "simple-string": {
                if (!value.equals("_AMQ_NULL")) {
                    realValue = value;
                }
                message.putStringProperty(new SimpleString(key), new SimpleString(realValue));
                break;
            }
            case "string": {
                if (!value.equals("_AMQ_NULL")) {
                    realValue = value;
                }
                message.putStringProperty(key, realValue);
            }
        }
    }

    private void processMessageBody(Message message) throws XMLStreamException, IOException {
        Object attributeName;
        boolean isLarge = false;
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            attributeName = this.reader.getAttributeLocalName(i);
            if (!"isLarge".equals(attributeName)) continue;
            isLarge = Boolean.parseBoolean(this.reader.getAttributeValue(i));
        }
        this.reader.next();
        if (isLarge) {
            this.tempFileName = UUID.randomUUID().toString() + ".tmp";
            ActiveMQServerLogger.LOGGER.debug((Object)("Creating temp file " + this.tempFileName + " for large message."));
            FileOutputStream out = new FileOutputStream(this.tempFileName);
            attributeName = null;
            try {
                while (this.reader.hasNext()) {
                    if (this.reader.getEventType() == 2) {
                        break;
                    }
                    String characters = new String(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
                    String trimmedCharacters = characters.trim();
                    if (trimmedCharacters.length() > 0) {
                        byte[] data = XmlDataImporter.decode(trimmedCharacters);
                        ((OutputStream)out).write(data);
                    }
                    this.reader.next();
                }
            }
            catch (Throwable throwable) {
                attributeName = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (attributeName != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)attributeName).addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)out).close();
                    }
                }
            }
            FileInputStream fileInputStream = new FileInputStream(this.tempFileName);
            BufferedInputStream bufferedInput = new BufferedInputStream(fileInputStream);
            ((ClientMessage)message).setBodyInputStream((InputStream)bufferedInput);
        } else {
            this.reader.next();
            String characters = new String(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
            message.getBodyBuffer().writeBytes(XmlDataImporter.decode(characters.trim()));
        }
    }

    private void bindQueue() throws Exception {
        String queueName = "";
        String address = "";
        String filter = "";
        block10: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName;
            switch (attributeName = this.reader.getAttributeLocalName(i)) {
                case "address": {
                    address = this.reader.getAttributeValue(i);
                    continue block10;
                }
                case "queue-name": {
                    queueName = this.reader.getAttributeValue(i);
                    continue block10;
                }
                case "filter-string": {
                    filter = this.reader.getAttributeValue(i);
                }
            }
        }
        ClientSession.QueueQuery queueQuery = this.session.queueQuery(new SimpleString(queueName));
        if (!queueQuery.isExists()) {
            this.session.createQueue(address, queueName, filter, true);
            ActiveMQServerLogger.LOGGER.debug((Object)("Binding queue(name=" + queueName + ", address=" + address + ", filter=" + filter + ")"));
        } else {
            ActiveMQServerLogger.LOGGER.debug((Object)("Binding " + queueName + " already exists so won't re-bind."));
        }
        this.addressMap.put(queueName, address);
    }

    private void createJmsConnectionFactories() throws Exception {
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if (!"jms-connection-factory".equals(this.reader.getLocalName())) break;
                    this.createJmsConnectionFactory();
                    break;
                }
                case 2: {
                    if (!"jms-connection-factories".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
    }

    private void createJmsDestinations() throws Exception {
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if (!"jms-destination".equals(this.reader.getLocalName())) break;
                    this.createJmsDestination();
                    break;
                }
                case 2: {
                    if (!"jms-destinations".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
    }

    private void createJmsConnectionFactory() throws Exception {
        String name = "";
        String callFailoverTimeout = "";
        String callTimeout = "";
        String clientFailureCheckPeriod = "";
        String clientId = "";
        String confirmationWindowSize = "";
        String connectionTtl = "";
        String connectors = "";
        String consumerMaxRate = "";
        String consumerWindowSize = "";
        String discoveryGroupName = "";
        String dupsOkBatchSize = "";
        String groupId = "";
        String loadBalancingPolicyClassName = "";
        String maxRetryInterval = "";
        String minLargeMessageSize = "";
        String producerMaxRate = "";
        String producerWindowSize = "";
        String reconnectAttempts = "";
        String retryInterval = "";
        String retryIntervalMultiplier = "";
        String scheduledThreadMaxPoolSize = "";
        String threadMaxPoolSize = "";
        String transactionBatchSize = "";
        String type = "";
        String entries = "";
        String autoGroup = "";
        String blockOnAcknowledge = "";
        String blockOnDurableSend = "";
        String blockOnNonDurableSend = "";
        String cacheLargeMessagesClient = "";
        String compressLargeMessages = "";
        String failoverOnInitialConnection = "";
        String ha = "";
        String preacknowledge = "";
        String useGlobalPools = "";
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if ("call-failover-timeout".equals(this.reader.getLocalName())) {
                        callFailoverTimeout = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory callFailoverTimeout: " + callFailoverTimeout));
                        break;
                    }
                    if ("call-timeout".equals(this.reader.getLocalName())) {
                        callTimeout = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory callTimeout: " + callTimeout));
                        break;
                    }
                    if ("client-failure-check-period".equals(this.reader.getLocalName())) {
                        clientFailureCheckPeriod = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory clientFailureCheckPeriod: " + clientFailureCheckPeriod));
                        break;
                    }
                    if ("client-id".equals(this.reader.getLocalName())) {
                        clientId = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory clientId: " + clientId));
                        break;
                    }
                    if ("confirmation-window-size".equals(this.reader.getLocalName())) {
                        confirmationWindowSize = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory confirmationWindowSize: " + confirmationWindowSize));
                        break;
                    }
                    if ("connection-ttl".equals(this.reader.getLocalName())) {
                        connectionTtl = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory connectionTtl: " + connectionTtl));
                        break;
                    }
                    if ("connector".equals(this.reader.getLocalName())) {
                        connectors = this.getConnectors();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory getLocalName: " + connectors));
                        break;
                    }
                    if ("consumer-max-rate".equals(this.reader.getLocalName())) {
                        consumerMaxRate = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory consumerMaxRate: " + consumerMaxRate));
                        break;
                    }
                    if ("consumer-window-size".equals(this.reader.getLocalName())) {
                        consumerWindowSize = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory consumerWindowSize: " + consumerWindowSize));
                        break;
                    }
                    if ("discovery-group-name".equals(this.reader.getLocalName())) {
                        discoveryGroupName = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory discoveryGroupName: " + discoveryGroupName));
                        break;
                    }
                    if ("dups-ok-batch-size".equals(this.reader.getLocalName())) {
                        dupsOkBatchSize = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory dupsOkBatchSize: " + dupsOkBatchSize));
                        break;
                    }
                    if ("group-id".equals(this.reader.getLocalName())) {
                        groupId = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory groupId: " + groupId));
                        break;
                    }
                    if ("load-balancing-policy-class-name".equals(this.reader.getLocalName())) {
                        loadBalancingPolicyClassName = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory loadBalancingPolicyClassName: " + loadBalancingPolicyClassName));
                        break;
                    }
                    if ("max-retry-interval".equals(this.reader.getLocalName())) {
                        maxRetryInterval = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory maxRetryInterval: " + maxRetryInterval));
                        break;
                    }
                    if ("min-large-message-size".equals(this.reader.getLocalName())) {
                        minLargeMessageSize = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory minLargeMessageSize: " + minLargeMessageSize));
                        break;
                    }
                    if ("name".equals(this.reader.getLocalName())) {
                        name = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory name: " + name));
                        break;
                    }
                    if ("producer-max-rate".equals(this.reader.getLocalName())) {
                        producerMaxRate = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory producerMaxRate: " + producerMaxRate));
                        break;
                    }
                    if ("producer-window-size".equals(this.reader.getLocalName())) {
                        producerWindowSize = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory producerWindowSize: " + producerWindowSize));
                        break;
                    }
                    if ("reconnect-attempts".equals(this.reader.getLocalName())) {
                        reconnectAttempts = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory reconnectAttempts: " + reconnectAttempts));
                        break;
                    }
                    if ("retry-interval".equals(this.reader.getLocalName())) {
                        retryInterval = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory retryInterval: " + retryInterval));
                        break;
                    }
                    if ("retry-interval-multiplier".equals(this.reader.getLocalName())) {
                        retryIntervalMultiplier = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory retryIntervalMultiplier: " + retryIntervalMultiplier));
                        break;
                    }
                    if ("scheduled-thread-pool-max-size".equals(this.reader.getLocalName())) {
                        scheduledThreadMaxPoolSize = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory scheduledThreadMaxPoolSize: " + scheduledThreadMaxPoolSize));
                        break;
                    }
                    if ("thread-pool-max-size".equals(this.reader.getLocalName())) {
                        threadMaxPoolSize = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory threadMaxPoolSize: " + threadMaxPoolSize));
                        break;
                    }
                    if ("transaction-batch-size".equals(this.reader.getLocalName())) {
                        transactionBatchSize = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory transactionBatchSize: " + transactionBatchSize));
                        break;
                    }
                    if ("type".equals(this.reader.getLocalName())) {
                        type = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory type: " + type));
                        break;
                    }
                    if ("entries".equals(this.reader.getLocalName())) {
                        entries = this.getEntries();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory entries: " + entries));
                        break;
                    }
                    if ("auto-group".equals(this.reader.getLocalName())) {
                        autoGroup = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory autoGroup: " + autoGroup));
                        break;
                    }
                    if ("block-on-acknowledge".equals(this.reader.getLocalName())) {
                        blockOnAcknowledge = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory blockOnAcknowledge: " + blockOnAcknowledge));
                        break;
                    }
                    if ("block-on-durable-send".equals(this.reader.getLocalName())) {
                        blockOnDurableSend = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory blockOnDurableSend: " + blockOnDurableSend));
                        break;
                    }
                    if ("block-on-non-durable-send".equals(this.reader.getLocalName())) {
                        blockOnNonDurableSend = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory blockOnNonDurableSend: " + blockOnNonDurableSend));
                        break;
                    }
                    if ("cache-large-messages-client".equals(this.reader.getLocalName())) {
                        cacheLargeMessagesClient = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.info((Object)("JMS connection factory " + name + " cacheLargeMessagesClient: " + cacheLargeMessagesClient));
                        break;
                    }
                    if ("compress-large-messages".equals(this.reader.getLocalName())) {
                        compressLargeMessages = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory compressLargeMessages: " + compressLargeMessages));
                        break;
                    }
                    if ("failover-on-initial-connection".equals(this.reader.getLocalName())) {
                        failoverOnInitialConnection = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory failoverOnInitialConnection: " + failoverOnInitialConnection));
                        break;
                    }
                    if ("ha".equals(this.reader.getLocalName())) {
                        ha = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory ha: " + ha));
                        break;
                    }
                    if ("preacknowledge".equals(this.reader.getLocalName())) {
                        preacknowledge = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory preacknowledge: " + preacknowledge));
                        break;
                    }
                    if (!"use-global-pools".equals(this.reader.getLocalName())) break;
                    useGlobalPools = this.reader.getElementText();
                    ActiveMQServerLogger.LOGGER.debug((Object)("JMS connection factory useGlobalPools: " + useGlobalPools));
                    break;
                }
                case 2: {
                    if (!"jms-connection-factory".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
        ClientRequestor requestor = new ClientRequestor(this.managementSession, "jms.queue.activemq.management");
        ClientMessage managementMessage = this.managementSession.createMessage(false);
        ManagementHelper.putOperationInvocation((Message)managementMessage, (String)"jms.server", (String)"createConnectionFactory", (Object[])new Object[]{name, Boolean.parseBoolean(ha), discoveryGroupName.length() > 0, Integer.parseInt(type), connectors, entries, clientId, Long.parseLong(clientFailureCheckPeriod), Long.parseLong(connectionTtl), Long.parseLong(callTimeout), Long.parseLong(callFailoverTimeout), Integer.parseInt(minLargeMessageSize), Boolean.parseBoolean(compressLargeMessages), Integer.parseInt(consumerWindowSize), Integer.parseInt(consumerMaxRate), Integer.parseInt(confirmationWindowSize), Integer.parseInt(producerWindowSize), Integer.parseInt(producerMaxRate), Boolean.parseBoolean(blockOnAcknowledge), Boolean.parseBoolean(blockOnDurableSend), Boolean.parseBoolean(blockOnNonDurableSend), Boolean.parseBoolean(autoGroup), Boolean.parseBoolean(preacknowledge), loadBalancingPolicyClassName, Integer.parseInt(transactionBatchSize), Integer.parseInt(dupsOkBatchSize), Boolean.parseBoolean(useGlobalPools), Integer.parseInt(scheduledThreadMaxPoolSize), Integer.parseInt(threadMaxPoolSize), Long.parseLong(retryInterval), Double.parseDouble(retryIntervalMultiplier), Long.parseLong(maxRetryInterval), Integer.parseInt(reconnectAttempts), Boolean.parseBoolean(failoverOnInitialConnection), groupId});
        this.managementSession.start();
        ClientMessage reply = requestor.request(managementMessage);
        if (ManagementHelper.hasOperationSucceeded((Message)reply)) {
            ActiveMQServerLogger.LOGGER.debug((Object)("Created connection factory " + name));
        } else {
            ActiveMQServerLogger.LOGGER.error((Object)("Problem creating " + name));
        }
        requestor.close();
    }

    private void createJmsDestination() throws Exception {
        String name = "";
        String selector = "";
        String entries = "";
        String type = "";
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if ("name".equals(this.reader.getLocalName())) {
                        name = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS destination name: " + name));
                        break;
                    }
                    if ("selector".equals(this.reader.getLocalName())) {
                        selector = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS destination selector: " + selector));
                        break;
                    }
                    if ("type".equals(this.reader.getLocalName())) {
                        type = this.reader.getElementText();
                        ActiveMQServerLogger.LOGGER.debug((Object)("JMS destination type: " + type));
                        break;
                    }
                    if (!"entries".equals(this.reader.getLocalName())) break;
                    entries = this.getEntries();
                    break;
                }
                case 2: {
                    if (!"jms-destination".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
        ClientRequestor requestor = new ClientRequestor(this.managementSession, "jms.queue.activemq.management");
        ClientMessage managementMessage = this.managementSession.createMessage(false);
        if ("Queue".equals(type)) {
            ManagementHelper.putOperationInvocation((Message)managementMessage, (String)"jms.server", (String)"createQueue", (Object[])new Object[]{name, entries, selector});
        } else if ("Topic".equals(type)) {
            ManagementHelper.putOperationInvocation((Message)managementMessage, (String)"jms.server", (String)"createTopic", (Object[])new Object[]{name, entries});
        }
        this.managementSession.start();
        ClientMessage reply = requestor.request(managementMessage);
        if (ManagementHelper.hasOperationSucceeded((Message)reply)) {
            ActiveMQServerLogger.LOGGER.debug((Object)("Created " + type.toLowerCase() + " " + name));
        } else {
            ActiveMQServerLogger.LOGGER.error((Object)("Problem creating " + name));
        }
        requestor.close();
    }

    private String getEntries() throws Exception {
        StringBuilder entry = new StringBuilder();
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if (!"entry".equals(this.reader.getLocalName())) break;
                    String elementText = this.reader.getElementText();
                    entry.append(elementText).append(", ");
                    ActiveMQServerLogger.LOGGER.debug((Object)("JMS admin object JNDI entry: " + entry.toString()));
                    break;
                }
                case 2: {
                    if (!"entries".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
        return entry.delete(entry.length() - 2, entry.length()).toString();
    }

    private String getConnectors() throws Exception {
        StringBuilder entry = new StringBuilder();
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if (!"connector".equals(this.reader.getLocalName())) break;
                    entry.append(this.reader.getElementText()).append(", ");
                    break;
                }
                case 2: {
                    if (!"connectors".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
        return entry.delete(entry.length() - 2, entry.length()).toString();
    }

    private static byte[] decode(String data) {
        return Base64.decode((String)data, (int)24);
    }
}

