/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationBaseSenderController;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotImplementedException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.impl.SelectorParser;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Sender;

public final class AMQPFederationQueueSenderController
extends AMQPFederationBaseSenderController {
    public AMQPFederationQueueSenderController(AMQPSessionContext session) throws ActiveMQAMQPException {
        super(session);
    }

    @Override
    public Consumer init(ProtonServerSenderContext senderContext) throws Exception {
        String selector;
        SimpleString targetQueue;
        SimpleString targetAddress;
        Sender sender = senderContext.getSender();
        Source source = (Source)sender.getRemoteSource();
        if (this.federation == null) {
            throw new ActiveMQAMQPIllegalStateException("Cannot create a federation link from non-federation connection");
        }
        if (source == null) {
            throw new ActiveMQAMQPNotImplementedException("Null source lookup not supported on federation links.");
        }
        sender.setSenderSettleMode(sender.getRemoteSenderSettleMode());
        sender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        sender.setOfferedCapabilities(new Symbol[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER});
        sender.setDesiredCapabilities(new Symbol[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT});
        RoutingType routingType = AMQPFederationQueueSenderController.getRoutingType(source);
        if (CompositeAddress.isFullyQualified((String)source.getAddress())) {
            targetAddress = SimpleString.of((String)CompositeAddress.extractAddressName((String)source.getAddress()));
            targetQueue = SimpleString.of((String)CompositeAddress.extractQueueName((String)source.getAddress()));
        } else {
            targetAddress = null;
            targetQueue = SimpleString.of((String)source.getAddress());
        }
        QueueQueryResult result = this.sessionSPI.queueQuery(targetQueue, routingType, false, null);
        if (!result.isExists()) {
            this.federation.registerMissingQueue(targetQueue.toString());
            throw new ActiveMQAMQPNotFoundException("Queue: '" + targetQueue + "' does not exist");
        }
        if (targetAddress != null && !result.getAddress().equals((Object)targetAddress)) {
            this.federation.registerMissingQueue(targetQueue.toString());
            throw new ActiveMQAMQPNotFoundException("Queue: '" + targetQueue + "' is not mapped to specified address: " + targetAddress);
        }
        Map.Entry<Symbol, DescribedType> filter = AmqpSupport.findFilter(source.getFilter(), AmqpSupport.JMS_SELECTOR_FILTER_IDS);
        if (filter != null) {
            String filterString = filter.getValue().getDescribed().toString();
            try {
                SelectorParser.parse((String)filterString);
            }
            catch (FilterException e2) {
                throw new ActiveMQAMQPException(AmqpError.INVALID_FIELD, "Invalid filter", ActiveMQExceptionType.INVALID_FILTER_EXPRESSION);
            }
            selector = result.getFilterString() == null || !filterString.equals(result.getFilterString().toString()) ? filterString : null;
        } else {
            selector = null;
        }
        this.tunnelCoreMessages = AmqpSupport.verifyOfferedCapabilities((Link)sender, AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT);
        this.resourceDeletedAction = e -> this.federation.registerMissingQueue(targetQueue.toString());
        this.registerRemoteLinkClosedInterceptor(sender);
        return this.sessionSPI.createSender(senderContext, targetQueue, selector, false);
    }

    private static RoutingType getRoutingType(Source source) {
        if (source != null && source.getCapabilities() != null) {
            for (Symbol capability : source.getCapabilities()) {
                if (AmqpSupport.TOPIC_CAPABILITY.equals(capability)) {
                    return RoutingType.MULTICAST;
                }
                if (!AmqpSupport.QUEUE_CAPABILITY.equals(capability)) continue;
                return RoutingType.ANYCAST;
            }
        }
        return ActiveMQDefaultConfiguration.getDefaultRoutingType();
    }
}

