/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.client.ProtonClientSenderContext;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerReceiverContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.transaction.ProtonTransactionHandler;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transaction.Coordinator;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.jboss.logging.Logger;

public class AMQPSessionContext
extends ProtonInitializable {
    private static final Logger log = Logger.getLogger(AMQPSessionContext.class);
    protected final AMQPConnectionContext connection;
    protected final AMQPSessionCallback sessionSPI;
    protected final Session session;
    private long currentTag = 0L;
    protected Map<Receiver, ProtonServerReceiverContext> receivers = new ConcurrentHashMap<Receiver, ProtonServerReceiverContext>();
    protected Map<Sender, ProtonServerSenderContext> senders = new ConcurrentHashMap<Sender, ProtonServerSenderContext>();
    protected boolean closed = false;
    protected Map<Object, ProtonServerSenderContext> serverSenders = new ConcurrentHashMap<Object, ProtonServerSenderContext>();

    public AMQPSessionContext(AMQPSessionCallback sessionSPI, AMQPConnectionContext connection, Session session) {
        this.connection = connection;
        this.sessionSPI = sessionSPI;
        this.session = session;
    }

    @Override
    public void initialise() throws Exception {
        if (!this.isInitialized()) {
            super.initialise();
            if (this.sessionSPI != null) {
                try {
                    this.sessionSPI.init(this, this.connection.getSASLResult());
                }
                catch (Exception e) {
                    throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                }
            }
        }
    }

    public void disconnect(Object consumer, String queueName) {
        ProtonServerSenderContext protonConsumer = this.senders.remove(consumer);
        if (protonConsumer != null) {
            try {
                protonConsumer.close(false);
            }
            catch (ActiveMQAMQPException e) {
                protonConsumer.getSender().setTarget(null);
                protonConsumer.getSender().setCondition(new ErrorCondition(e.getAmqpError(), e.getMessage()));
            }
        }
    }

    public byte[] getTag() {
        return Long.toHexString(this.currentTag++).getBytes();
    }

    public void replaceTag(byte[] tag) {
    }

    public void close() {
        if (this.closed) {
            return;
        }
        HashSet<ProtonServerReceiverContext> receiversCopy = new HashSet<ProtonServerReceiverContext>();
        receiversCopy.addAll(this.receivers.values());
        for (ProtonServerReceiverContext protonServerReceiverContext : receiversCopy) {
            try {
                protonServerReceiverContext.close(false);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.receivers.clear();
        HashSet<ProtonServerSenderContext> protonSendersClone = new HashSet<ProtonServerSenderContext>();
        protonSendersClone.addAll(this.senders.values());
        for (ProtonServerSenderContext protonConsumer : protonSendersClone) {
            try {
                protonConsumer.close(false);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.senders.clear();
        try {
            if (this.sessionSPI != null) {
                this.sessionSPI.close();
            }
        }
        catch (Exception exception) {
            log.warn((Object)exception.getMessage(), (Throwable)exception);
        }
        this.closed = true;
    }

    public void removeReceiver(Receiver receiver) {
        this.receivers.remove(receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransactionHandler(Coordinator coordinator, Receiver receiver) {
        ProtonTransactionHandler transactionHandler = new ProtonTransactionHandler(this.sessionSPI, this.connection);
        coordinator.setCapabilities(new Symbol[]{Symbol.getSymbol((String)"amqp:local-transactions"), Symbol.getSymbol((String)"amqp:multi-txns-per-ssn"), Symbol.getSymbol((String)"amqp:multi-ssns-per-txn")});
        receiver.setContext((Object)transactionHandler);
        this.connection.lock();
        try {
            receiver.open();
            receiver.flow(this.connection.getAmqpCredits());
        }
        finally {
            this.connection.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSender(Sender sender) throws Exception {
        boolean outgoing = sender.getContext() != null && sender.getContext().equals(true);
        ProtonServerSenderContext protonSender = outgoing ? new ProtonClientSenderContext(this.connection, sender, this, this.sessionSPI) : new ProtonServerSenderContext(this.connection, sender, this, this.sessionSPI);
        try {
            protonSender.initialise();
            this.senders.put(sender, protonSender);
            this.serverSenders.put(protonSender.getBrokerConsumer(), protonSender);
            sender.setContext((Object)protonSender);
            this.connection.lock();
            try {
                sender.open();
            }
            finally {
                this.connection.unlock();
            }
            protonSender.start();
        }
        catch (ActiveMQAMQPException e) {
            this.senders.remove(sender);
            sender.setSource(null);
            sender.setCondition(new ErrorCondition(e.getAmqpError(), e.getMessage()));
            this.connection.lock();
            try {
                sender.close();
            }
            finally {
                this.connection.unlock();
            }
        }
    }

    public void removeSender(Sender sender) throws ActiveMQAMQPException {
        this.senders.remove(sender);
        ProtonServerSenderContext senderRemoved = this.senders.remove(sender);
        if (senderRemoved != null) {
            this.serverSenders.remove(senderRemoved.getBrokerConsumer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReceiver(Receiver receiver) throws Exception {
        try {
            ProtonServerReceiverContext protonReceiver = new ProtonServerReceiverContext(this.sessionSPI, this.connection, this, receiver);
            protonReceiver.initialise();
            this.receivers.put(receiver, protonReceiver);
            receiver.setContext((Object)protonReceiver);
            this.connection.lock();
            try {
                receiver.open();
            }
            finally {
                this.connection.unlock();
            }
        }
        catch (ActiveMQAMQPException e) {
            this.receivers.remove(receiver);
            receiver.setTarget(null);
            receiver.setCondition(new ErrorCondition(e.getAmqpError(), e.getMessage()));
            this.connection.lock();
            try {
                receiver.close();
            }
            finally {
                this.connection.unlock();
            }
        }
    }
}

