/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;

public class AMQPMessagePersister
extends MessagePersister {
    public static AMQPMessagePersister theInstance = new AMQPMessagePersister();

    public static AMQPMessagePersister getInstance() {
        return theInstance;
    }

    private AMQPMessagePersister() {
    }

    protected byte getID() {
        return 2;
    }

    public int getEncodeSize(Message record) {
        return 1 + record.getPersistSize() + SimpleString.sizeofNullableString((SimpleString)record.getAddressSimpleString()) + 8 + 8;
    }

    public void encode(ActiveMQBuffer buffer, Message record) {
        super.encode(buffer, record);
        AMQPMessage msgEncode = (AMQPMessage)record;
        buffer.writeLong(record.getMessageID());
        buffer.writeLong(msgEncode.getMessageFormat());
        buffer.writeNullableSimpleString(record.getAddressSimpleString());
        record.persist(buffer);
    }

    public Message decode(ActiveMQBuffer buffer, Message record) {
        long id = buffer.readLong();
        long format = buffer.readLong();
        SimpleString address = buffer.readNullableSimpleString();
        record = new AMQPMessage(format);
        record.reloadPersistence(buffer);
        record.setMessageID(id);
        if (address != null) {
            record.setAddress(address);
        }
        return record;
    }
}

