/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="4.14.0", label="dataformat,transformation,finance", title="ISO-8583")
@XmlRootElement(name="iso8583")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Iso8583DataFormat
extends DataFormatDefinition {
    @XmlAttribute
    @Metadata(description="The j8583 configuration file to load from classpath", defaultValue="j8583-config.xml")
    private String configFile;
    @XmlAttribute
    @Metadata(description="The default ISO-Type to use")
    private String isoType;
    @XmlAttribute
    @Metadata(label="advanced", description="Whether to auto-discover com.solab.iso8583.MessageFactory from the registry", defaultValue="true", javaType="java.lang.Boolean")
    private String allowAutoWiredMessageFormat;

    public Iso8583DataFormat() {
        super("iso8583");
    }

    public Iso8583DataFormat(Iso8583DataFormat source) {
        super(source);
        this.configFile = source.configFile;
        this.isoType = source.isoType;
        this.allowAutoWiredMessageFormat = source.allowAutoWiredMessageFormat;
    }

    private Iso8583DataFormat(Builder builder) {
        this.configFile = builder.configFile;
        this.isoType = builder.isoType;
        this.allowAutoWiredMessageFormat = builder.allowAutoWiredMessageFormat;
    }

    @Override
    public Iso8583DataFormat copyDefinition() {
        return new Iso8583DataFormat(this);
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getIsoType() {
        return this.isoType;
    }

    public void setIsoType(String isoType) {
        this.isoType = isoType;
    }

    public String getAllowAutoWiredMessageFormat() {
        return this.allowAutoWiredMessageFormat;
    }

    public void setAllowAutoWiredMessageFormat(String allowAutoWiredMessageFormat) {
        this.allowAutoWiredMessageFormat = allowAutoWiredMessageFormat;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<Iso8583DataFormat> {
        private String configFile;
        private String isoType;
        private String allowAutoWiredMessageFormat;

        public Builder configFile(String configFile) {
            this.configFile = configFile;
            return this;
        }

        public Builder isoType(String isoType) {
            this.isoType = isoType;
            return this;
        }

        public Builder allowAutoWiredMessageFormat(String allowAutoWiredMessageFormat) {
            this.allowAutoWiredMessageFormat = allowAutoWiredMessageFormat;
            return this;
        }

        @Override
        public Iso8583DataFormat end() {
            return new Iso8583DataFormat(this);
        }
    }
}

