/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.xmpp;

import ietf.params.xml.ns.xmpp_session.ObjectFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import javax.net.SocketFactory;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.tcp.TcpBufferedInputStream;
import org.apache.activemq.transport.tcp.TcpBufferedOutputStream;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.transport.xmpp.ProtocolConverter;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.wireformat.WireFormat;
import org.jabber.etherx.streams.Features;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppTransport
extends TcpTransport {
    protected static final QName ATTRIBUTE_TO = new QName("to");
    private static final transient Logger LOG = LoggerFactory.getLogger(XmppTransport.class);
    protected OutputStream outputStream;
    protected InputStream inputStream;
    private static JAXBContext context;
    private XMLEventReader xmlReader;
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;
    private XMLStreamWriter xmlWriter;
    private String to = "client";
    private ProtocolConverter converter;
    private String from = "localhost";
    private String brokerId = "broker-id-1";

    public XmppTransport(WireFormat wireFormat, Socket socket) throws IOException {
        super(wireFormat, socket);
        this.init();
    }

    public XmppTransport(WireFormat wireFormat, SocketFactory socketFactory, URI uri, URI uri1) throws IOException {
        super(wireFormat, socketFactory, uri, uri1);
        this.init();
    }

    private void init() {
        LOG.debug("Creating new instance of XmppTransport");
        this.converter = new ProtocolConverter(this);
    }

    public void oneway(Object object) throws IOException {
        if (object instanceof Command) {
            Command command = (Command)object;
            if (command instanceof BrokerInfo) {
                BrokerInfo brokerInfo = (BrokerInfo)command;
                this.brokerId = brokerInfo.getBrokerId().toString();
                this.from = brokerInfo.getBrokerName();
                try {
                    this.writeOpenStream(this.brokerId, this.from);
                }
                catch (XMLStreamException e) {
                    throw IOExceptionSupport.create((Exception)e);
                }
            } else {
                try {
                    this.converter.onActiveMQCommand(command);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw IOExceptionSupport.create((Exception)e);
                }
            }
        } else {
            LOG.warn("Unkown command: " + object);
        }
    }

    public void marshall(Object command) throws IOException {
        if (this.isStopped() || this.isStopping()) {
            LOG.warn("Not marshalling command as shutting down: " + command);
            return;
        }
        try {
            this.marshaller.marshal(command, this.xmlWriter);
            this.xmlWriter.flush();
            this.outputStream.flush();
        }
        catch (JAXBException e) {
            throw IOExceptionSupport.create((Exception)((Object)e));
        }
        catch (XMLStreamException e) {
            throw IOExceptionSupport.create((Exception)e);
        }
    }

    public void doRun() throws IOException {
        LOG.debug("XMPP consumer thread starting");
        try {
            StartElement startElement;
            Attribute toAttribute;
            XMLInputFactory xif = XMLInputFactory.newInstance();
            xif.setXMLReporter(new XMLReporter(){

                public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
                    LOG.warn(message + " errorType: " + errorType + " relatedInfo: " + relatedInformation);
                }
            });
            this.xmlReader = xif.createXMLEventReader(this.inputStream);
            XMLEvent docStart = this.xmlReader.nextEvent();
            XMLEvent rootElement = this.xmlReader.nextTag();
            if (rootElement instanceof StartElement && (toAttribute = (startElement = (StartElement)rootElement).getAttributeByName(ATTRIBUTE_TO)) != null) {
                this.to = toAttribute.getValue();
            }
            while (!this.isStopped()) {
                XMLEvent event = this.xmlReader.peek();
                if (event.isStartElement()) {
                    Object object = this.unmarshaller.unmarshal(this.xmlReader);
                    if (object == null) continue;
                    LOG.debug("Unmarshalled new incoming event - " + object.getClass().getName());
                    this.converter.onXmppCommand(object);
                    continue;
                }
                if (event.getEventType() != 2 && event.getEventType() != 2 && event.getEventType() != 8) {
                    this.xmlReader.nextEvent();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw IOExceptionSupport.create((Exception)e);
        }
    }

    public String getFrom() {
        return this.from;
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        if (this.xmlWriter != null) {
            try {
                this.xmlWriter.writeEndElement();
                this.xmlWriter.writeEndDocument();
                this.xmlWriter.close();
            }
            catch (XMLStreamException e) {
                LOG.info("Caught trying to close transport: " + e, (Throwable)e);
            }
        }
        if (this.xmlReader != null) {
            try {
                this.xmlReader.close();
            }
            catch (XMLStreamException e) {
                LOG.info("Caught trying to close transport: " + e, (Throwable)e);
            }
        }
        super.doStop(stopper);
    }

    protected void initializeStreams() throws Exception {
        if (context == null) {
            context = JAXBContext.newInstance((String)"jabber.server:jabber.server.dialback:jabber.client:jabber.iq._private:jabber.iq.auth:jabber.iq.gateway:jabber.iq.version:jabber.iq.roster:jabber.iq.pass:jabber.iq.last:jabber.iq.oob:jabber.iq.time:storage.rosternotes:ietf.params.xml.ns.xmpp_streams:ietf.params.xml.ns.xmpp_sasl:ietf.params.xml.ns.xmpp_stanzas:ietf.params.xml.ns.xmpp_bind:ietf.params.xml.ns.xmpp_tls:org.jabber.protocol.muc:org.jabber.protocol.rosterx:org.jabber.protocol.disco_info:org.jabber.protocol.disco_items:org.jabber.protocol.activity:org.jabber.protocol.amp_errors:org.jabber.protocol.amp:org.jabber.protocol.address:org.jabber.protocol.muc_user:org.jabber.protocol.muc_admin:org.jabber.etherx.streams");
        }
        this.inputStream = new TcpBufferedInputStream(this.socket.getInputStream(), 8192);
        this.outputStream = new TcpBufferedOutputStream(this.socket.getOutputStream(), 16384);
        this.unmarshaller = context.createUnmarshaller();
        this.marshaller = context.createMarshaller();
        this.marshaller.setProperty("jaxb.fragment", (Object)true);
    }

    protected void writeOpenStream(String id, String from) throws IOException, XMLStreamException {
        LOG.debug("Sending initial stream element");
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.xmlWriter = factory.createXMLStreamWriter(this.outputStream);
        this.xmlWriter.writeStartDocument();
        this.xmlWriter.writeStartElement("stream", "stream", "http://etherx.jabber.org/streams");
        this.xmlWriter.writeDefaultNamespace("jabber:client");
        this.xmlWriter.writeNamespace("stream", "http://etherx.jabber.org/streams");
        this.xmlWriter.writeAttribute("version", "1.0");
        this.xmlWriter.writeAttribute("id", id);
        if (this.to == null) {
            this.to = "client";
        }
        this.xmlWriter.writeAttribute("to", this.to);
        this.xmlWriter.writeAttribute("from", from);
        Features features = new Features();
        features.getAny().add(new ietf.params.xml.ns.xmpp_bind.ObjectFactory().createBind());
        features.getAny().add(new ObjectFactory().createSession(""));
        this.marshall(features);
        LOG.debug("Initial stream element sent!");
    }
}

