/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.activemq.MessageAvailableConsumer;
import org.apache.activemq.MessageAvailableListener;
import org.apache.activemq.web.MessageServletSupport;
import org.apache.activemq.web.WebClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageListenerServlet
extends MessageServletSupport {
    private static final Log LOG = LogFactory.getLog(MessageListenerServlet.class);
    private String readTimeoutParameter = "timeout";
    private long defaultReadTimeout = -1L;
    private long maximumReadTimeout = 25000L;
    private int maximumMessages = 100;

    public void init() throws ServletException {
        ServletConfig servletConfig = this.getServletConfig();
        String name = servletConfig.getInitParameter("defaultReadTimeout");
        if (name != null) {
            this.defaultReadTimeout = this.asLong(name);
        }
        if ((name = servletConfig.getInitParameter("maximumReadTimeout")) != null) {
            this.maximumReadTimeout = this.asLong(name);
        }
        if ((name = servletConfig.getInitParameter("maximumMessages")) != null) {
            this.maximumMessages = (int)this.asLong(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebClient client = WebClient.getWebClient(request);
        String messageIds = "";
        WebClient webClient = client;
        synchronized (webClient) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("POST client=" + client + " session=" + request.getSession().getId() + " info=" + request.getPathInfo() + " contentType=" + request.getContentType()));
            }
            int messages = 0;
            while (true) {
                String destinationName;
                if ((destinationName = request.getParameter(messages == 0 ? "destination" : "d" + messages)) == null) {
                    destinationName = request.getHeader("destination");
                }
                String message = request.getParameter(messages == 0 ? "message" : "m" + messages);
                String type = request.getParameter(messages == 0 ? "type" : "t" + messages);
                if (destinationName == null || message == null || type == null) break;
                try {
                    Destination destination = this.getDestination(client, request, destinationName);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(messages + " destination=" + destinationName + " message=" + message + " type=" + type));
                        LOG.debug((Object)(destination + " is a " + destination.getClass().getName()));
                    }
                    ++messages;
                    if ("listen".equals(type)) {
                        Listener listener = this.getListener(request);
                        Map<MessageAvailableConsumer, String> consumerIdMap = this.getConsumerIdMap(request);
                        Map<MessageAvailableConsumer, String> consumerDestinationMap = this.getConsumerDestinationNameMap(request);
                        client.closeConsumer(destination);
                        MessageAvailableConsumer consumer = (MessageAvailableConsumer)client.getConsumer(destination, request.getHeader(WebClient.selectorName));
                        consumer.setAvailableListener((MessageAvailableListener)listener);
                        consumerIdMap.put(consumer, message);
                        consumerDestinationMap.put(consumer, destinationName);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Subscribed: " + consumer + " to " + destination + " id=" + message));
                        continue;
                    }
                    if ("unlisten".equals(type)) {
                        Map<MessageAvailableConsumer, String> consumerIdMap = this.getConsumerIdMap(request);
                        Map<MessageAvailableConsumer, String> consumerDestinationMap = this.getConsumerDestinationNameMap(request);
                        MessageAvailableConsumer consumer = (MessageAvailableConsumer)client.getConsumer(destination, request.getHeader(WebClient.selectorName));
                        consumer.setAvailableListener(null);
                        consumerIdMap.remove(consumer);
                        consumerDestinationMap.remove(consumer);
                        client.closeConsumer(destination);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Unsubscribed: " + consumer));
                        continue;
                    }
                    if ("send".equals(type)) {
                        TextMessage text = client.getSession().createTextMessage(message);
                        this.appendParametersToMessage(request, text);
                        client.send(destination, (Message)text);
                        messageIds = messageIds + text.getJMSMessageID() + "\n";
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Sent " + message + " to " + destination));
                        continue;
                    }
                    LOG.warn((Object)("unknown type " + type));
                }
                catch (JMSException e) {
                    LOG.warn((Object)"jms", (Throwable)e);
                }
            }
        }
        if ("true".equals(request.getParameter("poll"))) {
            try {
                this.doMessages(client, request, response);
            }
            catch (JMSException e) {
                throw new ServletException("JMS problem: " + (Object)((Object)e), (Throwable)e);
            }
        }
        if (!(request.getContentLength() == 0 || request.getContentType() != null && request.getContentType().toLowerCase().startsWith("application/x-www-form-urlencoded"))) {
            try {
                Destination destination = this.getDestination(client, request);
                String body = this.getPostedMessageBody(request);
                TextMessage message = client.getSession().createTextMessage(body);
                this.appendParametersToMessage(request, message);
                client.send(destination, (Message)message);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Sent to destination: " + destination + " body: " + body));
                }
                messageIds = messageIds + message.getJMSMessageID() + "\n";
            }
            catch (JMSException e) {
                throw new ServletException((Throwable)e);
            }
        }
        response.setContentType("text/plain");
        response.setHeader("Cache-Control", "no-cache");
        response.getWriter().print(messageIds);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            WebClient client = WebClient.getWebClient(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("GET client=" + client + " session=" + request.getSession().getId() + " uri=" + request.getRequestURI() + " query=" + request.getQueryString()));
            }
            this.doMessages(client, request, response);
        }
        catch (JMSException e) {
            throw new ServletException("JMS problem: " + (Object)((Object)e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMessages(WebClient client, HttpServletRequest request, HttpServletResponse response) throws JMSException, IOException {
        int messages = 0;
        long timeout = this.getReadTimeout(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("doMessage timeout=" + timeout));
        }
        Message message = null;
        message = (Message)request.getAttribute("message");
        WebClient webClient = client;
        synchronized (webClient) {
            List<MessageConsumer> consumers = client.getConsumers();
            MessageAvailableConsumer consumer = (MessageAvailableConsumer)request.getAttribute("consumer");
            if (message == null) {
                for (int i = 0; message == null && i < consumers.size(); ++i) {
                    consumer = (MessageAvailableConsumer)consumers.get(i);
                    if (consumer.getAvailableListener() == null) continue;
                    message = consumer.receive(10L);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("received " + message + " from " + consumer));
                }
            }
            if (message == null) {
                Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                if (continuation.isExpired()) {
                    response.setStatus(200);
                    StringWriter swriter = new StringWriter();
                    PrintWriter writer = new PrintWriter(swriter);
                    writer.println("<ajax-response>");
                    writer.print("</ajax-response>");
                    writer.flush();
                    String m = swriter.toString();
                    response.getWriter().println(m);
                    return;
                }
                continuation.setTimeout(timeout);
                continuation.suspend();
                Listener listener = this.getListener(request);
                listener.setContinuation(continuation);
                return;
            }
            response.setContentType("text/xml");
            response.setHeader("Cache-Control", "no-cache");
            StringWriter swriter = new StringWriter();
            PrintWriter writer = new PrintWriter(swriter);
            Map<MessageAvailableConsumer, String> consumerIdMap = this.getConsumerIdMap(request);
            Map<MessageAvailableConsumer, String> consumerDestinationNameMap = this.getConsumerDestinationNameMap(request);
            response.setStatus(200);
            writer.println("<ajax-response>");
            if (message != null) {
                String id = consumerIdMap.get(consumer);
                String destinationName = consumerDestinationNameMap.get(consumer);
                this.writeMessageResponse(writer, message, id, destinationName);
                ++messages;
            }
            for (int i = 0; i < consumers.size() && messages < this.maximumMessages; ++i) {
                consumer = (MessageAvailableConsumer)consumers.get(i);
                if (consumer.getAvailableListener() == null) continue;
                while (messages < this.maximumMessages && (message = consumer.receiveNoWait()) != null) {
                    ++messages;
                    String id = consumerIdMap.get(consumer);
                    String destinationName = consumerDestinationNameMap.get(consumer);
                    this.writeMessageResponse(writer, message, id, destinationName);
                }
            }
            writer.print("</ajax-response>");
            writer.flush();
            String m = swriter.toString();
            response.getWriter().println(m);
        }
    }

    protected void writeMessageResponse(PrintWriter writer, Message message, String id, String destinationName) throws JMSException, IOException {
        writer.print("<response id='");
        writer.print(id);
        writer.print("'");
        if (destinationName != null) {
            writer.print(" destination='" + destinationName + "' ");
        }
        writer.print(">");
        if (message instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)message;
            String txt = textMsg.getText();
            if (txt.startsWith("<?")) {
                txt = txt.substring(txt.indexOf("?>") + 2);
            }
            writer.print(txt);
        } else if (message instanceof ObjectMessage) {
            ObjectMessage objectMsg = (ObjectMessage)message;
            Serializable object = objectMsg.getObject();
            writer.print(object.toString());
        }
        writer.println("</response>");
    }

    protected Listener getListener(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Listener listener = (Listener)session.getAttribute("mls.listener");
        if (listener == null) {
            listener = new Listener(WebClient.getWebClient(request));
            session.setAttribute("mls.listener", (Object)listener);
        }
        return listener;
    }

    protected Map<MessageAvailableConsumer, String> getConsumerIdMap(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        HashMap map = (HashMap)session.getAttribute("mls.consumerIdMap");
        if (map == null) {
            map = new HashMap();
            session.setAttribute("mls.consumerIdMap", map);
        }
        return map;
    }

    protected Map<MessageAvailableConsumer, String> getConsumerDestinationNameMap(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        HashMap map = (HashMap)session.getAttribute("mls.consumerDestinationNameMap");
        if (map == null) {
            map = new HashMap();
            session.setAttribute("mls.consumerDestinationNameMap", map);
        }
        return map;
    }

    protected boolean isRicoAjax(HttpServletRequest request) {
        String rico = request.getParameter("rico");
        return rico != null && rico.equals("true");
    }

    protected long getReadTimeout(HttpServletRequest request) {
        long answer = this.defaultReadTimeout;
        String name = request.getParameter(this.readTimeoutParameter);
        if (name != null) {
            answer = this.asLong(name);
        }
        if (answer < 0L || answer > this.maximumReadTimeout) {
            answer = this.maximumReadTimeout;
        }
        return answer;
    }

    private class Listener
    implements MessageAvailableListener {
        WebClient client;
        long lastAccess;
        Continuation continuation;

        Listener(WebClient client) {
            this.client = client;
        }

        public void access() {
            this.lastAccess = System.currentTimeMillis();
        }

        public synchronized void setContinuation(Continuation continuation) {
            this.continuation = continuation;
        }

        public synchronized void onMessageAvailable(MessageConsumer consumer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("message for " + consumer + "continuation=" + this.continuation));
            }
            if (this.continuation != null) {
                try {
                    Message message = consumer.receive(10L);
                    this.continuation.setAttribute("message", (Object)message);
                    this.continuation.setAttribute("consumer", (Object)consumer);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error receiving message " + e), (Throwable)e);
                }
                this.continuation.resume();
            } else if (System.currentTimeMillis() - this.lastAccess > 2L * MessageListenerServlet.this.maximumReadTimeout) {
                new Thread(){

                    public void run() {
                        Listener.this.client.closeConsumers();
                    }
                }.start();
            }
        }
    }
}

