/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import javax.jms.ConnectionFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.activemq.web.WebClient;
import org.apache.activemq.web.WebConsoleStarter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebConsoleStarter
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(WebConsoleStarter.class);

    public void contextInitialized(ServletContextEvent event) {
        LOG.debug("Initializing ActiveMQ WebConsole...");
        String webconsoleType = WebConsoleStarter.getWebconsoleType();
        ServletContext servletContext = event.getServletContext();
        WebApplicationContext context = this.createWebapplicationContext(servletContext, webconsoleType);
        this.initializeWebClient(servletContext, context);
        if ("embedded".equals(webconsoleType)) {
            String port = System.getProperty("jetty.port");
            String host = System.getProperty("jetty.host");
            if (host != null && port != null) {
                LOG.info("ActiveMQ WebConsole available at http://{}:{}/", (Object)host, (Object)port);
                LOG.info("ActiveMQ Jolokia REST API available at http://{}:{}/api/jolokia/", (Object)host, (Object)port);
            }
        }
        LOG.debug("ActiveMQ WebConsole initialized.");
    }

    private WebApplicationContext createWebapplicationContext(ServletContext servletContext, String webconsoleType) {
        String configuration = "/WEB-INF/webconsole-" + webconsoleType + ".xml";
        LOG.debug("Web console type: " + webconsoleType);
        XmlWebApplicationContext context = new XmlWebApplicationContext();
        context.setServletContext(servletContext);
        context.setConfigLocations(new String[]{configuration});
        context.refresh();
        context.start();
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)context);
        return context;
    }

    private void initializeWebClient(ServletContext servletContext, WebApplicationContext context) {
        ConnectionFactory connectionFactory = (ConnectionFactory)context.getBean("connectionFactory");
        servletContext.setAttribute("org.apache.activemq.connectionFactory", (Object)connectionFactory);
        WebClient.initContext((ServletContext)servletContext);
    }

    public void contextDestroyed(ServletContextEvent event) {
        XmlWebApplicationContext context = (XmlWebApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)event.getServletContext());
        if (context != null) {
            context.stop();
            context.destroy();
        }
    }

    private static String getWebconsoleType() {
        String webconsoleType = System.getProperty("webconsole.type", "embedded");
        try {
            if (OsgiUtil.isOsgi()) {
                webconsoleType = "osgi";
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return webconsoleType;
    }
}

