/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.jmx.DurableSubscriptionViewMBean;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.apache.activemq.web.BrokerFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BrokerFacadeSupport
implements BrokerFacade {
    public abstract ManagementContext getManagementContext();

    public Collection<Object> getQueues() throws Exception {
        BrokerViewMBean broker = this.getBrokerAdmin();
        if (broker == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName[] queues = broker.getQueues();
        return this.getManagedObjects(queues, QueueViewMBean.class);
    }

    public Collection<Object> getTopics() throws Exception {
        BrokerViewMBean broker = this.getBrokerAdmin();
        if (broker == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName[] queues = broker.getTopics();
        return this.getManagedObjects(queues, TopicViewMBean.class);
    }

    public Collection<Object> getDurableTopicSubscribers() throws Exception {
        BrokerViewMBean broker = this.getBrokerAdmin();
        if (broker == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName[] queues = broker.getDurableTopicSubscribers();
        return this.getManagedObjects(queues, DurableSubscriptionViewMBean.class);
    }

    public QueueViewMBean getQueue(String name) throws Exception {
        return (QueueViewMBean)this.getDestinationByName(this.getQueues(), name);
    }

    public TopicViewMBean getTopic(String name) throws Exception {
        return (TopicViewMBean)this.getDestinationByName(this.getTopics(), name);
    }

    protected DestinationViewMBean getDestinationByName(Collection<Object> collection, String name) {
        for (DestinationViewMBean destinationViewMBean : collection) {
            if (!name.equals(destinationViewMBean.getName())) continue;
            return destinationViewMBean;
        }
        return null;
    }

    protected Collection<Object> getManagedObjects(ObjectName[] names, Class type) {
        ArrayList<Object> answer = new ArrayList<Object>();
        MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
        if (mbeanServer != null) {
            for (int i = 0; i < names.length; ++i) {
                ObjectName name = names[i];
                Object value = MBeanServerInvocationHandler.newProxyInstance(mbeanServer, name, type, true);
                if (value == null) continue;
                answer.add(value);
            }
        }
        return answer;
    }
}

