/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import jakarta.jms.JMSException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.StompAckEntry;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.util.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompSubscription {
    private static final Logger LOG = LoggerFactory.getLogger(StompSubscription.class);
    private static final IdGenerator ACK_ID_GENERATOR = new IdGenerator();
    public static final String AUTO_ACK = "auto";
    public static final String CLIENT_ACK = "client";
    public static final String INDIVIDUAL_ACK = "client-individual";
    protected final ProtocolConverter protocolConverter;
    protected final String subscriptionId;
    protected final ConsumerInfo consumerInfo;
    protected final Map<MessageId, StompAckEntry> dispatchedMessage = new LinkedHashMap<MessageId, StompAckEntry>();
    protected final Map<String, StompAckEntry> pendingAcks;
    protected final LinkedList<StompAckEntry> transactedMessages = new LinkedList();
    protected String ackMode = "auto";
    protected ActiveMQDestination destination;
    protected String transformation;

    public StompSubscription(ProtocolConverter stompTransport, String subscriptionId, ConsumerInfo consumerInfo, String transformation, Map<String, StompAckEntry> pendingAcks) {
        this.protocolConverter = stompTransport;
        this.subscriptionId = subscriptionId;
        this.consumerInfo = consumerInfo;
        this.transformation = transformation;
        this.pendingAcks = pendingAcks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMessageDispatch(MessageDispatch md) throws IOException, JMSException {
        ActiveMQMessage message = (ActiveMQMessage)md.getMessage();
        String ackId = null;
        if (this.isClientAck() || this.isIndividualAck()) {
            ackId = ACK_ID_GENERATOR.generateId();
            StompAckEntry pendingAck = new StompAckEntry(md, ackId, this);
            StompSubscription stompSubscription = this;
            synchronized (stompSubscription) {
                this.dispatchedMessage.put(message.getMessageId(), pendingAck);
            }
            if (this.protocolConverter.isStomp12()) {
                this.pendingAcks.put(ackId, pendingAck);
            }
        } else if (this.isAutoAck()) {
            MessageAck ack = new MessageAck(md, 2, 1);
            this.protocolConverter.getStompTransport().sendToActiveMQ((Command)ack);
        }
        boolean ignoreTransformation = false;
        if (this.transformation != null && !(message instanceof ActiveMQBytesMessage)) {
            message.setReadOnlyProperties(false);
            message.setStringProperty("transformation", this.transformation);
        } else if (message.getStringProperty("transformation") != null) {
            ignoreTransformation = true;
        }
        StompFrame command = this.protocolConverter.convertMessage(message, ignoreTransformation);
        command.setAction("MESSAGE");
        if (this.subscriptionId != null) {
            command.getHeaders().put("subscription", this.subscriptionId);
        }
        if (this.protocolConverter.isStomp12() && ackId != null) {
            command.getHeaders().put("ack", ackId);
        }
        try {
            this.protocolConverter.getStompTransport().sendToStomp(command);
        }
        catch (IOException ex) {
            if (ackId != null) {
                this.pendingAcks.remove(ackId);
            }
            throw ex;
        }
    }

    synchronized void onStompAbort(TransactionId transactionId) {
        LOG.trace("Transaction Abort restoring {} pending ACKs to valid state.", (Object)this.transactedMessages.size());
        for (StompAckEntry ackEntry : this.transactedMessages) {
            if (!this.protocolConverter.isStomp12()) continue;
            this.pendingAcks.put(ackEntry.getAckId(), ackEntry);
        }
        this.transactedMessages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStompCommit(TransactionId transactionId) {
        MessageAck ack = null;
        StompSubscription stompSubscription = this;
        synchronized (stompSubscription) {
            Iterator<StompAckEntry> iterator = this.dispatchedMessage.values().iterator();
            while (iterator.hasNext()) {
                StompAckEntry ackEntry = iterator.next();
                if (!this.transactedMessages.contains(ackEntry)) continue;
                iterator.remove();
            }
            if (!this.transactedMessages.isEmpty() && this.isClientAck()) {
                ack = new MessageAck(this.transactedMessages.getLast().getMessageDispatch(), 2, this.transactedMessages.size());
                ack.setTransactionId(transactionId);
                this.transactedMessages.clear();
            }
        }
        if (ack != null) {
            this.protocolConverter.getStompTransport().sendToActiveMQ((Command)ack);
        }
    }

    synchronized MessageAck onStompMessageAck(String messageId, TransactionId transactionId) {
        MessageId msgId = new MessageId(messageId);
        StompAckEntry ackEntry = this.dispatchedMessage.get(msgId);
        if (ackEntry == null) {
            return null;
        }
        MessageAck ack = new MessageAck();
        ack.setDestination(this.consumerInfo.getDestination());
        ack.setConsumerId(this.consumerInfo.getConsumerId());
        if (this.isClientAck()) {
            if (transactionId == null) {
                ack.setAckType((byte)2);
            } else {
                ack.setAckType((byte)0);
            }
            int count = 0;
            Iterator<StompAckEntry> iterator = this.dispatchedMessage.values().iterator();
            while (iterator.hasNext()) {
                StompAckEntry entry = iterator.next();
                MessageId current = entry.getMessageId();
                if (entry.getAckId() != null) {
                    this.pendingAcks.remove(entry.getAckId());
                }
                if (transactionId != null) {
                    if (!this.transactedMessages.contains(entry)) {
                        this.transactedMessages.add(entry);
                        ++count;
                    }
                } else {
                    iterator.remove();
                    ++count;
                }
                if (!current.equals((Object)msgId)) continue;
                ack.setLastMessageId(current);
                break;
            }
            ack.setMessageCount(count);
            if (transactionId != null) {
                ack.setTransactionId(transactionId);
            }
        } else if (this.isIndividualAck()) {
            if (ackEntry.getAckId() != null) {
                this.pendingAcks.remove(ackEntry.getAckId());
            }
            ack.setAckType((byte)4);
            ack.setMessageID(msgId);
            ack.setMessageCount(1);
            if (transactionId != null) {
                this.transactedMessages.add(this.dispatchedMessage.get(msgId));
                ack.setTransactionId(transactionId);
            } else {
                this.dispatchedMessage.remove(msgId);
            }
        }
        return ack;
    }

    public MessageAck onStompMessageNack(String messageId, TransactionId transactionId) throws ProtocolException {
        MessageId msgId = new MessageId(messageId);
        if (!this.dispatchedMessage.containsKey(msgId)) {
            return null;
        }
        StompAckEntry ackEntry = this.dispatchedMessage.get(msgId);
        if (ackEntry.getAckId() != null) {
            this.pendingAcks.remove(ackEntry.getAckId());
        }
        MessageAck ack = new MessageAck();
        ack.setDestination(this.consumerInfo.getDestination());
        ack.setConsumerId(this.consumerInfo.getConsumerId());
        ack.setAckType((byte)1);
        ack.setMessageID(msgId);
        if (transactionId != null) {
            this.transactedMessages.add(ackEntry);
            ack.setTransactionId(transactionId);
        } else {
            this.dispatchedMessage.remove(msgId);
        }
        return ack;
    }

    public String getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(String ackMode) {
        this.ackMode = ackMode;
    }

    public boolean isAutoAck() {
        return this.ackMode.equals(AUTO_ACK);
    }

    public boolean isClientAck() {
        return this.ackMode.equals(CLIENT_ACK);
    }

    public boolean isIndividualAck() {
        return this.ackMode.equals(INDIVIDUAL_ACK);
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setDestination(ActiveMQDestination destination) {
        this.destination = destination;
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public ConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }
}

