/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import jakarta.jms.JMSException;
import java.io.IOException;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompInactivityMonitor;
import org.apache.activemq.transport.stomp.StompTransport;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompTransportFilter
extends TransportFilter
implements StompTransport {
    private static final Logger TRACE = LoggerFactory.getLogger((String)(StompTransportFilter.class.getPackage().getName() + ".StompIO"));
    private final ProtocolConverter protocolConverter;
    private StompInactivityMonitor monitor;
    private StompWireFormat wireFormat;
    private boolean trace;

    public StompTransportFilter(Transport next, WireFormat wireFormat, BrokerContext brokerContext) {
        super(next);
        this.protocolConverter = new ProtocolConverter(this, brokerContext);
        if (wireFormat instanceof StompWireFormat) {
            this.wireFormat = (StompWireFormat)wireFormat;
        }
    }

    public void start() throws Exception {
        if (this.monitor != null) {
            this.monitor.startConnectCheckTask(this.getConnectAttemptTimeout());
        }
        super.start();
    }

    public void oneway(Object o) throws IOException {
        try {
            Command command = (Command)o;
            this.protocolConverter.onActiveMQCommand(command);
        }
        catch (JMSException e) {
            throw IOExceptionSupport.create((Exception)((Object)e));
        }
    }

    public void onCommand(Object command) {
        try {
            if (this.trace) {
                TRACE.trace("Received: \n" + command);
            }
            this.protocolConverter.onStompCommand((StompFrame)command);
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (JMSException e) {
            this.onException(IOExceptionSupport.create((Exception)((Object)e)));
        }
    }

    @Override
    public void sendToActiveMQ(Command command) {
        TransportListener l = this.transportListener;
        if (l != null) {
            l.onCommand((Object)command);
        }
    }

    @Override
    public void sendToStomp(StompFrame command) throws IOException {
        Transport n;
        if (this.trace) {
            TRACE.trace("Sending: \n" + command);
        }
        if ((n = this.next) != null) {
            n.oneway((Object)command);
        }
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public StompInactivityMonitor getInactivityMonitor() {
        return this.monitor;
    }

    public void setInactivityMonitor(StompInactivityMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public StompWireFormat getWireFormat() {
        return this.wireFormat;
    }

    public String getDefaultHeartBeat() {
        return this.protocolConverter != null ? this.protocolConverter.getDefaultHeartBeat() : null;
    }

    public void setDefaultHeartBeat(String defaultHeartBeat) {
        this.protocolConverter.setDefaultHeartBeat(defaultHeartBeat);
    }

    public float getHbGracePeriodMultiplier() {
        return (this.protocolConverter != null ? Float.valueOf(this.protocolConverter.getHbGracePeriodMultiplier()) : null).floatValue();
    }

    public void setHbGracePeriodMultiplier(float hbGracePeriodMultiplier) {
        if (hbGracePeriodMultiplier > 1.0f) {
            this.protocolConverter.setHbGracePeriodMultiplier(hbGracePeriodMultiplier);
        }
    }

    public void setMaxDataLength(int maxDataLength) {
        this.wireFormat.setMaxDataLength(maxDataLength);
    }

    public int getMaxDataLength() {
        return this.wireFormat.getMaxDataLength();
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.wireFormat.setMaxFrameSize(maxFrameSize);
    }

    public long getMaxFrameSize() {
        return this.wireFormat.getMaxFrameSize();
    }

    public long getConnectAttemptTimeout() {
        return this.wireFormat.getConnectionAttemptTimeout();
    }

    public void setConnectAttemptTimeout(long timeout) {
        this.wireFormat.setConnectionAttemptTimeout(timeout);
    }
}

