/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.plugin.DefaultConfigurationProcessor;
import org.apache.activemq.plugin.RuntimeConfigurationBroker;
import org.apache.activemq.plugin.util.PolicyEntryUtil;

public class PolicyEntryProcessor
extends DefaultConfigurationProcessor {
    public PolicyEntryProcessor(RuntimeConfigurationBroker plugin, Class<?> configurationClass) {
        super(plugin, configurationClass);
    }

    @Override
    public void addNew(Object o) {
        PolicyEntry addition = this.fromDto(o, new PolicyEntry());
        PolicyMap existingMap = this.plugin.getBrokerService().getDestinationPolicy();
        existingMap.put(addition.getDestination(), (Object)addition);
        this.applyRetrospectively(addition);
        this.plugin.info("added policy for: " + String.valueOf(addition.getDestination()));
    }

    @Override
    public void modify(Object existing, Object candidate) {
        PolicyEntry updatedEntry = this.fromDto(candidate, new PolicyEntry());
        PolicyEntry existingEntry = PolicyEntryUtil.findEntryByDestination(this.plugin, updatedEntry);
        if (existingEntry != null) {
            updatedEntry = this.fromDto(candidate, existingEntry);
            this.applyRetrospectively(updatedEntry);
            this.plugin.info("updated policy for: " + String.valueOf(updatedEntry.getDestination()));
        } else {
            this.plugin.info("cannot find policy entry candidate to update: " + String.valueOf(updatedEntry) + ", destination:" + String.valueOf(updatedEntry.getDestination()));
        }
    }

    protected void applyRetrospectively(PolicyEntry updatedEntry) {
        PolicyEntryUtil.applyRetrospectively(this.plugin, updatedEntry);
    }
}

