/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import jakarta.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.activemq.ra.ActiveMQConnectionRequestInfo;
import org.apache.activemq.ra.MessageActivationSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQConnectionSupport {
    private ActiveMQConnectionRequestInfo info = new ActiveMQConnectionRequestInfo();
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    protected ActiveMQConnectionFactory createConnectionFactory(ActiveMQConnectionRequestInfo connectionRequestInfo, MessageActivationSpec activationSpec) {
        ActiveMQSslConnectionFactory factory = new ActiveMQSslConnectionFactory();
        connectionRequestInfo.configure((ActiveMQConnectionFactory)factory, activationSpec);
        return factory;
    }

    public ActiveMQConnection makeConnection(ActiveMQConnectionRequestInfo connectionRequestInfo) throws JMSException {
        return this.makeConnection(connectionRequestInfo, this.createConnectionFactory(connectionRequestInfo, null));
    }

    public ActiveMQConnection makeConnection(ActiveMQConnectionRequestInfo connectionRequestInfo, ActiveMQConnectionFactory connectionFactory) throws JMSException {
        String userName = connectionRequestInfo.getUserName();
        String password = connectionRequestInfo.getPassword();
        ActiveMQConnection physicalConnection = (ActiveMQConnection)connectionFactory.createConnection(userName, password);
        String clientId = connectionRequestInfo.getClientid();
        if (clientId != null && clientId.length() > 0) {
            physicalConnection.setClientID(clientId);
        }
        return physicalConnection;
    }

    public ActiveMQConnectionRequestInfo getInfo() {
        return this.info;
    }

    protected void setInfo(ActiveMQConnectionRequestInfo connectionRequestInfo) {
        this.info = connectionRequestInfo;
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + ", setting [info] to: " + this.info);
        }
    }

    protected boolean notEqual(Object o1, Object o2) {
        return o1 == null ^ o2 == null || o1 != null && !o1.equals(o2);
    }

    protected String emptyToNull(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    protected String defaultValue(String value, String defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public String getClientid() {
        return this.emptyToNull(this.info.getClientid());
    }

    public void setClientid(String clientid) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + ", setting [clientid] to: " + clientid);
        }
        this.info.setClientid(clientid);
    }

    public String getPassword() {
        return this.emptyToNull(this.info.getPassword());
    }

    public void setPassword(String password) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + ", setting [password] property");
        }
        this.info.setPassword(password);
    }

    public String getServerUrl() {
        return this.info.getServerUrl();
    }

    public void setServerUrl(String url) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + ", setting [serverUrl] to: " + url);
        }
        this.info.setServerUrl(url);
    }

    public String getTrustStore() {
        return this.info.getTrustStore();
    }

    public void setTrustStore(String trustStore) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + ", setting [trustStore] to: " + trustStore);
        }
        this.info.setTrustStore(trustStore);
    }

    public String getTrustStorePassword() {
        return this.info.getTrustStorePassword();
    }

    public void setTrustStorePassword(String trustStorePassword) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + ", setting [trustStorePassword] to: " + trustStorePassword);
        }
        this.info.setTrustStorePassword(trustStorePassword);
    }

    public String getKeyStore() {
        return this.info.getKeyStore();
    }

    public void setKeyStore(String keyStore) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + ", setting [keyStore] to: " + keyStore);
        }
        this.info.setKeyStore(keyStore);
    }

    public String getKeyStorePassword() {
        return this.info.getKeyStorePassword();
    }

    public void setKeyStorePassword(String keyStorePassword) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + ", setting [keyStorePassword] to: " + keyStorePassword);
        }
        this.info.setKeyStorePassword(keyStorePassword);
    }

    public String getKeyStoreKeyPassword() {
        return this.info.getKeyStoreKeyPassword();
    }

    public void setKeyStoreKeyPassword(String keyStoreKeyPassword) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + ", setting [keyStoreKeyPassword] to: " + keyStoreKeyPassword);
        }
        this.info.setKeyStoreKeyPassword(keyStoreKeyPassword);
    }

    public String getUserName() {
        return this.emptyToNull(this.info.getUserName());
    }

    public void setUserName(String userid) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setting [userName] to: " + userid);
        }
        this.info.setUserName(userid);
    }

    public Integer getDurableTopicPrefetch() {
        return this.info.getDurableTopicPrefetch();
    }

    public void setOptimizeDurableTopicPrefetch(Integer optimizeDurableTopicPrefetch) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setting [optimizeDurableTopicPrefetch] to: " + optimizeDurableTopicPrefetch);
        }
        this.info.setOptimizeDurableTopicPrefetch(optimizeDurableTopicPrefetch);
    }

    public Integer getOptimizeDurableTopicPrefetch() {
        return this.info.getOptimizeDurableTopicPrefetch();
    }

    public void setDurableTopicPrefetch(Integer durableTopicPrefetch) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setting [durableTopicPrefetch] to: " + durableTopicPrefetch);
        }
        this.info.setDurableTopicPrefetch(durableTopicPrefetch);
    }

    public Long getInitialRedeliveryDelay() {
        return this.info.getInitialRedeliveryDelay();
    }

    public void setInitialRedeliveryDelay(Long value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setting [initialRedeliveryDelay] to: " + value);
        }
        this.info.setInitialRedeliveryDelay(value);
    }

    public Long getMaximumRedeliveryDelay() {
        return this.info.getMaximumRedeliveryDelay();
    }

    public void setMaximumRedeliveryDelay(Long value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setting [maximumRedeliveryDelay] to: " + value);
        }
        this.info.setMaximumRedeliveryDelay(value);
    }

    @Deprecated
    public Integer getInputStreamPrefetch() {
        return 0;
    }

    public Integer getMaximumRedeliveries() {
        return this.info.getMaximumRedeliveries();
    }

    public void setMaximumRedeliveries(Integer value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setting [maximumRedeliveries] to: " + value);
        }
        this.info.setMaximumRedeliveries(value);
    }

    public Integer getQueueBrowserPrefetch() {
        return this.info.getQueueBrowserPrefetch();
    }

    public void setQueueBrowserPrefetch(Integer queueBrowserPrefetch) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setting [queueBrowserPrefetch] to: " + queueBrowserPrefetch);
        }
        this.info.setQueueBrowserPrefetch(queueBrowserPrefetch);
    }

    public Integer getQueuePrefetch() {
        return this.info.getQueuePrefetch();
    }

    public void setQueuePrefetch(Integer queuePrefetch) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setting [queuePrefetch] to: " + queuePrefetch);
        }
        this.info.setQueuePrefetch(queuePrefetch);
    }

    public Double getRedeliveryBackOffMultiplier() {
        return this.info.getRedeliveryBackOffMultiplier();
    }

    public void setRedeliveryBackOffMultiplier(Double value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setting [redeliveryBackOffMultiplier] to: " + value);
        }
        this.info.setRedeliveryBackOffMultiplier(value);
    }

    public Boolean getRedeliveryUseExponentialBackOff() {
        return this.info.getRedeliveryUseExponentialBackOff();
    }

    public void setRedeliveryUseExponentialBackOff(Boolean value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setting [redeliveryUseExponentialBackOff] to: " + value);
        }
        this.info.setRedeliveryUseExponentialBackOff(value);
    }

    public Integer getTopicPrefetch() {
        return this.info.getTopicPrefetch();
    }

    public void setTopicPrefetch(Integer topicPrefetch) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setting [topicPrefetch] to: " + topicPrefetch);
        }
        this.info.setTopicPrefetch(topicPrefetch);
    }

    public void setAllPrefetchValues(Integer i) {
        this.info.setAllPrefetchValues(i);
    }

    public boolean isUseInboundSessionEnabled() {
        return this.info.isUseInboundSessionEnabled();
    }

    public Boolean getUseInboundSession() {
        return this.info.getUseInboundSession();
    }

    public void setUseInboundSession(Boolean useInboundSession) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setting [useInboundSession] to: " + useInboundSession);
        }
        this.info.setUseInboundSession(useInboundSession);
    }

    public boolean isUseSessionArgs() {
        return this.info.isUseSessionArgs();
    }

    public Boolean getUseSessionArgs() {
        return this.info.getUseSessionArgs();
    }

    public void setUseSessionArgs(Boolean useSessionArgs) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + ", setting [useSessionArgs] to: " + useSessionArgs);
        }
        this.info.setUseSessionArgs(useSessionArgs);
    }
}

