/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import java.lang.reflect.Method;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpoint;
import org.apache.activemq.ra.InvalidMessageEndpointException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageEndpointProxy
implements MessageListener,
MessageEndpoint {
    private static final MessageEndpointState ALIVE = new MessageEndpointAlive();
    private static final MessageEndpointState DEAD = new MessageEndpointDead();
    private static final Logger LOG = LoggerFactory.getLogger(MessageEndpointProxy.class);
    private static int proxyCount;
    private final int proxyID;
    private final MessageEndpoint endpoint;
    private final MessageListener messageListener;
    private MessageEndpointState state = ALIVE;

    public MessageEndpointProxy(MessageEndpoint endpoint) {
        if (!(endpoint instanceof MessageListener)) {
            throw new IllegalArgumentException("MessageEndpoint is not a MessageListener");
        }
        this.messageListener = (MessageListener)endpoint;
        this.proxyID = MessageEndpointProxy.getID();
        this.endpoint = endpoint;
    }

    private static int getID() {
        return ++proxyCount;
    }

    public void beforeDelivery(Method method) throws NoSuchMethodException, ResourceException {
        LOG.trace("Invoking MessageEndpoint.beforeDelivery()");
        this.state.beforeDelivery(this, method);
    }

    public void onMessage(Message message) {
        LOG.trace("Invoking MessageEndpoint.onMethod()");
        this.state.onMessage(this, message);
    }

    public void afterDelivery() throws ResourceException {
        LOG.trace("Invoking MessageEndpoint.afterDelivery()");
        this.state.afterDelivery(this);
    }

    public void release() {
        LOG.trace("Invoking MessageEndpoint.release()");
        this.state.release(this);
    }

    public String toString() {
        return "MessageEndpointProxy{ proxyID: " + this.proxyID + ", endpoint: " + String.valueOf(this.endpoint) + " }";
    }

    private static class MessageEndpointDead
    extends MessageEndpointState {
        private MessageEndpointDead() {
        }

        @Override
        protected void enter(MessageEndpointProxy proxy) {
            proxy.endpoint.release();
        }

        @Override
        public void beforeDelivery(MessageEndpointProxy proxy, Method method) throws NoSuchMethodException, ResourceException {
            throw new InvalidMessageEndpointException();
        }

        @Override
        public void onMessage(MessageEndpointProxy proxy, Message message) {
            throw new InvalidMessageEndpointException();
        }

        @Override
        public void afterDelivery(MessageEndpointProxy proxy) throws ResourceException {
            throw new InvalidMessageEndpointException();
        }

        @Override
        public void release(MessageEndpointProxy proxy) {
            throw new InvalidMessageEndpointException();
        }
    }

    private static class MessageEndpointAlive
    extends MessageEndpointState {
        private MessageEndpointAlive() {
        }

        @Override
        public void beforeDelivery(MessageEndpointProxy proxy, Method method) throws NoSuchMethodException, ResourceException {
            try {
                proxy.endpoint.beforeDelivery(method);
            }
            catch (NoSuchMethodException e) {
                this.transition(proxy, DEAD);
                throw e;
            }
            catch (ResourceException e) {
                this.transition(proxy, DEAD);
                throw e;
            }
        }

        @Override
        public void onMessage(MessageEndpointProxy proxy, Message message) {
            proxy.messageListener.onMessage(message);
        }

        @Override
        public void afterDelivery(MessageEndpointProxy proxy) throws ResourceException {
            try {
                proxy.endpoint.afterDelivery();
            }
            catch (ResourceException e) {
                this.transition(proxy, DEAD);
                throw e;
            }
        }

        @Override
        public void release(MessageEndpointProxy proxy) {
            this.transition(proxy, DEAD);
        }
    }

    private static abstract class MessageEndpointState {
        private MessageEndpointState() {
        }

        public void beforeDelivery(MessageEndpointProxy proxy, Method method) throws NoSuchMethodException, ResourceException {
            throw new IllegalStateException();
        }

        public void onMessage(MessageEndpointProxy proxy, Message message) {
            throw new IllegalStateException();
        }

        public void afterDelivery(MessageEndpointProxy proxy) throws ResourceException {
            throw new IllegalStateException();
        }

        public void release(MessageEndpointProxy proxy) {
            throw new IllegalStateException();
        }

        protected final void transition(MessageEndpointProxy proxy, MessageEndpointState nextState) {
            proxy.state = nextState;
            nextState.enter(proxy);
        }

        protected void enter(MessageEndpointProxy proxy) {
        }
    }
}

