/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Set;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.security.auth.Subject;
import org.apache.activemq.ra.ActiveMQConnectionFactory;
import org.apache.activemq.ra.ActiveMQConnectionRequestInfo;
import org.apache.activemq.ra.ActiveMQConnectionSupport;
import org.apache.activemq.ra.ActiveMQManagedConnection;
import org.apache.activemq.ra.MessageResourceAdapter;
import org.apache.activemq.ra.SimpleConnectionManager;
import org.slf4j.LoggerFactory;

public class ActiveMQManagedConnectionFactory
extends ActiveMQConnectionSupport
implements ManagedConnectionFactory,
ResourceAdapterAssociation {
    private static final long serialVersionUID = 6196921962230582875L;
    private PrintWriter logWriter;

    public void setResourceAdapter(ResourceAdapter adapter) throws ResourceException {
        if (!(adapter instanceof MessageResourceAdapter)) {
            throw new ResourceException("ResourceAdapter is not of type: " + MessageResourceAdapter.class.getName());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.valueOf(this) + ", copying standard ResourceAdapter configuration properties");
        }
        ActiveMQConnectionRequestInfo baseInfo = ((MessageResourceAdapter)adapter).getInfo().copy();
        if (this.getClientid() == null) {
            this.setClientid(baseInfo.getClientid());
        }
        if (this.getPassword() == null) {
            this.setPassword(baseInfo.getPassword());
        }
        if (this.getServerUrl() == null) {
            this.setServerUrl(baseInfo.getServerUrl());
        }
        if (this.getUseInboundSession() == null) {
            this.setUseInboundSession(baseInfo.getUseInboundSession());
        }
        if (this.getUseSessionArgs() == null) {
            this.setUseSessionArgs(baseInfo.isUseSessionArgs());
        }
        if (this.getUserName() == null) {
            this.setUserName(baseInfo.getUserName());
        }
        if (this.getDurableTopicPrefetch() == null) {
            this.setDurableTopicPrefetch(baseInfo.getDurableTopicPrefetch());
        }
        if (this.getOptimizeDurableTopicPrefetch() == null) {
            this.setOptimizeDurableTopicPrefetch(baseInfo.getOptimizeDurableTopicPrefetch());
        }
        if (this.getQueuePrefetch() == null) {
            this.setQueuePrefetch(baseInfo.getQueuePrefetch());
        }
        if (this.getQueueBrowserPrefetch() == null) {
            this.setQueueBrowserPrefetch(baseInfo.getQueueBrowserPrefetch());
        }
        if (this.getTopicPrefetch() == null) {
            this.setTopicPrefetch(baseInfo.getTopicPrefetch());
        }
        if (this.getKeyStore() == null) {
            this.setKeyStore(baseInfo.getKeyStore());
        }
        if (this.getKeyStorePassword() == null) {
            this.setKeyStorePassword(baseInfo.getKeyStorePassword());
        }
        if (this.getTrustStore() == null) {
            this.setTrustStore(baseInfo.getTrustStore());
        }
        if (this.getTrustStorePassword() == null) {
            this.setTrustStorePassword(baseInfo.getTrustStorePassword());
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return null;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != ActiveMQManagedConnectionFactory.class) {
            return false;
        }
        return ((ActiveMQManagedConnectionFactory)object).getInfo().equals(this.getInfo());
    }

    public int hashCode() {
        return this.getInfo().hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.logWriter != null && !(this.logWriter instanceof Serializable)) {
            this.logWriter = null;
        }
        out.defaultWriteObject();
        out.writeObject(this.getInfo());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setInfo((ActiveMQConnectionRequestInfo)in.readObject());
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public Object createConnectionFactory(ConnectionManager manager) throws ResourceException {
        return new ActiveMQConnectionFactory(this, manager, this.getInfo());
    }

    public Object createConnectionFactory() throws ResourceException {
        return new ActiveMQConnectionFactory(this, new SimpleConnectionManager(), this.getInfo());
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        ActiveMQConnectionRequestInfo amqInfo = this.getInfo();
        if (connectionRequestInfo instanceof ActiveMQConnectionRequestInfo) {
            amqInfo = (ActiveMQConnectionRequestInfo)connectionRequestInfo;
        }
        try {
            return new ActiveMQManagedConnection(subject, this.makeConnection(amqInfo), amqInfo);
        }
        catch (JMSException e) {
            throw new ResourceException("Could not create connection.", (Throwable)e);
        }
    }

    public ManagedConnection matchManagedConnections(Set connections, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        for (ActiveMQManagedConnection c : connections) {
            if (!c.matches(subject, connectionRequestInfo)) continue;
            try {
                c.associate(subject, (ActiveMQConnectionRequestInfo)connectionRequestInfo);
                return c;
            }
            catch (JMSException e) {
                throw new ResourceException((Throwable)e);
            }
        }
        return null;
    }

    public void setLogWriter(PrintWriter aLogWriter) throws ResourceException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("setting log writer [" + String.valueOf(aLogWriter) + "]");
        }
        this.logWriter = aLogWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("getting log writer [" + String.valueOf(this.logWriter) + "]");
        }
        return this.logWriter;
    }
}

