/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.benchmark;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.benchmark.BenchmarkSupport;

public class Producer
extends BenchmarkSupport {
    int loops = -1;
    int loopSize = 1000;
    private int messageSize = 1000;

    public static void main(String[] args) {
        Producer tool = new Producer();
        if (args.length > 0) {
            tool.setUrl(args[0]);
        }
        if (args.length > 1) {
            tool.setTopic(Producer.parseBoolean(args[1]));
        }
        if (args.length > 2) {
            tool.setSubject(args[2]);
        }
        if (args.length > 3) {
            tool.setDurable(Producer.parseBoolean(args[3]));
        }
        if (args.length > 4) {
            tool.setMessageSize(Integer.parseInt(args[4]));
        }
        if (args.length > 5) {
            tool.setConnectionCount(Integer.parseInt(args[5]));
        }
        try {
            tool.run();
        }
        catch (Exception e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
        }
    }

    public void run() throws Exception {
        this.start();
        this.publish();
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public void setMessageSize(int messageSize) {
        this.messageSize = messageSize;
    }

    public int getLoopSize() {
        return this.loopSize;
    }

    public void setLoopSize(int loopSize) {
        this.loopSize = loopSize;
    }

    protected void publish() throws Exception {
        final String text = this.getMessage();
        System.out.println("Publishing to: " + this.subjects.length + " subject(s)");
        for (int i = 0; i < this.subjects.length; ++i) {
            final String subject = this.subjects[i];
            Thread thread = new Thread(){

                public void run() {
                    try {
                        Producer.this.publish(text, subject);
                    }
                    catch (JMSException e) {
                        System.out.println("Caught: " + (Object)((Object)e));
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
        }
    }

    protected String getMessage() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.messageSize; ++i) {
            char ch = 'X';
            buffer.append(ch);
        }
        return buffer.toString();
    }

    protected void publish(String text, String subject) throws JMSException {
        Session session = this.createSession();
        Destination destination = this.createDestination(session, subject);
        MessageProducer publisher = session.createProducer(destination);
        if (this.isDurable()) {
            publisher.setDeliveryMode(2);
        } else {
            publisher.setDeliveryMode(1);
        }
        System.out.println("Starting publisher on : " + destination + " of type: " + destination.getClass().getName());
        System.out.println("Message length: " + text.length());
        if (this.loops <= 0) {
            while (true) {
                this.publishLoop(session, publisher, text);
            }
        }
        for (int i = 0; i < this.loops; ++i) {
            this.publishLoop(session, publisher, text);
        }
    }

    protected void publishLoop(Session session, MessageProducer publisher, String text) throws JMSException {
        for (int i = 0; i < this.loopSize; ++i) {
            TextMessage message = session.createTextMessage(text);
            publisher.send((Message)message);
            this.count(1);
        }
    }

    protected String loadFile(String file) throws IOException {
        String line;
        System.out.println("Loading file: " + file);
        StringBuffer buffer = new StringBuffer();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            buffer.append(line);
            buffer.append(File.separator);
        }
        return buffer.toString();
    }
}

