/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.transport.http.HttpTransportMarshaller;
import org.apache.activemq.wireformat.WireFormat;

class HttpWireFormatMarshaller
implements HttpTransportMarshaller {
    private final WireFormat wireFormat;

    HttpWireFormatMarshaller() {
        this((WireFormat)new OpenWireFormat());
    }

    HttpWireFormatMarshaller(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    @Override
    public void marshal(Object command, OutputStream outputStream) throws IOException {
        DataOutputStream out = new DataOutputStream(outputStream);
        this.wireFormat.marshal(command, (DataOutput)out);
        out.flush();
    }

    @Override
    public Object unmarshal(InputStream stream) throws IOException {
        return this.wireFormat.unmarshal((DataInput)new DataInputStream(stream));
    }
}

