/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.activemq.transport.http.HttpTransportMarshaller;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.transport.xstream.XStreamWireFormat;

public class HttpTextWireFormatMarshaller
implements HttpTransportMarshaller {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final TextWireFormat wireFormat;

    HttpTextWireFormatMarshaller() {
        this(new XStreamWireFormat());
    }

    public HttpTextWireFormatMarshaller(TextWireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    @Override
    public void marshal(Object command, OutputStream outputStream) throws IOException {
        String s = this.wireFormat.marshalText(command);
        outputStream.write(s.getBytes(CHARSET));
    }

    @Override
    public Object unmarshal(InputStream stream) throws IOException {
        return this.wireFormat.unmarshalText(new InputStreamReader(stream, CHARSET));
    }
}

