/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.transport.SocketConnectorFactory;
import org.apache.activemq.transport.WebTransportServerSupport;
import org.apache.activemq.transport.ws.jetty9.WSServlet;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSTransportServer
extends WebTransportServerSupport
implements BrokerServiceAware {
    private static final Logger LOG = LoggerFactory.getLogger(WSTransportServer.class);
    private BrokerService brokerService;
    private WSServlet servlet;

    public WSTransportServer(URI location) {
        super(location);
        this.bindAddress = location;
        this.socketConnectorFactory = new SocketConnectorFactory();
    }

    protected void doStart() throws Exception {
        this.createServer();
        if (this.connector == null) {
            this.connector = this.socketConnectorFactory.createConnector(this.server);
        }
        for (ConnectionFactory cf : this.connector.getConnectionFactories()) {
            if (!HttpConnectionFactory.class.isAssignableFrom(cf.getClass())) continue;
            ((HttpConnectionFactory)HttpConnectionFactory.class.cast(cf)).getHttpConfiguration().setSendServerVersion(false);
        }
        URI boundTo = this.bind();
        ServletContextHandler contextHandler = new ServletContextHandler((HandlerContainer)this.server, "/", 2);
        ServletHolder holder = new ServletHolder();
        this.configureTraceMethod((ConstraintSecurityHandler)contextHandler.getSecurityHandler(), this.httpOptions.isEnableTrace());
        Map webSocketOptions = IntrospectionSupport.extractProperties((Map)this.transportOptions, (String)"websocket.");
        for (Map.Entry webSocketEntry : webSocketOptions.entrySet()) {
            Object value = webSocketEntry.getValue();
            if (value == null) continue;
            holder.setInitParameter((String)webSocketEntry.getKey(), value.toString());
        }
        holder.setServlet(this.createWSServlet());
        contextHandler.addServlet(holder, "/");
        contextHandler.setAttribute("acceptListener", (Object)this.getAcceptListener());
        this.server.start();
        int port = this.getConnectorLocalPort();
        if (port == -1) {
            port = boundTo.getPort();
        }
        this.setConnectURI(new URI(boundTo.getScheme(), boundTo.getUserInfo(), boundTo.getHost(), port, boundTo.getPath(), boundTo.getQuery(), boundTo.getFragment()));
        LOG.info("Listening for connections at {}", (Object)this.getConnectURI());
    }

    private Servlet createWSServlet() throws Exception {
        this.servlet = new WSServlet();
        this.servlet.setTransportOptions(this.transportOptions);
        this.servlet.setBrokerService(this.brokerService);
        return this.servlet;
    }

    private int getConnectorLocalPort() throws Exception {
        return (Integer)this.connector.getClass().getMethod("getLocalPort", new Class[0]).invoke((Object)this.connector, new Object[0]);
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        Server temp = this.server;
        this.server = null;
        if (temp != null) {
            temp.stop();
        }
    }

    public InetSocketAddress getSocketAddress() {
        return null;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }

    protected void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void setTransportOption(Map<String, Object> transportOptions) {
        Map socketOptions = IntrospectionSupport.extractProperties(transportOptions, (String)"transport.");
        this.socketConnectorFactory.setTransportOptions(socketOptions);
        transportOptions.putAll(socketOptions);
        super.setTransportOption(transportOptions);
    }

    public boolean isSslServer() {
        return false;
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
        if (this.servlet != null) {
            this.servlet.setBrokerService(brokerService);
        }
    }
}

