/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportLoggerFactory;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.http.HttpClientTransport;
import org.apache.activemq.transport.http.HttpInactivityMonitor;
import org.apache.activemq.transport.http.HttpTransportServer;
import org.apache.activemq.transport.http.marshallers.HttpTransportMarshaller;
import org.apache.activemq.transport.http.marshallers.HttpWireFormatMarshaller;
import org.apache.activemq.transport.http.marshallers.TextWireFormatMarshallers;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.URISupport;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransportFactory
extends TransportFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpTransportFactory.class);
    private static final String WIRE_FORMAT_XSTREAM = "xstream";
    private final String defaultWireFormatType;

    public HttpTransportFactory() {
        this.defaultWireFormatType = WIRE_FORMAT_XSTREAM;
    }

    public HttpTransportFactory(String defaultWireFormatType) {
        this.defaultWireFormatType = defaultWireFormatType;
    }

    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap options = new HashMap(URISupport.parseParameters((URI)location));
            HttpTransportServer result = new HttpTransportServer(location, this);
            Map httpOptions = IntrospectionSupport.extractProperties(options, (String)"http.");
            Map transportOptions = IntrospectionSupport.extractProperties(options, (String)"transport.");
            result.setTransportOption(transportOptions);
            result.setHttpOptions(httpOptions);
            return result;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create((Exception)e);
        }
    }

    protected WireFormat processWireFormat(WireFormat wireFormat) {
        return wireFormat;
    }

    protected String getDefaultWireFormatType() {
        return this.defaultWireFormatType;
    }

    protected Transport createTransport(URI location, WireFormat wf) throws IOException {
        URI uri;
        WireFormat wireFormat = this.processWireFormat(wf);
        try {
            uri = URISupport.removeQuery((URI)location);
        }
        catch (URISyntaxException e) {
            MalformedURLException cause = new MalformedURLException("Error removing query on " + location);
            cause.initCause(e);
            throw cause;
        }
        return new HttpClientTransport(this.createMarshaller(wireFormat), uri);
    }

    protected HttpTransportMarshaller createMarshaller(WireFormat wireFormat) {
        return wireFormat instanceof TextWireFormat ? TextWireFormatMarshallers.newTransportMarshaller((TextWireFormat)wireFormat) : new HttpWireFormatMarshaller(wireFormat);
    }

    public Transport serverConfigure(Transport transport, WireFormat format, HashMap options) throws Exception {
        return this.compositeConfigure(transport, format, options);
    }

    public Transport compositeConfigure(Transport transport, WireFormat format, Map options) {
        boolean useInactivityMonitor;
        HttpClientTransport httpTransport = (HttpClientTransport)((Object)(transport = super.compositeConfigure(transport, format, options)).narrow(HttpClientTransport.class));
        if (httpTransport != null && httpTransport.isTrace()) {
            try {
                transport = TransportLoggerFactory.getInstance().createTransportLogger(transport);
            }
            catch (Throwable e) {
                LOG.error("Could not create TransportLogger object for: " + TransportLoggerFactory.defaultLogWriterName + ", reason: " + e, e);
            }
        }
        if (useInactivityMonitor = "true".equals(this.getOption(options, "useInactivityMonitor", "true"))) {
            transport = new HttpInactivityMonitor((Transport)transport);
            IntrospectionSupport.setProperties((Object)transport, (Map)options);
        }
        return transport;
    }
}

