/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http.marshallers;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.activemq.transport.http.marshallers.HttpTransportMarshaller;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.wireformat.WireFormat;

public class TextWireFormatMarshallers {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    public static HttpTransportMarshaller newServletMarshaller(WireFormat wireFormat) {
        return new MarshalPlainUnmarshalTextMarshaller((TextWireFormat)wireFormat);
    }

    public static HttpTransportMarshaller newTransportMarshaller(TextWireFormat textWireFormat) {
        return new MarshalTextUnmarshalPlainMarshaller(textWireFormat);
    }

    private static class MarshalPlainUnmarshalTextMarshaller
    implements HttpTransportMarshaller {
        private final TextWireFormat wireFormat;

        private MarshalPlainUnmarshalTextMarshaller(TextWireFormat wireFormat) {
            this.wireFormat = wireFormat;
        }

        @Override
        public void marshal(Object command, OutputStream outputStream) throws IOException {
            this.wireFormat.marshal(command, new DataOutputStream(outputStream));
        }

        @Override
        public Object unmarshal(InputStream stream) throws IOException {
            return this.wireFormat.unmarshalText(new InputStreamReader(stream, CHARSET));
        }
    }

    private static class MarshalTextUnmarshalPlainMarshaller
    implements HttpTransportMarshaller {
        private final TextWireFormat wireFormat;

        private MarshalTextUnmarshalPlainMarshaller(TextWireFormat wireFormat) {
            this.wireFormat = wireFormat;
        }

        @Override
        public void marshal(Object command, OutputStream outputStream) throws IOException {
            String s = this.wireFormat.marshalText(command);
            outputStream.write(s.getBytes(CHARSET));
        }

        @Override
        public Object unmarshal(InputStream stream) throws IOException {
            return this.wireFormat.unmarshal(new DataInputStream(stream));
        }
    }
}

