/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.thread.PooledTaskRunner;
import org.apache.activemq.thread.Task;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class PooledTaskRunnerTest {
    @Rule
    public TestName name = new TestName();
    private ExecutorService executor;

    @Before
    public void setUp() throws Exception {
        this.executor = Executors.newCachedThreadPool(new IgnoreUncaughtExceptionThreadFactory());
    }

    @After
    public void tearDown() throws Exception {
        this.executor.shutdownNow();
    }

    @Test
    public void testNormalBehavior() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        PooledTaskRunner runner = new PooledTaskRunner((Executor)this.executor, new Task(){

            public boolean iterate() {
                latch.countDown();
                return false;
            }
        }, 1);
        runner.wakeup();
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        runner.shutdown();
    }

    @Test
    public void testWakeupResultsInThreadSafeCalls() throws Exception {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, PooledTaskRunnerTest.this.name.getMethodName());
                thread.setDaemon(true);
                thread.setPriority(5);
                return thread;
            }
        });
        final CountDownLatch doneLatch = new CountDownLatch(100);
        final AtomicInteger clashCount = new AtomicInteger();
        final AtomicInteger count = new AtomicInteger();
        final PooledTaskRunner runner = new PooledTaskRunner((Executor)executor, new Task(){
            String threadUnSafeVal = null;

            public boolean iterate() {
                if (this.threadUnSafeVal != null) {
                    clashCount.incrementAndGet();
                }
                this.threadUnSafeVal = Thread.currentThread().getName();
                count.incrementAndGet();
                doneLatch.countDown();
                if (!this.threadUnSafeVal.equals(Thread.currentThread().getName())) {
                    clashCount.incrementAndGet();
                }
                this.threadUnSafeVal = null;
                return false;
            }
        }, 1);
        Runnable doWakeup = new Runnable(){

            @Override
            public void run() {
                try {
                    runner.wakeup();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        int iterations = 1000;
        for (int i = 0; i < 1000; ++i) {
            if (i % 100 == 0) {
                Thread.sleep(10L);
            }
            executor.execute(doWakeup);
        }
        doneLatch.await(20L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"thread safety clash", (long)0L, (long)clashCount.get());
        Assert.assertTrue((String)"called more than once", (count.get() > 1 ? 1 : 0) != 0);
        runner.shutdown();
    }

    @Test
    public void testShutsDownAfterRunnerFailure() throws Exception {
        Future<Object> future = this.executor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                final CountDownLatch latch = new CountDownLatch(1);
                PooledTaskRunner runner = new PooledTaskRunner((Executor)PooledTaskRunnerTest.this.executor, new Task(){

                    public boolean iterate() {
                        latch.countDown();
                        throw new RuntimeException();
                    }
                }, 1);
                runner.wakeup();
                Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
                runner.shutdown();
                return null;
            }
        });
        try {
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"TaskRunner did not shut down cleanly");
        }
    }

    private class IgnoreUncaughtExceptionThreadFactory
    implements ThreadFactory,
    Thread.UncaughtExceptionHandler {
        ThreadFactory threadFactory = Executors.defaultThreadFactory();

        private IgnoreUncaughtExceptionThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.threadFactory.newThread(r);
            thread.setUncaughtExceptionHandler(this);
            return thread;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
        }
    }
}

