/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.activemq.broker.SslContext;
import org.junit.Assert;
import org.junit.Test;

public class SslContextTest {
    SslContext underTest = new SslContext();

    @Test
    public void testConcurrentGet() throws Exception {
        int numReps = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        final SSLContext[] results = new SSLContext[100];
        int i = 0;
        while (i < 100) {
            final int instanceIndex = i++;
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        results[instanceIndex] = SslContextTest.this.underTest.getSSLContext();
                    }
                    catch (NoSuchProviderException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchAlgorithmException e) {
                        e.printStackTrace();
                    }
                    catch (KeyManagementException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        executorService.shutdown();
        Assert.assertTrue((boolean)executorService.awaitTermination(10L, TimeUnit.SECONDS));
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((String)"single instance", (Object)results[0], (Object)results[i]);
        }
    }
}

