/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component.broker;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.inteceptor.MessageInterceptor;
import org.apache.activemq.broker.inteceptor.MessageInterceptorRegistry;
import org.apache.activemq.camel.component.broker.BrokerComponent;
import org.apache.activemq.camel.component.broker.BrokerConfiguration;
import org.apache.activemq.camel.component.broker.BrokerConsumer;
import org.apache.activemq.camel.component.broker.BrokerProducer;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

@ManagedResource(description="Managed Camel Broker Endpoint")
@UriEndpoint(scheme="broker", consumerClass=BrokerConsumer.class)
public class BrokerEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport,
Service {
    static final String PRODUCER_BROKER_EXCHANGE = "producerBrokerExchange";
    @UriParam
    private final BrokerConfiguration configuration;
    private MessageInterceptorRegistry messageInterceptorRegistry;
    @UriPath
    private final ActiveMQDestination destination;
    private List<MessageInterceptor> messageInterceptorList = new CopyOnWriteArrayList<MessageInterceptor>();

    public BrokerEndpoint(String uri, BrokerComponent component, ActiveMQDestination destination, BrokerConfiguration configuration) {
        super(UnsafeUriCharactersEncoder.encode((String)uri), (Component)component);
        this.destination = destination;
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        BrokerProducer producer = new BrokerProducer(this);
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        BrokerConsumer consumer = new BrokerConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.messageInterceptorRegistry = MessageInterceptorRegistry.getInstance().get(this.configuration.getBrokerName());
        for (MessageInterceptor messageInterceptor : this.messageInterceptorList) {
            this.addMessageInterceptor(messageInterceptor);
        }
        this.messageInterceptorList.clear();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    protected void addMessageInterceptor(MessageInterceptor messageInterceptor) {
        if (this.isStarted()) {
            this.messageInterceptorRegistry.addMessageInterceptor(this.destination, messageInterceptor);
        } else {
            this.messageInterceptorList.add(messageInterceptor);
        }
    }

    protected void removeMessageInterceptor(MessageInterceptor messageInterceptor) {
        this.messageInterceptorRegistry.removeMessageInterceptor(this.destination, messageInterceptor);
    }

    protected void inject(ProducerBrokerExchange producerBrokerExchange, Message message) throws Exception {
        ProducerBrokerExchange pbe = producerBrokerExchange;
        if (message != null) {
            message.setDestination(this.destination);
            if (producerBrokerExchange != null && producerBrokerExchange.getRegionDestination() != null && !producerBrokerExchange.getRegionDestination().getActiveMQDestination().equals((Object)this.destination)) {
                pbe = null;
            }
            this.messageInterceptorRegistry.injectMessage(pbe, message);
        }
    }
}

