/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceLoadBalancer;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceCallProcessor
extends ServiceSupport
implements AsyncProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceCallProcessor.class);
    private final ExchangePattern exchangePattern;
    private final String name;
    private final String scheme;
    private final String uri;
    private final String contextPath;
    private final CamelContext camelContext;
    private final ServiceLoadBalancer loadBalancer;
    private final Expression expression;
    private SendDynamicProcessor processor;

    public DefaultServiceCallProcessor(CamelContext camelContext, String name, String scheme, String uri, ExchangePattern exchangePattern, ServiceLoadBalancer loadBalancer, Expression expression) {
        String serviceName;
        this.uri = uri;
        this.exchangePattern = exchangePattern;
        this.camelContext = camelContext;
        this.loadBalancer = loadBalancer;
        if (name.contains("/")) {
            serviceName = StringHelper.before(name, "/");
            this.contextPath = StringHelper.after(name, "/");
        } else if (name.contains("?")) {
            serviceName = StringHelper.before(name, "?");
            this.contextPath = StringHelper.after(name, "?");
        } else {
            serviceName = name;
            this.contextPath = null;
        }
        if (serviceName.contains(":")) {
            this.scheme = StringHelper.before(serviceName, ":");
            this.name = StringHelper.after(serviceName, ":");
        } else {
            this.scheme = scheme;
            this.name = serviceName;
        }
        this.expression = expression;
    }

    public ExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }

    public String getName() {
        return this.name;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUri() {
        return this.uri;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServiceLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    protected void doStart() throws Exception {
        StringHelper.notEmpty(this.name, "name", "service name");
        ObjectHelper.notNull(this.camelContext, "camel context");
        ObjectHelper.notNull(this.expression, "expression");
        ObjectHelper.notNull(this.loadBalancer, "load balancer");
        this.processor = new SendDynamicProcessor(this.uri, this.expression);
        this.processor.setCamelContext(this.camelContext);
        if (this.exchangePattern != null) {
            this.processor.setPattern(this.exchangePattern);
        }
        ServiceHelper.startService(this.processor);
        ServiceHelper.startService(this.loadBalancer);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.loadBalancer);
        ServiceHelper.stopService(this.processor);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Message message = exchange.getIn();
        String serviceName = this.applySimpleLanguage(this.name, exchange);
        String serviceUri = this.applySimpleLanguage(this.uri, exchange);
        String servicePath = this.applySimpleLanguage(this.contextPath, exchange);
        String serviceScheme = this.applySimpleLanguage(this.scheme, exchange);
        message.setHeader("CamelServiceCallUri", serviceUri);
        message.setHeader("CamelServiceCallContextPath", servicePath);
        message.setHeader("CamelServiceCallScheme", serviceScheme);
        message.setHeader("CamelServiceCallServiceName", serviceName);
        try {
            return this.loadBalancer.process(serviceName, (ServiceDefinition server) -> this.execute(server, exchange, callback));
        }
        catch (Exception e) {
            exchange.setException(e);
            return true;
        }
    }

    private boolean execute(ServiceDefinition service, Exchange exchange, AsyncCallback callback) throws Exception {
        Message message = exchange.getIn();
        String host = service.getHost();
        int port = service.getPort();
        Map<String, String> meta = service.getMetadata();
        LOGGER.debug("Service {} active at server: {}:{}", this.name, host, port);
        message.setHeader("CamelServiceCallServiceHost", host);
        message.setHeader("CamelServiceCallServicePort", port > 0 ? Integer.valueOf(port) : null);
        message.setHeader("CamelServiceCallServiceName", service.getName());
        message.setHeader("CamelServiceCallServiceMeta", meta);
        message.getHeaders().compute("CamelServiceCallContextPath", (k, v) -> v == null ? meta.get("service.path") : v);
        message.getHeaders().compute("CamelServiceCallServicePort", (k, v) -> v == null ? meta.get("service.port") : v);
        return this.processor.process(exchange, callback);
    }

    private String applySimpleLanguage(String expression, Exchange exchange) {
        return SimpleLanguage.hasSimpleFunction(expression) ? SimpleLanguage.simple(expression).evaluate(exchange, String.class) : expression;
    }
}

