/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.processor.idempotent;

import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ServiceSupport;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

@ManagedResource(description="SpringCache based message id repository")
public class SpringCacheIdempotentRepository
extends ServiceSupport
implements IdempotentRepository<Object> {
    private final CacheManager manager;
    private final String cacheName;
    private Cache cache;

    public SpringCacheIdempotentRepository(CacheManager manager, String cacheName) {
        this.manager = manager;
        this.cacheName = cacheName;
        this.cache = null;
    }

    @Override
    @ManagedOperation(description="Adds the key to the store")
    public boolean add(Object key) {
        return this.cache.putIfAbsent(key, true) == null;
    }

    @Override
    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(Object key) {
        return this.cache.get(key) != null;
    }

    @Override
    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(Object key) {
        this.cache.evict(key);
        return true;
    }

    @Override
    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.cache.clear();
    }

    @ManagedAttribute(description="The processor name")
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public boolean confirm(Object key) {
        return true;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.cache == null) {
            this.cache = this.manager.getCache(this.cacheName);
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.cache = null;
    }
}

