/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.processor.WireTapProcessor;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;

@Metadata(label="eip,endpoint,routing")
@XmlRootElement(name="wireTap")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WireTapDefinition<Type extends ProcessorDefinition<Type>>
extends ToDynamicDefinition
implements ExecutorServiceAwareDefinition<WireTapDefinition<Type>> {
    @XmlTransient
    private Processor newExchangeProcessor;
    @XmlAttribute(name="processorRef")
    private String newExchangeProcessorRef;
    @XmlElement(name="body")
    private ExpressionSubElementDefinition newExchangeExpression;
    @XmlElementRef
    private List<SetHeaderDefinition> headers = new ArrayList<SetHeaderDefinition>();
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean copy;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean dynamicUri;
    @XmlAttribute
    private String onPrepareRef;
    @XmlTransient
    private Processor onPrepare;

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, this, true);
        ExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredExecutorService(routeContext, "WireTap", this, true);
        this.setPattern(ExchangePattern.InOnly);
        SendDynamicProcessor dynamicTo = (SendDynamicProcessor)super.createProcessor(routeContext);
        Processor target = this.wrapInErrorHandler(routeContext, dynamicTo);
        CamelInternalProcessor internal = new CamelInternalProcessor(target);
        internal.addAdvice(new CamelInternalProcessor.UnitOfWorkProcessorAdvice(routeContext));
        boolean isCopy = this.getCopy() == null || this.getCopy() != false;
        WireTapProcessor answer = new WireTapProcessor(dynamicTo, internal, this.getPattern(), threadPool, shutdownThreadPool, this.isDynamic());
        answer.setCopy(isCopy);
        if (this.newExchangeProcessorRef != null) {
            this.newExchangeProcessor = routeContext.mandatoryLookup(this.newExchangeProcessorRef, Processor.class);
        }
        if (this.newExchangeProcessor != null) {
            answer.addNewExchangeProcessor(this.newExchangeProcessor);
        }
        if (this.newExchangeExpression != null) {
            answer.setNewExchangeExpression(this.newExchangeExpression.createExpression(routeContext));
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            for (SetHeaderDefinition header : this.headers) {
                Processor processor = this.createProcessor(routeContext, header);
                answer.addNewExchangeProcessor(processor);
            }
        }
        if (this.onPrepareRef != null) {
            this.onPrepare = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.onPrepareRef, Processor.class);
        }
        if (this.onPrepare != null) {
            answer.setOnPrepare(this.onPrepare);
        }
        return answer;
    }

    @Override
    protected Expression createExpression(RouteContext routeContext) {
        if (this.isDynamic()) {
            return super.createExpression(routeContext);
        }
        return ExpressionBuilder.constantExpression(this.getUri());
    }

    private boolean isDynamic() {
        return this.dynamicUri == null || this.dynamicUri != false;
    }

    @Override
    public ExchangePattern getPattern() {
        return ExchangePattern.InOnly;
    }

    @Override
    public String toString() {
        return "WireTap[" + this.getUri() + "]";
    }

    @Override
    public String getShortName() {
        return "wireTap";
    }

    @Override
    public String getLabel() {
        return "wireTap[" + this.getUri() + "]";
    }

    public Type end() {
        return (Type)super.end();
    }

    @Override
    public void addOutput(ProcessorDefinition<?> output) {
        this.getParent().addOutput(output);
    }

    @Override
    public WireTapDefinition<Type> executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public WireTapDefinition<Type> executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public WireTapDefinition<Type> copy() {
        this.setCopy(true);
        return this;
    }

    public WireTapDefinition<Type> copy(boolean copy) {
        this.setCopy(copy);
        return this;
    }

    public WireTapDefinition<Type> dynamicUri(boolean dynamicUri) {
        this.setDynamicUri(dynamicUri);
        return this;
    }

    @Deprecated
    public WireTapDefinition<Type> newExchange(Expression expression) {
        return this.newExchangeBody(expression);
    }

    public WireTapDefinition<Type> newExchangeBody(Expression expression) {
        this.setNewExchangeExpression(new ExpressionSubElementDefinition(expression));
        return this;
    }

    public WireTapDefinition<Type> newExchangeRef(String ref) {
        this.setNewExchangeProcessorRef(ref);
        return this;
    }

    public WireTapDefinition<Type> newExchange(Processor processor) {
        this.setNewExchangeProcessor(processor);
        return this;
    }

    public WireTapDefinition<Type> newExchangeHeader(String headerName, Expression expression) {
        this.headers.add(new SetHeaderDefinition(headerName, expression));
        return this;
    }

    public WireTapDefinition<Type> onPrepare(Processor onPrepare) {
        this.setOnPrepare(onPrepare);
        return this;
    }

    public WireTapDefinition<Type> onPrepareRef(String onPrepareRef) {
        this.setOnPrepareRef(onPrepareRef);
        return this;
    }

    @Override
    public WireTapDefinition<Type> cacheSize(int cacheSize) {
        this.setCacheSize(cacheSize);
        return this;
    }

    @Override
    public WireTapDefinition<Type> ignoreInvalidEndpoint() {
        this.setIgnoreInvalidEndpoint(true);
        return this;
    }

    @Override
    public String getUri() {
        return super.getUri();
    }

    @Override
    public void setUri(String uri) {
        super.setUri(uri);
    }

    public Processor getNewExchangeProcessor() {
        return this.newExchangeProcessor;
    }

    public void setNewExchangeProcessor(Processor processor) {
        this.newExchangeProcessor = processor;
    }

    public String getNewExchangeProcessorRef() {
        return this.newExchangeProcessorRef;
    }

    public void setNewExchangeProcessorRef(String ref) {
        this.newExchangeProcessorRef = ref;
    }

    public ExpressionSubElementDefinition getNewExchangeExpression() {
        return this.newExchangeExpression;
    }

    public void setNewExchangeExpression(ExpressionSubElementDefinition newExchangeExpression) {
        this.newExchangeExpression = newExchangeExpression;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Boolean getCopy() {
        return this.copy;
    }

    public void setCopy(Boolean copy) {
        this.copy = copy;
    }

    public Boolean getDynamicUri() {
        return this.dynamicUri;
    }

    public void setDynamicUri(Boolean dynamicUri) {
        this.dynamicUri = dynamicUri;
    }

    public String getOnPrepareRef() {
        return this.onPrepareRef;
    }

    public void setOnPrepareRef(String onPrepareRef) {
        this.onPrepareRef = onPrepareRef;
    }

    public Processor getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(Processor onPrepare) {
        this.onPrepare = onPrepare;
    }

    public List<SetHeaderDefinition> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<SetHeaderDefinition> headers) {
        this.headers = headers;
    }
}

