/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.StompSubscription;

public class StompAckEntry {
    private final String ackId;
    private final MessageId messageId;
    private final StompSubscription subscription;
    private final MessageDispatch dispatch;

    public StompAckEntry(MessageDispatch dispatch, String ackId, StompSubscription subscription) {
        this.messageId = dispatch.getMessage().getMessageId();
        this.subscription = subscription;
        this.ackId = ackId;
        this.dispatch = dispatch;
    }

    public MessageAck onMessageAck(TransactionId transactionId) {
        return this.subscription.onStompMessageAck(this.messageId.toString(), transactionId);
    }

    public MessageAck onMessageNack(TransactionId transactionId) throws ProtocolException {
        return this.subscription.onStompMessageNack(this.messageId.toString(), transactionId);
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public MessageDispatch getMessageDispatch() {
        return this.dispatch;
    }

    public String getAckId() {
        return this.ackId;
    }

    public StompSubscription getSubscription() {
        return this.subscription;
    }

    public String toString() {
        return "AckEntry[ msgId:" + this.messageId + ", ackId:" + this.ackId + ", sub:" + this.subscription + " ]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StompAckEntry other = (StompAckEntry)obj;
        return !(this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId));
    }
}

