/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compaction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.client.summary.Summary;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.summary.Gatherer;
import org.apache.accumulo.core.summary.SummarizerFactory;
import org.apache.accumulo.core.summary.SummaryCollection;
import org.apache.accumulo.core.summary.SummaryReader;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class MajorCompactionRequest
implements Cloneable {
    private final KeyExtent extent;
    private final MajorCompactionReason reason;
    private final VolumeManager volumeManager;
    private final AccumuloConfiguration tableConfig;
    private final BlockCache indexCache;
    private final BlockCache summaryCache;
    private Map<FileRef, DataFileValue> files;
    private final ServerContext context;
    private final Cache<String, Long> fileLenCache;

    public MajorCompactionRequest(KeyExtent extent, MajorCompactionReason reason, VolumeManager manager, AccumuloConfiguration tabletConfig, BlockCache summaryCache, BlockCache indexCache, Cache<String, Long> fileLenCache, ServerContext context) {
        this.extent = extent;
        this.reason = reason;
        this.volumeManager = manager;
        this.tableConfig = tabletConfig;
        this.files = Collections.emptyMap();
        this.summaryCache = summaryCache;
        this.indexCache = indexCache;
        this.fileLenCache = fileLenCache;
        this.context = context;
    }

    public MajorCompactionRequest(KeyExtent extent, MajorCompactionReason reason, AccumuloConfiguration tabletConfig, ServerContext context) {
        this(extent, reason, null, tabletConfig, null, null, null, context);
    }

    public MajorCompactionRequest(MajorCompactionRequest mcr) {
        this(mcr.extent, mcr.reason, mcr.volumeManager, mcr.tableConfig, mcr.summaryCache, mcr.indexCache, mcr.fileLenCache, mcr.context);
        this.files = mcr.files;
    }

    @VisibleForTesting
    public TabletId getTabletId() {
        return new TabletIdImpl(this.extent);
    }

    public MajorCompactionReason getReason() {
        return this.reason;
    }

    public Map<FileRef, DataFileValue> getFiles() {
        return this.files;
    }

    public List<Summary> getSummaries(Collection<FileRef> files, Predicate<SummarizerConfiguration> summarySelector) {
        Objects.requireNonNull(this.volumeManager, "Getting summaries is not  supported at this time. It's only supported when CompactionStrategy.gatherInformation() is called.");
        SummaryCollection sc = new SummaryCollection();
        SummarizerFactory factory = new SummarizerFactory(this.tableConfig);
        for (FileRef file : files) {
            FileSystem fs = this.volumeManager.getVolumeByPath(file.path()).getFileSystem();
            Configuration conf = this.context.getHadoopConf();
            SummaryCollection fsc = SummaryReader.load((FileSystem)fs, (Configuration)conf, (SummarizerFactory)factory, (Path)file.path(), summarySelector, (BlockCache)this.summaryCache, (BlockCache)this.indexCache, this.fileLenCache, (CryptoService)this.context.getCryptoService()).getSummaries(Collections.singletonList(new Gatherer.RowRange(this.extent)));
            sc.merge(fsc, factory);
        }
        return sc.getSummaries();
    }

    public void setFiles(Map<FileRef, DataFileValue> update) {
        this.files = Collections.unmodifiableMap(update);
    }

    public FileSKVIterator openReader(FileRef ref) throws IOException {
        Objects.requireNonNull(this.volumeManager, "Opening files is not supported at this time. It's only supported when CompactionStrategy.gatherInformation() is called.");
        FileOperations fileFactory = FileOperations.getInstance();
        FileSystem ns = this.volumeManager.getVolumeByPath(ref.path()).getFileSystem();
        return fileFactory.newReaderBuilder().forFile(ref.path().toString(), ns, ns.getConf(), this.context.getCryptoService()).withTableConfiguration(this.tableConfig).seekToBeginning().build();
    }

    public Map<String, String> getTableProperties() {
        return this.tableConfig.getAllPropertiesWithPrefix(Property.TABLE_PREFIX);
    }

    public String getTableConfig(String key) {
        Property property = Property.getPropertyByKey((String)key);
        if (property == null || property.isSensitive()) {
            throw new RuntimeException("Unable to access the configuration value " + key);
        }
        return this.tableConfig.get(property);
    }

    public int getMaxFilesPerTablet() {
        return this.tableConfig.getMaxFilesPerTablet();
    }

    public MajorCompactionRequest clone() throws CloneNotSupportedException {
        return (MajorCompactionRequest)super.clone();
    }
}

