/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.IntSupplier;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.file.blockfile.cache.impl.BlockCacheConfiguration;
import org.apache.accumulo.core.file.blockfile.cache.impl.BlockCacheManagerFactory;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.cache.BlockCacheManager;
import org.apache.accumulo.core.spi.cache.CacheType;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.core.spi.scan.ScanDispatcher;
import org.apache.accumulo.core.spi.scan.ScanExecutor;
import org.apache.accumulo.core.spi.scan.ScanInfo;
import org.apache.accumulo.core.spi.scan.ScanPrioritizer;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServiceEnvironmentImpl;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.tabletserver.LargestFirstMemoryManager;
import org.apache.accumulo.server.tabletserver.MemoryManagementActions;
import org.apache.accumulo.server.tabletserver.MemoryManager;
import org.apache.accumulo.server.tabletserver.TabletState;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.tserver.ActiveAssignmentRunnable;
import org.apache.accumulo.tserver.CompactionQueue;
import org.apache.accumulo.tserver.FileManager;
import org.apache.accumulo.tserver.HoldTimeoutException;
import org.apache.accumulo.tserver.MinorCompactionReason;
import org.apache.accumulo.tserver.NativeMap;
import org.apache.accumulo.tserver.RunnableStartedAt;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.DefaultCompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;
import org.apache.accumulo.tserver.session.ScanSession;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.htrace.wrappers.TraceExecutorService;
import org.apache.htrace.wrappers.TraceRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServerResourceManager {
    private static final Logger log = LoggerFactory.getLogger(TabletServerResourceManager.class);
    private final ExecutorService minorCompactionThreadPool;
    private final ExecutorService majorCompactionThreadPool;
    private final ExecutorService rootMajorCompactionThreadPool;
    private final ExecutorService defaultMajorCompactionThreadPool;
    private final ExecutorService splitThreadPool;
    private final ExecutorService defaultSplitThreadPool;
    private final ExecutorService defaultMigrationPool;
    private final ExecutorService migrationPool;
    private final ExecutorService assignmentPool;
    private final ExecutorService assignMetaDataPool;
    private final ExecutorService summaryRetrievalPool;
    private final ExecutorService summaryParitionPool;
    private final ExecutorService summaryRemotePool;
    private final Map<String, ExecutorService> threadPools = new TreeMap<String, ExecutorService>();
    private final Map<String, ExecutorService> scanExecutors;
    private final Map<String, ScanExecutor> scanExecutorChoices;
    private final ConcurrentHashMap<KeyExtent, RunnableStartedAt> activeAssignments;
    private final FileManager fileManager;
    private final MemoryManager memoryManager;
    private final MemoryManagementFramework memMgmt;
    private final BlockCacheManager cacheManager;
    private final BlockCache _dCache;
    private final BlockCache _iCache;
    private final BlockCache _sCache;
    private final ServerContext context;
    private Cache<String, Long> fileLenCache;
    private final Object commitHold = new Object();
    private volatile boolean holdCommits = false;
    private long holdStartTime;

    private ExecutorService addEs(String name, ExecutorService tp) {
        if (this.threadPools.containsKey(name)) {
            throw new IllegalArgumentException("Cannot create two executor services with same name " + name);
        }
        tp = new TraceExecutorService(tp);
        this.threadPools.put(name, tp);
        return tp;
    }

    private ExecutorService addEs(final IntSupplier maxThreads, final String name, final ThreadPoolExecutor tp) {
        ExecutorService result = this.addEs(name, tp);
        SimpleTimer.getInstance((AccumuloConfiguration)this.context.getConfiguration()).schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    int max = maxThreads.getAsInt();
                    int currentMax = tp.getMaximumPoolSize();
                    if (currentMax != max) {
                        log.info("Changing max threads for {} from {} to {}", new Object[]{name, currentMax, max});
                        if (max > currentMax) {
                            tp.setMaximumPoolSize(max);
                            tp.setCorePoolSize(max);
                        } else {
                            tp.setCorePoolSize(max);
                            tp.setMaximumPoolSize(max);
                        }
                    }
                }
                catch (Throwable t) {
                    log.error("Failed to change thread pool size", t);
                }
            }
        }, 1000L, 10000L);
        return result;
    }

    private ExecutorService createIdlingEs(Property max, String name, long timeout, TimeUnit timeUnit) {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        int maxThreads = this.context.getConfiguration().getCount(max);
        ThreadPoolExecutor tp = new ThreadPoolExecutor(maxThreads, maxThreads, timeout, timeUnit, queue, (ThreadFactory)new NamingThreadFactory(name));
        tp.allowCoreThreadTimeOut(true);
        return this.addEs(() -> this.context.getConfiguration().getCount(max), name, tp);
    }

    private ExecutorService createEs(int max, String name) {
        return this.addEs(name, Executors.newFixedThreadPool(max, (ThreadFactory)new NamingThreadFactory(name)));
    }

    private ExecutorService createEs(Property max, String name) {
        return this.createEs(max, name, new LinkedBlockingQueue<Runnable>());
    }

    private ExecutorService createPriorityExecutor(final AccumuloConfiguration.ScanExecutorConfig sec, Map<String, Queue<?>> scanExecQueues) {
        AbstractQueue queue;
        if (sec.prioritizerClass.orElse("").isEmpty()) {
            queue = new LinkedBlockingQueue<Runnable>();
        } else {
            ScanPrioritizer factory = null;
            try {
                factory = (ScanPrioritizer)ConfigurationTypeHelper.getClassInstance(null, (String)((String)sec.prioritizerClass.get()), ScanPrioritizer.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (factory == null) {
                queue = new LinkedBlockingQueue();
            } else {
                Comparator comparator = factory.createComparator(new ScanPrioritizer.CreateParameters(){

                    public Map<String, String> getOptions() {
                        return sec.prioritizerOpts;
                    }

                    public ServiceEnvironment getServiceEnv() {
                        return new ServiceEnvironmentImpl(TabletServerResourceManager.this.context);
                    }
                });
                Function<Runnable, ScanInfo> extractor = r -> ((ScanSession.ScanMeasurer)((TraceRunnable)r).getRunnable()).getScanInfo();
                queue = new PriorityBlockingQueue<Runnable>(sec.maxThreads, Comparator.comparing(extractor, comparator));
            }
        }
        scanExecQueues.put(sec.name, queue);
        return this.createEs(() -> sec.getCurrentMaxThreads(), "scan-" + sec.name, (BlockingQueue<Runnable>)((Object)queue), sec.priority);
    }

    private ExecutorService createEs(IntSupplier maxThreadsSupplier, String name, BlockingQueue<Runnable> queue, OptionalInt priority) {
        int maxThreads = maxThreadsSupplier.getAsInt();
        ThreadPoolExecutor tp = new ThreadPoolExecutor(maxThreads, maxThreads, 0L, TimeUnit.MILLISECONDS, queue, (ThreadFactory)new NamingThreadFactory(name, priority));
        return this.addEs(maxThreadsSupplier, name, tp);
    }

    private ExecutorService createEs(Property max, String name, BlockingQueue<Runnable> queue) {
        IntSupplier maxThreadsSupplier = () -> this.context.getConfiguration().getCount(max);
        return this.createEs(maxThreadsSupplier, name, queue, OptionalInt.empty());
    }

    private ExecutorService createEs(int min, int max, int timeout, String name) {
        return this.addEs(name, new ThreadPoolExecutor(min, max, (long)timeout, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamingThreadFactory(name)));
    }

    protected Map<String, ExecutorService> createScanExecutors(Collection<AccumuloConfiguration.ScanExecutorConfig> scanExecCfg, Map<String, Queue<?>> scanExecQueues) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (AccumuloConfiguration.ScanExecutorConfig sec : scanExecCfg) {
            builder.put((Object)sec.name, (Object)this.createPriorityExecutor(sec, scanExecQueues));
        }
        return builder.build();
    }

    private Map<String, ScanExecutor> createScanExecutorChoices(Collection<AccumuloConfiguration.ScanExecutorConfig> scanExecCfg, Map<String, Queue<?>> scanExecQueues) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (AccumuloConfiguration.ScanExecutorConfig sec : scanExecCfg) {
            builder.put((Object)sec.name, (Object)new ScanExecutorImpl(sec, scanExecQueues.get(sec.name)));
        }
        return builder.build();
    }

    @SuppressFBWarnings(value={"DM_GC"}, justification="GC is run to get a good estimate of memory availability")
    public TabletServerResourceManager(ServerContext context) {
        this.context = context;
        AccumuloConfiguration acuConf = context.getConfiguration();
        long maxMemory = acuConf.getAsBytes(Property.TSERV_MAXMEM);
        boolean usingNativeMap = acuConf.getBoolean(Property.TSERV_NATIVEMAP_ENABLED) && NativeMap.isLoaded();
        long totalQueueSize = acuConf.getAsBytes(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX);
        try {
            this.cacheManager = BlockCacheManagerFactory.getInstance((AccumuloConfiguration)acuConf);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating BlockCacheManager", e);
        }
        this.cacheManager.start((BlockCacheManager.Configuration)new BlockCacheConfiguration(acuConf));
        this._iCache = this.cacheManager.getBlockCache(CacheType.INDEX);
        this._dCache = this.cacheManager.getBlockCache(CacheType.DATA);
        this._sCache = this.cacheManager.getBlockCache(CacheType.SUMMARY);
        long dCacheSize = this._dCache.getMaxHeapSize();
        long iCacheSize = this._iCache.getMaxHeapSize();
        long sCacheSize = this._sCache.getMaxHeapSize();
        Runtime runtime = Runtime.getRuntime();
        if (usingNativeMap) {
            if (dCacheSize + iCacheSize + sCacheSize + totalQueueSize > runtime.maxMemory()) {
                throw new IllegalArgumentException(String.format("Block cache sizes %,d and mutation queue size %,d is too large for this JVM configuration %,d", dCacheSize + iCacheSize + sCacheSize, totalQueueSize, runtime.maxMemory()));
            }
        } else if (maxMemory + dCacheSize + iCacheSize + sCacheSize + totalQueueSize > runtime.maxMemory()) {
            throw new IllegalArgumentException(String.format("Maximum tablet server map memory %,d block cache sizes %,d and mutation queue size %,d is too large for this JVM configuration %,d", maxMemory, dCacheSize + iCacheSize + sCacheSize, totalQueueSize, runtime.maxMemory()));
        }
        runtime.gc();
        if (!usingNativeMap && maxMemory > runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory())) {
            log.warn("In-memory map may not fit into local memory space.");
        }
        this.minorCompactionThreadPool = this.createEs(Property.TSERV_MINC_MAXCONCURRENT, "minor compactor");
        this.majorCompactionThreadPool = this.createEs(Property.TSERV_MAJC_MAXCONCURRENT, "major compactor", new CompactionQueue().asBlockingQueueOfRunnable());
        this.rootMajorCompactionThreadPool = this.createEs(0, 1, 300, "md root major compactor");
        this.defaultMajorCompactionThreadPool = this.createEs(0, 1, 300, "md major compactor");
        this.splitThreadPool = this.createEs(1, "splitter");
        this.defaultSplitThreadPool = this.createEs(0, 1, 60, "md splitter");
        this.defaultMigrationPool = this.createEs(0, 1, 60, "metadata tablet migration");
        this.migrationPool = this.createEs(Property.TSERV_MIGRATE_MAXCONCURRENT, "tablet migration");
        this.assignmentPool = this.createEs(Property.TSERV_ASSIGNMENT_MAXCONCURRENT, "tablet assignment");
        this.assignMetaDataPool = this.createEs(0, 1, 60, "metadata tablet assignment");
        this.activeAssignments = new ConcurrentHashMap();
        this.summaryRetrievalPool = this.createIdlingEs(Property.TSERV_SUMMARY_RETRIEVAL_THREADS, "summary file retriever", 60L, TimeUnit.SECONDS);
        this.summaryRemotePool = this.createIdlingEs(Property.TSERV_SUMMARY_REMOTE_THREADS, "summary remote", 60L, TimeUnit.SECONDS);
        this.summaryParitionPool = this.createIdlingEs(Property.TSERV_SUMMARY_PARTITION_THREADS, "summary partition", 60L, TimeUnit.SECONDS);
        Collection scanExecCfg = acuConf.getScanExecutors();
        HashMap scanExecQueues = new HashMap();
        this.scanExecutors = this.createScanExecutors(scanExecCfg, scanExecQueues);
        this.scanExecutorChoices = this.createScanExecutorChoices(scanExecCfg, scanExecQueues);
        int maxOpenFiles = acuConf.getCount(Property.TSERV_SCAN_MAX_OPENFILES);
        this.fileLenCache = CacheBuilder.newBuilder().maximumSize(Math.min((long)maxOpenFiles * 1000L, 100000L)).build();
        this.fileManager = new FileManager(context, context.getVolumeManager(), maxOpenFiles, this.fileLenCache, this._dCache, this._iCache);
        this.memoryManager = (MemoryManager)Property.createInstanceFromPropertyName((AccumuloConfiguration)acuConf, (Property)Property.TSERV_MEM_MGMT, MemoryManager.class, (Object)new LargestFirstMemoryManager());
        this.memoryManager.init((ServerConfiguration)context.getServerConfFactory());
        this.memMgmt = new MemoryManagementFramework();
        this.memMgmt.startThreads();
        SimpleTimer timer = SimpleTimer.getInstance((AccumuloConfiguration)context.getConfiguration());
        timer.schedule((Runnable)new AssignmentWatcher(acuConf, this.activeAssignments, timer), 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void holdAllCommits(boolean holdAllCommits) {
        Object object = this.commitHold;
        synchronized (object) {
            if (this.holdCommits != holdAllCommits) {
                this.holdCommits = holdAllCommits;
                if (this.holdCommits) {
                    this.holdStartTime = System.currentTimeMillis();
                }
                if (!this.holdCommits) {
                    log.debug(String.format("Commits held for %6.2f secs", (double)(System.currentTimeMillis() - this.holdStartTime) / 1000.0));
                    this.commitHold.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilCommitsAreEnabled() {
        if (this.holdCommits) {
            long timeout = System.currentTimeMillis() + this.context.getConfiguration().getTimeInMillis(Property.GENERAL_RPC_TIMEOUT);
            Object object = this.commitHold;
            synchronized (object) {
                while (this.holdCommits) {
                    try {
                        if (System.currentTimeMillis() > timeout) {
                            throw new HoldTimeoutException("Commits are held");
                        }
                        this.commitHold.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long holdTime() {
        if (!this.holdCommits) {
            return 0L;
        }
        Object object = this.commitHold;
        synchronized (object) {
            return System.currentTimeMillis() - this.holdStartTime;
        }
    }

    public synchronized TabletResourceManager createTabletResourceManager(KeyExtent extent, AccumuloConfiguration conf) {
        return new TabletResourceManager(extent, conf);
    }

    public void executeSplit(KeyExtent tablet, Runnable splitTask) {
        if (tablet.isMeta()) {
            if (tablet.isRootTablet()) {
                log.warn("Saw request to split root tablet, ignoring");
                return;
            }
            this.defaultSplitThreadPool.execute(splitTask);
        } else {
            this.splitThreadPool.execute(splitTask);
        }
    }

    public void executeMajorCompaction(KeyExtent tablet, Runnable compactionTask) {
        if (tablet.isRootTablet()) {
            this.rootMajorCompactionThreadPool.execute(compactionTask);
        } else if (tablet.isMeta()) {
            this.defaultMajorCompactionThreadPool.execute(compactionTask);
        } else {
            this.majorCompactionThreadPool.execute(compactionTask);
        }
    }

    public void executeReadAhead(KeyExtent tablet, ScanDispatcher dispatcher, final ScanSession scanInfo, Runnable task) {
        task = ScanSession.wrap(scanInfo, task);
        if (tablet.isRootTablet()) {
            task.run();
        } else if (tablet.isMeta()) {
            this.scanExecutors.get("meta").execute(task);
        } else {
            String scanExecutorName = dispatcher.dispatch(new ScanDispatcher.DispatchParmaters(){

                public ScanInfo getScanInfo() {
                    return scanInfo;
                }

                public Map<String, ScanExecutor> getScanExecutors() {
                    return TabletServerResourceManager.this.scanExecutorChoices;
                }

                public ServiceEnvironment getServiceEnv() {
                    return new ServiceEnvironmentImpl(TabletServerResourceManager.this.context);
                }
            });
            ExecutorService executor = this.scanExecutors.get(scanExecutorName);
            if (executor == null) {
                log.warn("For table id {}, {} dispatched to non-existant executor {} Using default executor.", new Object[]{tablet.getTableId(), dispatcher.getClass().getName(), scanExecutorName});
                executor = this.scanExecutors.get("default");
            } else if ("meta".equals(scanExecutorName)) {
                log.warn("For table id {}, {} dispatched to meta executor. Using default executor.", (Object)tablet.getTableId(), (Object)dispatcher.getClass().getName());
                executor = this.scanExecutors.get("default");
            }
            executor.execute(task);
        }
    }

    public void addAssignment(KeyExtent extent, Logger log, TabletServer.AssignmentHandler assignmentHandler) {
        this.assignmentPool.execute(new ActiveAssignmentRunnable(this.activeAssignments, extent, (Runnable)new LoggingRunnable(log, (Runnable)assignmentHandler)));
    }

    public void addMetaDataAssignment(KeyExtent extent, Logger log, TabletServer.AssignmentHandler assignmentHandler) {
        this.assignMetaDataPool.execute(new ActiveAssignmentRunnable(this.activeAssignments, extent, (Runnable)new LoggingRunnable(log, (Runnable)assignmentHandler)));
    }

    public void addMigration(KeyExtent tablet, Runnable migrationHandler) {
        if (tablet.isRootTablet()) {
            migrationHandler.run();
        } else if (tablet.isMeta()) {
            this.defaultMigrationPool.execute(migrationHandler);
        } else {
            this.migrationPool.execute(migrationHandler);
        }
    }

    public BlockCache getIndexCache() {
        return this._iCache;
    }

    public BlockCache getDataCache() {
        return this._dCache;
    }

    public BlockCache getSummaryCache() {
        return this._sCache;
    }

    public Cache<String, Long> getFileLenCache() {
        return this.fileLenCache;
    }

    public ExecutorService getSummaryRetrievalExecutor() {
        return this.summaryRetrievalPool;
    }

    public ExecutorService getSummaryPartitionExecutor() {
        return this.summaryParitionPool;
    }

    public ExecutorService getSummaryRemoteExecutor() {
        return this.summaryRemotePool;
    }

    public class TabletResourceManager {
        private final long creationTime = System.currentTimeMillis();
        private volatile boolean openFilesReserved = false;
        private volatile boolean closed = false;
        private final KeyExtent extent;
        private final AccumuloConfiguration tableConf;
        private final AtomicLong lastReportedSize = new AtomicLong();
        private final AtomicLong lastReportedMincSize = new AtomicLong();
        private volatile long lastReportedCommitTime = 0L;

        TabletResourceManager(KeyExtent extent, AccumuloConfiguration tableConf) {
            Objects.requireNonNull(extent, "extent is null");
            Objects.requireNonNull(tableConf, "tableConf is null");
            this.extent = extent;
            this.tableConf = tableConf;
        }

        @VisibleForTesting
        KeyExtent getExtent() {
            return this.extent;
        }

        @VisibleForTesting
        AccumuloConfiguration getTableConfiguration() {
            return this.tableConf;
        }

        public void importedMapFiles() {
            this.lastReportedCommitTime = System.currentTimeMillis();
        }

        public synchronized FileManager.ScanFileManager newScanFileManager() {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            return TabletServerResourceManager.this.fileManager.newScanFileManager(this.extent);
        }

        public void updateMemoryUsageStats(Tablet tablet, long size, long mincSize) {
            long totalSize = size + mincSize;
            long lrs = this.lastReportedSize.get();
            long delta = totalSize - lrs;
            long lrms = this.lastReportedMincSize.get();
            boolean report = false;
            if ((lrms > 0L && mincSize == 0L || lrms == 0L && mincSize > 0L) && this.lastReportedMincSize.compareAndSet(lrms, mincSize)) {
                report = true;
            }
            long currentTime = System.currentTimeMillis();
            if ((delta > 32000L || delta < 0L || currentTime - this.lastReportedCommitTime > 1000L) && this.lastReportedSize.compareAndSet(lrs, totalSize)) {
                if (delta > 0L) {
                    this.lastReportedCommitTime = currentTime;
                }
                report = true;
            }
            if (report) {
                TabletServerResourceManager.this.memMgmt.updateMemoryUsageStats(tablet, size, this.lastReportedCommitTime, mincSize);
            }
        }

        public boolean needsMajorCompaction(SortedMap<FileRef, DataFileValue> tabletFiles, MajorCompactionReason reason) {
            long idleTime;
            if (this.closed) {
                return false;
            }
            if (reason == MajorCompactionReason.USER) {
                return true;
            }
            if (reason == MajorCompactionReason.IDLE && (idleTime = this.lastReportedCommitTime == 0L ? System.currentTimeMillis() - this.creationTime : System.currentTimeMillis() - this.lastReportedCommitTime) < this.tableConf.getTimeInMillis(Property.TABLE_MAJC_COMPACTALL_IDLETIME)) {
                return false;
            }
            CompactionStrategy strategy = (CompactionStrategy)Property.createTableInstanceFromPropertyName((AccumuloConfiguration)this.tableConf, (Property)Property.TABLE_COMPACTION_STRATEGY, CompactionStrategy.class, (Object)new DefaultCompactionStrategy());
            strategy.init(Property.getCompactionStrategyOptions((AccumuloConfiguration)this.tableConf));
            MajorCompactionRequest request = new MajorCompactionRequest(this.extent, reason, this.tableConf, TabletServerResourceManager.this.context);
            request.setFiles(tabletFiles);
            try {
                return strategy.shouldCompact(request);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void executeMinorCompaction(Runnable r) {
            TabletServerResourceManager.this.minorCompactionThreadPool.execute((Runnable)new LoggingRunnable(log, r));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            TabletServerResourceManager tabletServerResourceManager = TabletServerResourceManager.this;
            synchronized (tabletServerResourceManager) {
                TabletResourceManager tabletResourceManager = this;
                synchronized (tabletResourceManager) {
                    if (this.closed) {
                        throw new IOException("closed");
                    }
                    if (this.openFilesReserved) {
                        throw new IOException("tired to close files while open files reserved");
                    }
                    TabletServerResourceManager.this.memMgmt.tabletClosed(this.extent);
                    TabletServerResourceManager.this.memoryManager.tabletClosed(this.extent);
                    this.closed = true;
                }
            }
        }

        public TabletServerResourceManager getTabletServerResourceManager() {
            return TabletServerResourceManager.this;
        }

        public void executeMajorCompaction(KeyExtent tablet, Runnable compactionTask) {
            TabletServerResourceManager.this.executeMajorCompaction(tablet, compactionTask);
        }
    }

    private class MemoryManagementFramework {
        private final Map<KeyExtent, TabletStateImpl> tabletReports;
        private final LinkedBlockingQueue<TabletStateImpl> memUsageReports;
        private long lastMemCheckTime = System.currentTimeMillis();
        private long maxMem;
        private long lastMemTotal = 0L;
        private final Thread memoryGuardThread;
        private final Thread minorCompactionInitiatorThread;

        MemoryManagementFramework() {
            this.tabletReports = Collections.synchronizedMap(new HashMap());
            this.memUsageReports = new LinkedBlockingQueue();
            this.maxMem = TabletServerResourceManager.this.context.getConfiguration().getAsBytes(Property.TSERV_MAXMEM);
            Runnable r1 = new Runnable(){

                @Override
                public void run() {
                    MemoryManagementFramework.this.processTabletMemStats();
                }
            };
            this.memoryGuardThread = new Daemon((Runnable)new LoggingRunnable(log, r1));
            this.memoryGuardThread.setPriority(6);
            this.memoryGuardThread.setName("Accumulo Memory Guard");
            Runnable r2 = new Runnable(){

                @Override
                public void run() {
                    MemoryManagementFramework.this.manageMemory();
                }
            };
            this.minorCompactionInitiatorThread = new Daemon((Runnable)new LoggingRunnable(log, r2));
            this.minorCompactionInitiatorThread.setName("Accumulo Minor Compaction Initiator");
        }

        void startThreads() {
            this.memoryGuardThread.start();
            this.minorCompactionInitiatorThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTabletMemStats() {
            while (true) {
                try {
                    while (true) {
                        TabletStateImpl report = this.memUsageReports.take();
                        while (report != null) {
                            this.tabletReports.put(report.getExtent(), report);
                            report = this.memUsageReports.poll();
                        }
                        long delta = System.currentTimeMillis() - this.lastMemCheckTime;
                        if (!TabletServerResourceManager.this.holdCommits && delta <= 50L && !((double)this.lastMemTotal > 0.9 * (double)this.maxMem)) continue;
                        this.lastMemCheckTime = System.currentTimeMillis();
                        long totalMemUsed = 0L;
                        Map<KeyExtent, TabletStateImpl> map = this.tabletReports;
                        synchronized (map) {
                            for (TabletStateImpl tsi : this.tabletReports.values()) {
                                totalMemUsed += tsi.getMemTableSize();
                                totalMemUsed += tsi.getMinorCompactingMemTableSize();
                            }
                        }
                        if ((double)totalMemUsed > 0.95 * (double)this.maxMem) {
                            TabletServerResourceManager.this.holdAllCommits(true);
                        } else {
                            TabletServerResourceManager.this.holdAllCommits(false);
                        }
                        this.lastMemTotal = totalMemUsed;
                    }
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted processing tablet memory statistics", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void manageMemory() {
            while (true) {
                block17: {
                    MemoryManagementActions mma = null;
                    HashMap<KeyExtent, TabletStateImpl> tabletReportsCopy = null;
                    try {
                        Map<KeyExtent, TabletStateImpl> map = this.tabletReports;
                        synchronized (map) {
                            tabletReportsCopy = new HashMap<KeyExtent, TabletStateImpl>(this.tabletReports);
                        }
                        ArrayList tabletStates = new ArrayList(tabletReportsCopy.values());
                        mma = TabletServerResourceManager.this.memoryManager.getMemoryManagementActions(tabletStates);
                    }
                    catch (Throwable t) {
                        log.error("Memory manager failed {}", (Object)t.getMessage(), (Object)t);
                    }
                    try {
                        if (mma == null || mma.tabletsToMinorCompact == null || mma.tabletsToMinorCompact.size() <= 0) break block17;
                        for (KeyExtent keyExtent : mma.tabletsToMinorCompact) {
                            TabletStateImpl tabletReport = (TabletStateImpl)tabletReportsCopy.get(keyExtent);
                            if (tabletReport == null) {
                                log.warn("Memory manager asked to compact nonexistent tablet {}; manager implementation might be misbehaving", (Object)keyExtent);
                                continue;
                            }
                            Tablet tablet = tabletReport.getTablet();
                            if (tablet.initiateMinorCompaction(MinorCompactionReason.SYSTEM)) continue;
                            if (tablet.isClosed()) {
                                Map<KeyExtent, TabletStateImpl> map = this.tabletReports;
                                synchronized (map) {
                                    TabletStateImpl latestReport = this.tabletReports.remove(keyExtent);
                                    if (latestReport != null) {
                                        if (latestReport.getTablet() != tablet) {
                                            this.tabletReports.put(keyExtent, latestReport);
                                        } else {
                                            log.debug("Cleaned up report for closed tablet {}", (Object)keyExtent);
                                        }
                                    }
                                }
                                log.debug("Ignoring memory manager recommendation: not minor compacting closed tablet {}", (Object)keyExtent);
                                continue;
                            }
                            log.info("Ignoring memory manager recommendation: not minor compacting {}", (Object)keyExtent);
                        }
                    }
                    catch (Throwable t) {
                        log.error("Minor compactions for memory managment failed", t);
                    }
                }
                UtilWaitThread.sleepUninterruptibly((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }

        public void updateMemoryUsageStats(Tablet tablet, long size, long lastCommitTime, long mincSize) {
            this.memUsageReports.add(new TabletStateImpl(tablet, size, lastCommitTime, mincSize));
        }

        public void tabletClosed(KeyExtent extent) {
            this.tabletReports.remove(extent);
        }
    }

    private static class TabletStateImpl
    implements TabletState,
    Cloneable {
        private final long lct;
        private final Tablet tablet;
        private final long mts;
        private final long mcmts;

        public TabletStateImpl(Tablet t, long mts, long lct, long mcmts) {
            this.tablet = t;
            this.mts = mts;
            this.lct = lct;
            this.mcmts = mcmts;
        }

        public KeyExtent getExtent() {
            return this.tablet.getExtent();
        }

        Tablet getTablet() {
            return this.tablet;
        }

        public long getLastCommitTime() {
            return this.lct;
        }

        public long getMemTableSize() {
            return this.mts;
        }

        public long getMinorCompactingMemTableSize() {
            return this.mcmts;
        }

        public TabletStateImpl clone() throws CloneNotSupportedException {
            return (TabletStateImpl)super.clone();
        }
    }

    protected static class AssignmentWatcher
    implements Runnable {
        private static final Logger log = LoggerFactory.getLogger(AssignmentWatcher.class);
        private final Map<KeyExtent, RunnableStartedAt> activeAssignments;
        private final AccumuloConfiguration conf;
        private final SimpleTimer timer;

        public AssignmentWatcher(AccumuloConfiguration conf, Map<KeyExtent, RunnableStartedAt> activeAssignments, SimpleTimer timer) {
            this.conf = conf;
            this.activeAssignments = activeAssignments;
            this.timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long millisBeforeWarning = this.conf.getTimeInMillis(Property.TSERV_ASSIGNMENT_DURATION_WARNING);
            try {
                long now = System.currentTimeMillis();
                for (Map.Entry<KeyExtent, RunnableStartedAt> entry : this.activeAssignments.entrySet()) {
                    KeyExtent extent = entry.getKey();
                    RunnableStartedAt runnable = entry.getValue();
                    long duration = now - runnable.getStartTime();
                    if (duration > millisBeforeWarning) {
                        log.warn("Assignment for {} has been running for at least {}ms", new Object[]{extent, duration, runnable.getTask().getException()});
                        continue;
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Assignment for {} only running for {}ms", (Object)extent, (Object)duration);
                }
            }
            catch (Exception e) {
                log.warn("Caught exception checking active assignments", (Throwable)e);
            }
            finally {
                long delay = Math.max((long)((double)millisBeforeWarning * 0.5), 5000L);
                if (log.isTraceEnabled()) {
                    log.trace("Rescheduling assignment watcher to run in {}ms", (Object)delay);
                }
                this.timer.schedule((Runnable)this, delay);
            }
        }
    }

    private static class ScanExecutorImpl
    implements ScanExecutor {
        private final ConfigImpl config;
        private final Queue<?> queue;

        ScanExecutorImpl(AccumuloConfiguration.ScanExecutorConfig sec, Queue<?> q) {
            this.config = new ConfigImpl(sec);
            this.queue = q;
        }

        public int getQueued() {
            return this.queue.size();
        }

        public ScanExecutor.Config getConfig() {
            return this.config;
        }

        private static class ConfigImpl
        implements ScanExecutor.Config {
            final AccumuloConfiguration.ScanExecutorConfig cfg;

            public ConfigImpl(AccumuloConfiguration.ScanExecutorConfig sec) {
                this.cfg = sec;
            }

            public String getName() {
                return this.cfg.name;
            }

            public int getMaxThreads() {
                return this.cfg.maxThreads;
            }

            public Optional<String> getPrioritizerClass() {
                return this.cfg.prioritizerClass;
            }

            public Map<String, String> getPrioritizerOptions() {
                return this.cfg.prioritizerOpts;
            }
        }
    }
}

