/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import org.apache.accumulo.core.rpc.TBufferedSocket;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientInfoProcessorFactory
extends TProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(ClientInfoProcessorFactory.class);
    private final ThreadLocal<String> clientAddress;

    public ClientInfoProcessorFactory(ThreadLocal<String> clientAddress, TProcessor processor) {
        super(processor);
        this.clientAddress = clientAddress;
    }

    public TProcessor getProcessor(TTransport trans) {
        if (trans instanceof TBufferedSocket) {
            TBufferedSocket tsock = (TBufferedSocket)trans;
            this.clientAddress.set(tsock.getClientString());
        } else if (trans instanceof TSocket) {
            TSocket tsock = (TSocket)trans;
            this.clientAddress.set(tsock.getSocket().getInetAddress().getHostAddress() + ":" + tsock.getSocket().getPort());
        } else {
            log.warn("Unable to extract clientAddress from transport of type {}", trans.getClass());
        }
        return super.getProcessor(trans);
    }
}

