/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.master.thrift.DeadServer;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadServerList {
    private static final Logger log = LoggerFactory.getLogger(DeadServerList.class);
    private final String path;
    private final ZooReaderWriter zoo;

    public DeadServerList(ServerContext context, String path) {
        this.path = path;
        this.zoo = context.getZooReaderWriter();
        try {
            context.getZooReaderWriter().mkdirs(path);
        }
        catch (Exception ex) {
            log.error("Unable to make parent directories of " + path, (Throwable)ex);
        }
    }

    public List<DeadServer> getList() {
        ArrayList<DeadServer> result;
        block5: {
            result = new ArrayList<DeadServer>();
            try {
                List children = this.zoo.getChildren(this.path);
                if (children == null) break block5;
                for (String child : children) {
                    byte[] data;
                    Stat stat = new Stat();
                    try {
                        data = this.zoo.getData(this.path + "/" + child, stat);
                    }
                    catch (KeeperException.NoNodeException nne) {
                        continue;
                    }
                    DeadServer server = new DeadServer(child, stat.getMtime(), new String(data, StandardCharsets.UTF_8));
                    result.add(server);
                }
            }
            catch (Exception ex) {
                log.error("{}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        return result;
    }

    public void delete(String server) {
        try {
            this.zoo.recursiveDelete(this.path + "/" + server, ZooUtil.NodeMissingPolicy.SKIP);
        }
        catch (Exception ex) {
            log.error("delete failed with exception", (Throwable)ex);
        }
    }

    public void post(String server, String cause) {
        try {
            this.zoo.putPersistentData(this.path + "/" + server, cause.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.SKIP);
        }
        catch (Exception ex) {
            log.error("post failed with exception", (Throwable)ex);
        }
    }
}

