/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.accumulo.server.fs.RandomVolumeChooser;
import org.apache.accumulo.server.fs.VolumeChooser;
import org.apache.accumulo.server.fs.VolumeChooserEnvironment;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferredVolumeChooser
extends RandomVolumeChooser {
    private static final Logger log = LoggerFactory.getLogger(PreferredVolumeChooser.class);
    private static final String TABLE_CUSTOM_SUFFIX = "volume.preferred";
    private static final String DEFAULT_SCOPED_PREFERRED_VOLUMES = PreferredVolumeChooser.getCustomPropertySuffix(VolumeChooserEnvironment.ChooserScope.DEFAULT);

    private static final String getCustomPropertySuffix(VolumeChooserEnvironment.ChooserScope scope) {
        return "volume.preferred." + scope.name().toLowerCase();
    }

    @Override
    public String choose(VolumeChooserEnvironment env, String[] options) throws VolumeChooser.VolumeChooserException {
        log.trace("{}.choose", (Object)this.getClass().getSimpleName());
        String choice = super.choose(env, this.getPreferredVolumes(env, options));
        log.trace("Choice = {}", (Object)choice);
        return choice;
    }

    String[] getPreferredVolumes(VolumeChooserEnvironment env, String[] options) {
        switch (env.getScope()) {
            case INIT: {
                log.warn("Not possible to determine preferred volumes at '{}' scope. Using all volumes.", (Object)VolumeChooserEnvironment.ChooserScope.INIT);
                return options;
            }
            case TABLE: {
                return this.getPreferredVolumesForTable(env, options);
            }
        }
        return this.getPreferredVolumesForScope(env, options);
    }

    private String[] getPreferredVolumesForTable(VolumeChooserEnvironment env, String[] options) {
        log.trace("Looking up property {} + for Table id: {}", (Object)TABLE_CUSTOM_SUFFIX, (Object)env.getTableId());
        String preferredVolumes = env.getServiceEnv().getConfiguration(env.getTableId()).getTableCustom(TABLE_CUSTOM_SUFFIX);
        if (preferredVolumes == null || preferredVolumes.isEmpty()) {
            preferredVolumes = env.getServiceEnv().getConfiguration().getCustom(DEFAULT_SCOPED_PREFERRED_VOLUMES);
        }
        if (preferredVolumes == null || preferredVolumes.isEmpty()) {
            String msg = "Property volume.preferred or " + DEFAULT_SCOPED_PREFERRED_VOLUMES + " must be a subset of " + Arrays.toString(options) + " to use the " + this.getClass().getSimpleName();
            throw new VolumeChooser.VolumeChooserException(msg);
        }
        return this.parsePreferred(TABLE_CUSTOM_SUFFIX, preferredVolumes, options);
    }

    private String[] getPreferredVolumesForScope(VolumeChooserEnvironment env, String[] options) {
        VolumeChooserEnvironment.ChooserScope scope = env.getScope();
        String property = PreferredVolumeChooser.getCustomPropertySuffix(scope);
        log.trace("Looking up property {} for scope: {}", (Object)property, (Object)scope);
        String preferredVolumes = env.getServiceEnv().getConfiguration().getCustom(property);
        if ((preferredVolumes == null || preferredVolumes.isEmpty()) && scope != VolumeChooserEnvironment.ChooserScope.DEFAULT) {
            log.debug("{} not found; using {}", (Object)property, (Object)DEFAULT_SCOPED_PREFERRED_VOLUMES);
            preferredVolumes = env.getServiceEnv().getConfiguration().getCustom(DEFAULT_SCOPED_PREFERRED_VOLUMES);
            if (preferredVolumes == null || preferredVolumes.isEmpty()) {
                String msg = "Property " + property + " or " + DEFAULT_SCOPED_PREFERRED_VOLUMES + " must be a subset of " + Arrays.toString(options) + " to use the " + this.getClass().getSimpleName();
                throw new VolumeChooser.VolumeChooserException(msg);
            }
            property = DEFAULT_SCOPED_PREFERRED_VOLUMES;
        }
        return this.parsePreferred(property, preferredVolumes, options);
    }

    private String[] parsePreferred(String property, String preferredVolumes, String[] options) {
        log.trace("Found {} = {}", (Object)property, (Object)preferredVolumes);
        Set<String> preferred = Arrays.stream(StringUtils.split((String)preferredVolumes, (char)',')).map(String::trim).collect(Collectors.toSet());
        if (preferred.isEmpty()) {
            String msg = "No volumes could be parsed from '" + property + "', which had a value of '" + preferredVolumes + "'";
            throw new VolumeChooser.VolumeChooserException(msg);
        }
        Set optionsList = Arrays.stream(options).collect(Collectors.toSet());
        if (!preferred.stream().allMatch(optionsList::contains)) {
            String msg = "Some volumes in " + preferred + " are not valid volumes from " + optionsList;
            throw new VolumeChooser.VolumeChooserException(msg);
        }
        return preferred.toArray(new String[preferred.size()]);
    }
}

