/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.fate.Repo;
import org.apache.htrace.TraceScope;

public class TraceRepo<T>
implements Repo<T> {
    private static final long serialVersionUID = 1L;
    long traceId;
    long parentId;
    Repo<T> repo;

    public TraceRepo(Repo<T> repo) {
        this.repo = repo;
        TInfo tinfo = TraceUtil.traceInfo();
        this.traceId = tinfo.traceId;
        this.parentId = tinfo.parentId;
    }

    public long isReady(long tid, T environment) throws Exception {
        try (TraceScope t = TraceUtil.trace((TInfo)new TInfo(this.traceId, this.parentId), (String)this.repo.getDescription());){
            long l = this.repo.isReady(tid, environment);
            return l;
        }
    }

    public Repo<T> call(long tid, T environment) throws Exception {
        try (TraceScope t = TraceUtil.trace((TInfo)new TInfo(this.traceId, this.parentId), (String)this.repo.getDescription());){
            Repo result = this.repo.call(tid, environment);
            if (result == null) {
                Repo<T> repo = null;
                return repo;
            }
            TraceRepo<T> traceRepo = new TraceRepo<T>(result);
            return traceRepo;
        }
    }

    public void undo(long tid, T environment) throws Exception {
        try (TraceScope t = TraceUtil.trace((TInfo)new TInfo(this.traceId, this.parentId), (String)this.repo.getDescription());){
            this.repo.undo(tid, environment);
        }
    }

    public String getDescription() {
        return this.repo.getDescription();
    }

    public String getReturn() {
        return this.repo.getReturn();
    }
}

