/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.ExportInfo;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;

class WriteExportFiles
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private final ExportInfo tableInfo;

    WriteExportFiles(ExportInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    private void checkOffline(Connector conn) throws Exception {
        if (Tables.getTableState((Instance)conn.getInstance(), (String)this.tableInfo.tableID) != TableState.OFFLINE) {
            Tables.clearCache((Instance)conn.getInstance());
            if (Tables.getTableState((Instance)conn.getInstance(), (String)this.tableInfo.tableID) != TableState.OFFLINE) {
                throw new AcceptableThriftTableOperationException(this.tableInfo.tableID, this.tableInfo.tableName, TableOperation.EXPORT, TableOperationExceptionType.OTHER, "Table is not offline");
            }
        }
    }

    @Override
    public long isReady(long tid, Master master) throws Exception {
        long reserved = Utils.reserveNamespace(this.tableInfo.namespaceID, tid, false, true, TableOperation.EXPORT) + Utils.reserveTable(this.tableInfo.tableID, tid, false, true, TableOperation.EXPORT);
        if (reserved > 0L) {
            return reserved;
        }
        Connector conn = master.getConnector();
        this.checkOffline(conn);
        Scanner metaScanner = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        metaScanner.setRange(new KeyExtent(this.tableInfo.tableID, null, null).toMetadataRange());
        metaScanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        metaScanner.fetchColumnFamily(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME);
        if (metaScanner.iterator().hasNext()) {
            return 500L;
        }
        metaScanner.clearColumns();
        metaScanner.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
        if (metaScanner.iterator().hasNext()) {
            throw new AcceptableThriftTableOperationException(this.tableInfo.tableID, this.tableInfo.tableName, TableOperation.EXPORT, TableOperationExceptionType.OTHER, "Write ahead logs found for table");
        }
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        try {
            WriteExportFiles.exportTable(master.getFileSystem(), master, this.tableInfo.tableName, this.tableInfo.tableID, this.tableInfo.exportDir);
        }
        catch (IOException ioe) {
            throw new AcceptableThriftTableOperationException(this.tableInfo.tableID, this.tableInfo.tableName, TableOperation.EXPORT, TableOperationExceptionType.OTHER, "Failed to create export files " + ioe.getMessage());
        }
        Utils.unreserveNamespace(this.tableInfo.namespaceID, tid, false);
        Utils.unreserveTable(this.tableInfo.tableID, tid, false);
        Utils.unreserveHdfsDirectory(new Path(this.tableInfo.exportDir).toString(), tid);
        return null;
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Utils.unreserveNamespace(this.tableInfo.namespaceID, tid, false);
        Utils.unreserveTable(this.tableInfo.tableID, tid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportTable(VolumeManager fs, AccumuloServerContext context, String tableName, String tableID, String exportDir) throws Exception {
        fs.mkdirs(new Path(exportDir));
        Path exportMetaFilePath = fs.getVolumeByPath(new Path(exportDir)).getFileSystem().makeQualified(new Path(exportDir, "exportMetadata.zip"));
        FSDataOutputStream fileOut = fs.create(exportMetaFilePath, false);
        ZipOutputStream zipOut = new ZipOutputStream((OutputStream)fileOut);
        BufferedOutputStream bufOut = new BufferedOutputStream(zipOut);
        try (DataOutputStream dataOut = new DataOutputStream(bufOut);){
            zipOut.putNextEntry(new ZipEntry("accumulo_export_info.txt"));
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)dataOut, StandardCharsets.UTF_8);
            osw.append("exportVersion:1\n");
            osw.append("srcInstanceName:" + context.getInstance().getInstanceName() + "\n");
            osw.append("srcInstanceID:" + context.getInstance().getInstanceID() + "\n");
            osw.append("srcZookeepers:" + context.getInstance().getZooKeepers() + "\n");
            osw.append("srcTableName:" + tableName + "\n");
            osw.append("srcTableID:" + tableID + "\n");
            osw.append("srcDataVersion:8\n");
            osw.append("srcCodeVersion:1.10.0\n");
            osw.flush();
            dataOut.flush();
            WriteExportFiles.exportConfig(context, tableID, zipOut, dataOut);
            dataOut.flush();
            Map<String, String> uniqueFiles = WriteExportFiles.exportMetadata(fs, context, tableID, zipOut, dataOut);
            dataOut.close();
            dataOut = null;
            WriteExportFiles.createDistcpFile(fs, exportDir, exportMetaFilePath, uniqueFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createDistcpFile(VolumeManager fs, String exportDir, Path exportMetaFilePath, Map<String, String> uniqueFiles) throws IOException {
        try (BufferedWriter distcpOut = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(new Path(exportDir, "distcp.txt"), false), StandardCharsets.UTF_8));){
            for (String file : uniqueFiles.values()) {
                distcpOut.append(file);
                distcpOut.newLine();
            }
            distcpOut.append(exportMetaFilePath.toString());
            distcpOut.newLine();
            distcpOut.close();
            distcpOut = null;
        }
    }

    private static Map<String, String> exportMetadata(VolumeManager fs, AccumuloServerContext context, String tableID, ZipOutputStream zipOut, DataOutputStream dataOut) throws IOException, TableNotFoundException, AccumuloException, AccumuloSecurityException {
        zipOut.putNextEntry(new ZipEntry("metadata.bin"));
        HashMap<String, String> uniqueFiles = new HashMap<String, String>();
        Scanner metaScanner = context.getConnector().createScanner("accumulo.metadata", Authorizations.EMPTY);
        metaScanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)metaScanner);
        MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.fetch((ScannerBase)metaScanner);
        metaScanner.setRange(new KeyExtent(tableID, null, null).toMetadataRange());
        for (Map.Entry entry : metaScanner) {
            ((Key)entry.getKey()).write((DataOutput)dataOut);
            ((Value)entry.getValue()).write((DataOutput)dataOut);
            if (!((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) continue;
            String path = fs.getFullPath((Key)entry.getKey()).toString();
            String[] tokens = path.split("/");
            if (tokens.length < 1) {
                throw new RuntimeException("Illegal path " + path);
            }
            String filename = tokens[tokens.length - 1];
            String existingPath = (String)uniqueFiles.get(filename);
            if (existingPath == null) {
                uniqueFiles.put(filename, path);
                continue;
            }
            if (existingPath.equals(path)) continue;
            throw new IOException("Cannot export table with nonunique file names " + filename + ". Major compact table.");
        }
        return uniqueFiles;
    }

    private static void exportConfig(AccumuloServerContext context, String tableID, ZipOutputStream zipOut, DataOutputStream dataOut) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, IOException {
        Connector conn = context.getConnector();
        DefaultConfiguration defaultConfig = AccumuloConfiguration.getDefaultConfiguration();
        Map siteConfig = conn.instanceOperations().getSiteConfiguration();
        Map systemConfig = conn.instanceOperations().getSystemConfiguration();
        TableConfiguration tableConfig = context.getServerConfigurationFactory().getTableConfiguration(tableID);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)dataOut, StandardCharsets.UTF_8);
        zipOut.putNextEntry(new ZipEntry("table_config.txt"));
        for (Map.Entry prop : tableConfig) {
            Property key;
            if (!((String)prop.getKey()).startsWith(Property.TABLE_PREFIX.getKey()) || (key = Property.getPropertyByKey((String)((String)prop.getKey()))) != null && defaultConfig.get(key).equals(prop.getValue()) || ((String)prop.getValue()).equals(siteConfig.get(prop.getKey())) || ((String)prop.getValue()).equals(systemConfig.get(prop.getKey()))) continue;
            osw.append((String)prop.getKey() + "=" + (String)prop.getValue() + "\n");
        }
        osw.flush();
    }
}

