/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.DistributedReadWriteLock;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReservation;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooQueueLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final byte[] ZERO_BYTE = new byte[]{48};
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    static final Lock tableNameLock = new ReentrantLock();
    static final Lock idLock = new ReentrantLock();

    static void checkTableDoesNotExist(Instance instance, String tableName, String tableId, TableOperation operation) throws AcceptableThriftTableOperationException {
        String id = (String)Tables.getNameToIdMap((Instance)instance).get(tableName);
        if (id != null && !id.equals(tableId)) {
            throw new AcceptableThriftTableOperationException(null, tableName, operation, TableOperationExceptionType.EXISTS, null);
        }
    }

    static String getNextTableId(String tableName, Instance instance) throws AcceptableThriftTableOperationException {
        String tableId = null;
        try {
            ZooReaderWriter zoo = ZooReaderWriter.getInstance();
            String ntp = ZooUtil.getRoot((Instance)instance) + "/tables";
            byte[] nid = zoo.mutate(ntp, ZERO_BYTE, ZooUtil.PUBLIC, new IZooReaderWriter.Mutator(){

                public byte[] mutate(byte[] currentValue) throws Exception {
                    BigInteger nextId = new BigInteger(new String(currentValue, StandardCharsets.UTF_8), 36);
                    nextId = nextId.add(BigInteger.ONE);
                    return nextId.toString(36).getBytes(StandardCharsets.UTF_8);
                }
            });
            return new String(nid, StandardCharsets.UTF_8);
        }
        catch (Exception e1) {
            log.error("Failed to assign tableId to " + tableName, (Throwable)e1);
            throw new AcceptableThriftTableOperationException(tableId, tableName, TableOperation.CREATE, TableOperationExceptionType.OTHER, e1.getMessage());
        }
    }

    public static long reserveTable(String tableId, long tid, boolean writeLock, boolean tableMustExist, TableOperation op) throws Exception {
        if (Utils.getLock(tableId, tid, writeLock).tryLock()) {
            if (tableMustExist) {
                Instance instance = HdfsZooInstance.getInstance();
                ZooReaderWriter zk = ZooReaderWriter.getInstance();
                if (!zk.exists(ZooUtil.getRoot((Instance)instance) + "/tables" + "/" + tableId)) {
                    throw new AcceptableThriftTableOperationException(tableId, "", op, TableOperationExceptionType.NOTFOUND, "Table does not exist");
                }
            }
            log.info("table " + tableId + " (" + Long.toHexString(tid) + ") locked for " + (writeLock ? "write" : "read") + " operation: " + op);
            return 0L;
        }
        return 100L;
    }

    public static void unreserveTable(String tableId, long tid, boolean writeLock) throws Exception {
        Utils.getLock(tableId, tid, writeLock).unlock();
        log.info("table " + tableId + " (" + Long.toHexString(tid) + ") unlocked for " + (writeLock ? "write" : "read"));
    }

    public static void unreserveNamespace(String namespaceId, long id, boolean writeLock) throws Exception {
        Utils.getLock(namespaceId, id, writeLock).unlock();
        log.info("namespace " + namespaceId + " (" + Long.toHexString(id) + ") unlocked for " + (writeLock ? "write" : "read"));
    }

    public static long reserveNamespace(String namespaceId, long id, boolean writeLock, boolean mustExist, TableOperation op) throws Exception {
        if (Utils.getLock(namespaceId, id, writeLock).tryLock()) {
            if (mustExist) {
                Instance instance = HdfsZooInstance.getInstance();
                ZooReaderWriter zk = ZooReaderWriter.getInstance();
                if (!zk.exists(ZooUtil.getRoot((Instance)instance) + "/namespaces" + "/" + namespaceId)) {
                    throw new AcceptableThriftTableOperationException(namespaceId, "", op, TableOperationExceptionType.NAMESPACE_NOTFOUND, "Namespace does not exist");
                }
            }
            log.info("namespace " + namespaceId + " (" + Long.toHexString(id) + ") locked for " + (writeLock ? "write" : "read") + " operation: " + op);
            return 0L;
        }
        return 100L;
    }

    public static String getNamespaceId(Instance instance, String tableId, TableOperation op, String namespaceId) throws Exception {
        if (namespaceId != null) {
            return namespaceId;
        }
        try {
            return Tables.getNamespaceId((Instance)instance, (String)tableId);
        }
        catch (RuntimeException e) {
            ZooReaderWriter zk = ZooReaderWriter.getInstance();
            if (!zk.exists(ZooUtil.getRoot((Instance)instance) + "/tables" + "/" + tableId)) {
                throw new AcceptableThriftTableOperationException(tableId, "", op, TableOperationExceptionType.NOTFOUND, "Table does not exist");
            }
            throw e;
        }
    }

    public static long reserveHdfsDirectory(String directory, long tid) throws KeeperException, InterruptedException {
        Instance instance = HdfsZooInstance.getInstance();
        String resvPath = ZooUtil.getRoot((Instance)instance) + "/hdfs_reservations" + "/" + Base64.getEncoder().encodeToString(directory.getBytes(StandardCharsets.UTF_8));
        ZooReaderWriter zk = ZooReaderWriter.getInstance();
        if (ZooReservation.attempt((IZooReaderWriter)zk, (String)resvPath, (String)String.format("%016x", tid), (String)"")) {
            return 0L;
        }
        return 50L;
    }

    public static void unreserveHdfsDirectory(String directory, long tid) throws KeeperException, InterruptedException {
        Instance instance = HdfsZooInstance.getInstance();
        String resvPath = ZooUtil.getRoot((Instance)instance) + "/hdfs_reservations" + "/" + Base64.getEncoder().encodeToString(directory.getBytes(StandardCharsets.UTF_8));
        ZooReservation.release((IZooReaderWriter)ZooReaderWriter.getInstance(), (String)resvPath, (String)String.format("%016x", tid));
    }

    private static Lock getLock(String tableId, long tid, boolean writeLock) throws Exception {
        byte[] lockData = String.format("%016x", tid).getBytes(StandardCharsets.UTF_8);
        ZooQueueLock qlock = new ZooQueueLock(ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/table_locks" + "/" + tableId, false);
        Lock lock = DistributedReadWriteLock.recoverLock((DistributedReadWriteLock.QueueLock)qlock, (byte[])lockData);
        if (lock == null) {
            DistributedReadWriteLock locker = new DistributedReadWriteLock((DistributedReadWriteLock.QueueLock)qlock, lockData);
            lock = writeLock ? locker.writeLock() : locker.readLock();
        }
        return lock;
    }

    public static Lock getReadLock(String tableId, long tid) throws Exception {
        return Utils.getLock(tableId, tid, false);
    }

    static void checkNamespaceDoesNotExist(Instance instance, String namespace, String namespaceId, TableOperation operation) throws AcceptableThriftTableOperationException {
        String n = (String)Namespaces.getNameToIdMap((Instance)instance).get(namespace);
        if (n != null && !n.equals(namespaceId)) {
            throw new AcceptableThriftTableOperationException(null, namespace, operation, TableOperationExceptionType.NAMESPACE_EXISTS, null);
        }
    }
}

