/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import java.util.Map;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.SetupPermissions;
import org.apache.accumulo.master.tableOps.TableInfo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.tablets.TabletTime;

public class CreateTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private TableInfo tableInfo = new TableInfo();

    public CreateTable(String user, String tableName, TimeType timeType, Map<String, String> props, String namespaceId) {
        this.tableInfo.tableName = tableName;
        this.tableInfo.timeType = TabletTime.getTimeID((TimeType)timeType);
        this.tableInfo.user = user;
        this.tableInfo.props = props;
        this.tableInfo.namespaceId = namespaceId;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveNamespace(this.tableInfo.namespaceId, tid, false, true, TableOperation.CREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Utils.idLock.lock();
        try {
            this.tableInfo.tableId = Utils.getNextTableId(this.tableInfo.tableName, master.getInstance());
            SetupPermissions setupPermissions = new SetupPermissions(this.tableInfo);
            return setupPermissions;
        }
        finally {
            Utils.idLock.unlock();
        }
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Utils.unreserveNamespace(this.tableInfo.namespaceId, tid, false);
    }
}

