/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.replication;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.WholeRowIterator;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTableOfflineException;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveCompleteReplicationRecords
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RemoveCompleteReplicationRecords.class);
    private Connector conn;

    public RemoveCompleteReplicationRecords(Connector conn) {
        this.conn = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Duration duration;
        BatchWriter bw;
        BatchScanner bs;
        try {
            bs = ReplicationTable.getBatchScanner((Connector)this.conn, (int)4);
            bw = ReplicationTable.getBatchWriter((Connector)this.conn);
            if (bs == null || bw == null) {
                throw new AssertionError((Object)"Inconceivable; an exception should have been thrown, but 'bs' or 'bw' was null instead");
            }
        }
        catch (ReplicationTableOfflineException e) {
            log.debug("Not attempting to remove complete replication records as the table ({}) isn't yet online", (Object)"accumulo.replication");
            return;
        }
        bs.setRanges(Collections.singleton(new Range()));
        IteratorSetting cfg = new IteratorSetting(50, WholeRowIterator.class);
        ReplicationSchema.StatusSection.limit((ScannerBase)bs);
        ReplicationSchema.WorkSection.limit((ScannerBase)bs);
        bs.addScanIterator(cfg);
        long recordsRemoved = 0L;
        long startTime = System.nanoTime();
        try {
            recordsRemoved = this.removeCompleteRecords(this.conn, bs, bw);
        }
        finally {
            if (null != bs) {
                bs.close();
            }
            if (null != bw) {
                try {
                    bw.close();
                }
                catch (MutationsRejectedException e) {
                    log.error("Error writing mutations to {}, will retry", (Object)"accumulo.replication", (Object)e);
                }
            }
            duration = Duration.ofNanos(System.nanoTime() - startTime);
        }
        log.info("Removed {} complete replication entries from the table {} in {}", new Object[]{recordsRemoved, "accumulo.replication", duration});
    }

    protected long removeCompleteRecords(Connector conn, BatchScanner bs, BatchWriter bw) {
        Text row = new Text();
        Text colf = new Text();
        Text colq = new Text();
        long recordsRemoved = 0L;
        for (Map.Entry rowEntry : bs) {
            SortedMap columns;
            try {
                columns = WholeRowIterator.decodeRow((Key)((Key)rowEntry.getKey()), (Value)((Value)rowEntry.getValue()));
            }
            catch (IOException e) {
                log.error("Could not deserialize {} with WholeRowIterator", (Object)((Key)rowEntry.getKey()).getRow(), (Object)e);
                continue;
            }
            ((Key)rowEntry.getKey()).getRow(row);
            recordsRemoved += this.removeRowIfNecessary(bw, columns, row, colf, colq);
        }
        return recordsRemoved;
    }

    protected long removeRowIfNecessary(BatchWriter bw, SortedMap<Key, Value> columns, Text row, Text colf, Text colq) {
        long recordsRemoved = 0L;
        if (columns.isEmpty()) {
            return recordsRemoved;
        }
        Mutation m = new Mutation(row);
        HashMap<String, Long> tableToTimeCreated = new HashMap<String, Long>();
        for (Map.Entry<Key, Value> entry : columns.entrySet()) {
            String tableId;
            Replication.Status status;
            Object var12_14 = null;
            try {
                status = Replication.Status.parseFrom((byte[])entry.getValue().get());
            }
            catch (InvalidProtocolBufferException e) {
                log.error("Encountered unparsable protobuf for key: {}", (Object)entry.getKey().toStringNoTruncate());
                continue;
            }
            if (!StatusUtil.isSafeForRemoval((Replication.Status)status)) {
                return 0L;
            }
            Key k = entry.getKey();
            k.getColumnFamily(colf);
            k.getColumnQualifier(colq);
            log.debug("Removing {} {}:{} from replication table", new Object[]{row, colf, colq});
            m.putDelete(colf, colq);
            if (ReplicationSchema.StatusSection.NAME.equals((Object)colf)) {
                tableId = colq.toString();
            } else if (ReplicationSchema.WorkSection.NAME.equals((Object)colf)) {
                ReplicationTarget target = ReplicationTarget.from((Text)colq);
                tableId = target.getSourceTableId();
            } else {
                throw new RuntimeException("Got unexpected column");
            }
            if (status.hasCreatedTime()) {
                Long timeClosed = (Long)tableToTimeCreated.get(tableId);
                if (null == timeClosed) {
                    tableToTimeCreated.put(tableId, status.getCreatedTime());
                } else if (timeClosed.longValue() != status.getCreatedTime()) {
                    log.warn("Found multiple values for timeClosed for {}: {} and {}", new Object[]{row, timeClosed, status.getCreatedTime()});
                }
            }
            ++recordsRemoved;
        }
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        mutations.add(m);
        for (Map.Entry entry : tableToTimeCreated.entrySet()) {
            log.info("Removing order mutation for table {} at {} for {}", new Object[]{entry.getKey(), entry.getValue(), row.toString()});
            Mutation orderMutation = ReplicationSchema.OrderSection.createMutation((String)row.toString(), (long)((Long)entry.getValue()));
            orderMutation.putDelete(ReplicationSchema.OrderSection.NAME, new Text((String)entry.getKey()));
            mutations.add(orderMutation);
        }
        try {
            bw.addMutations(mutations);
            bw.flush();
        }
        catch (MutationsRejectedException mutationsRejectedException) {
            log.error("Could not submit mutation to remove columns for {} in replication table", (Object)row, (Object)mutationsRejectedException);
            return 0L;
        }
        return recordsRemoved;
    }
}

