/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.adapters.couchdb;

import com.fourspaces.couchdb.Document;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Text;
import org.apache.abdera.protocol.server.context.StreamWriterResponseContext;
import org.apache.abdera.protocol.server.provider.managed.FeedConfiguration;
import org.apache.abdera.util.Constants;
import org.apache.abdera.writer.StreamWriter;

public class JsonObjectResponseContext
extends StreamWriterResponseContext {
    private final FeedConfiguration config;
    private final Document doc;
    private final Document[] entries;

    protected JsonObjectResponseContext(Abdera abdera, FeedConfiguration config, Document doc) {
        this(abdera, config, doc, (Document[])null);
    }

    protected JsonObjectResponseContext(Abdera abdera, FeedConfiguration config, Document doc, Document ... entries) {
        super(abdera);
        this.doc = doc;
        this.entries = entries;
        this.config = config;
        this.setContentType(entries != null ? "application/atom+xml" : "application/atom+xml;type=entry");
    }

    protected JsonObjectResponseContext(Abdera abdera, FeedConfiguration config, String encoding, Document doc, Document ... entries) {
        super(abdera, encoding);
        this.doc = doc;
        this.entries = entries;
        this.config = config;
    }

    protected void writeTo(StreamWriter sw) throws IOException {
        sw.startDocument();
        if (this.entries != null) {
            JsonObjectResponseContext.writeJsonFeed(this.config, this.doc, this.entries, sw);
        } else {
            JsonObjectResponseContext.writeJsonEntry(this.doc, sw);
        }
        sw.endDocument();
    }

    public boolean hasEntity() {
        return true;
    }

    private static void writeJsonFeed(FeedConfiguration config, Document doc, Document[] entries, StreamWriter writer) {
        writer.startFeed();
        writer.writeId(config.getServerConfiguration().getServerUri() + "/" + config.getFeedId()).writeTitle(config.getFeedTitle()).writeAuthor(config.getFeedAuthor()).writeLink(config.getFeedUri()).writeLink(config.getFeedUri(), "self").writeUpdated(new Date());
        for (Document entry : entries) {
            JsonObjectResponseContext.writeJsonEntry(entry, writer);
        }
        writer.endFeed();
    }

    private static void writeJsonEntry(Document doc, StreamWriter writer) {
        writer.startEntry();
        JsonObjectResponseContext.writeJsonAttributes(doc.getJSONObject("attributes"), writer);
        for (Object key : doc.keySet()) {
            JSONObject obj;
            int n;
            JSONArray array;
            String name = (String)key;
            if (name.startsWith("_")) continue;
            if (name.equals("id")) {
                writer.writeId(doc.getString(name));
                continue;
            }
            if (name.equals("title")) {
                JsonObjectResponseContext.writeJsonTextElement(Constants.TITLE, doc.get(name), writer);
                continue;
            }
            if (name.equals("summary")) {
                JsonObjectResponseContext.writeJsonTextElement(Constants.SUMMARY, doc.get(name), writer);
                continue;
            }
            if (name.equals("rights")) {
                JsonObjectResponseContext.writeJsonTextElement(Constants.RIGHTS, doc.get(name), writer);
                continue;
            }
            if (name.equals("links")) {
                array = doc.getJSONArray(name);
                for (n = 0; n < array.size(); ++n) {
                    obj = array.getJSONObject(n);
                    writer.startElement(Constants.LINK);
                    JsonObjectResponseContext.writeJsonAttributes(obj, writer);
                    if (obj.containsKey((Object)"extensions")) {
                        JsonObjectResponseContext.writeJsonExtensions(obj.getJSONArray("extensions"), writer);
                    }
                    writer.endElement();
                }
                continue;
            }
            if (name.equals("categories")) {
                array = doc.getJSONArray(name);
                for (n = 0; n < array.size(); ++n) {
                    obj = array.getJSONObject(n);
                    writer.startElement(Constants.CATEGORY);
                    JsonObjectResponseContext.writeJsonAttributes(obj, writer);
                    if (obj.containsKey((Object)"extensions")) {
                        JsonObjectResponseContext.writeJsonExtensions(obj.getJSONArray("extensions"), writer);
                    }
                    writer.endElement();
                }
                continue;
            }
            if (name.equals("authors")) {
                array = doc.getJSONArray(name);
                for (n = 0; n < array.size(); ++n) {
                    obj = array.getJSONObject(n);
                    JsonObjectResponseContext.writeJsonPerson(Constants.AUTHOR, obj, writer);
                }
                continue;
            }
            if (name.equals("contributors")) {
                array = doc.getJSONArray(name);
                for (n = 0; n < array.size(); ++n) {
                    obj = array.getJSONObject(n);
                    JsonObjectResponseContext.writeJsonPerson(Constants.CONTRIBUTOR, obj, writer);
                }
                continue;
            }
            if (name.equals("updated")) {
                writer.writeUpdated(doc.getString(name));
                continue;
            }
            if (name.equals("published")) {
                writer.writePublished(doc.getString(name));
                continue;
            }
            if (name.equals("edited")) {
                writer.writeEdited(doc.getString(name));
                continue;
            }
            if (name.equals("content")) {
                JsonObjectResponseContext.writeJsonContentElement(doc.get(name), writer);
                continue;
            }
            if (name.equals("control")) {
                JSONObject control = doc.getJSONObject("control");
                writer.startControl();
                JsonObjectResponseContext.writeJsonAttributes(control.getJSONObject("attributes"), writer);
                writer.writeDraft(control.getBoolean("draft"));
                if (control.containsKey((Object)"extensions")) {
                    JsonObjectResponseContext.writeJsonExtensions(control.getJSONArray("extensions"), writer);
                }
                writer.endControl();
                continue;
            }
            if (!name.equals("source")) continue;
        }
        writer.endEntry();
    }

    private static void writeJsonPerson(QName qname, JSONObject object, StreamWriter writer) {
        writer.startPerson(qname);
        writer.writePersonName(object.getString("name"));
        if (object.containsKey((Object)"email")) {
            writer.writePersonEmail(object.getString("email"));
        }
        if (object.containsKey((Object)"uri")) {
            writer.writePersonUri(object.getString("uri"));
        }
        if (object.containsKey((Object)"extensions")) {
            JsonObjectResponseContext.writeJsonExtensions(object.getJSONArray("extensions"), writer);
        }
        writer.endPerson();
    }

    private static void writeJsonContentElement(Object value, StreamWriter writer) {
        if (value instanceof String) {
            writer.writeContent(Content.Type.TEXT, (String)value);
        } else if (value instanceof JSONObject) {
            JsonObjectResponseContext.writeJsonContent((JSONObject)value, writer);
        }
    }

    private static void writeJsonContent(JSONObject object, StreamWriter writer) {
        String type = object.getJSONObject("attributes").getString("type");
        Content.Type ctype = Content.Type.valueOf((String)type.toUpperCase());
        writer.startContent(ctype);
        if (ctype == Content.Type.XHTML) {
            writer.startElement(Constants.DIV);
        }
        JSONArray array = object.getJSONArray("children");
        for (int n = 0; n < array.size(); ++n) {
            Object child = array.get(n);
            if (child instanceof String) {
                writer.writeElementText((String)child);
                continue;
            }
            if (!(child instanceof JSONObject)) continue;
            JsonObjectResponseContext.writeJsonTextMarkup((JSONObject)child, writer, ctype == Content.Type.XHTML);
        }
        if (ctype == Content.Type.XHTML) {
            writer.endElement();
        }
        writer.endElement();
    }

    private static void writeJsonTextElement(QName qname, Object value, StreamWriter writer) {
        if (value instanceof String) {
            writer.writeText(qname, Text.Type.TEXT, (String)value);
        } else if (value instanceof JSONObject) {
            JsonObjectResponseContext.writeJsonText(qname, (JSONObject)value, writer);
        }
    }

    private static void writeJsonText(QName qname, JSONObject object, StreamWriter writer) {
        String type = object.getJSONObject("attributes").getString("type");
        Text.Type texttype = Text.Type.valueOf((String)type.toUpperCase());
        writer.startText(qname, texttype);
        if (texttype == Text.Type.XHTML) {
            writer.startElement(Constants.DIV);
        }
        JSONArray array = object.getJSONArray("children");
        for (int n = 0; n < array.size(); ++n) {
            Object child = array.get(n);
            if (child instanceof String) {
                writer.writeElementText((String)child);
                continue;
            }
            if (!(child instanceof JSONObject)) continue;
            JsonObjectResponseContext.writeJsonTextMarkup((JSONObject)child, writer, texttype == Text.Type.XHTML);
        }
        if (texttype == Text.Type.XHTML) {
            writer.endElement();
        }
        writer.endElement();
    }

    private static void writeJsonTextMarkup(JSONObject object, StreamWriter writer, boolean xhtml) {
        String name = object.getString("name");
        if (xhtml) {
            writer.startElement(name, "http://www.w3.org/1999/xhtml");
            JsonObjectResponseContext.writeJsonAttributes(object.getJSONObject("attributes"), writer);
            JSONArray array = object.getJSONArray("children");
            for (int n = 0; n < array.size(); ++n) {
                Object obj = array.get(n);
                if (obj instanceof String) {
                    writer.writeElementText((String)obj);
                    continue;
                }
                if (!(obj instanceof JSONObject)) continue;
                JsonObjectResponseContext.writeJsonTextMarkup((JSONObject)obj, writer, xhtml);
            }
            writer.endElement();
        } else {
            writer.writeElementText("<" + name);
            JSONObject attrs = object.getJSONObject("attributes");
            for (Object attr : attrs.entrySet()) {
                Map.Entry entry = (Map.Entry)attr;
                String attrname = (String)entry.getKey();
                String value = (String)entry.getValue();
                writer.writeElementText(" " + attrname + "=\"" + value + "\"");
            }
            writer.writeElementText(">");
            JSONArray array = object.getJSONArray("children");
            for (int n = 0; n < array.size(); ++n) {
                Object obj = array.get(n);
                if (obj instanceof String) {
                    writer.writeElementText((String)obj);
                    continue;
                }
                if (!(obj instanceof JSONObject)) continue;
                JsonObjectResponseContext.writeJsonTextMarkup((JSONObject)obj, writer, xhtml);
            }
            writer.writeElementText("</" + name + ">");
        }
    }

    private static void writeJsonAttributes(JSONObject object, StreamWriter writer) {
        for (Object key : object.keySet()) {
            String name = (String)key;
            if (name.startsWith("xmlns:")) continue;
            Object value = object.get(name);
            if (value instanceof String) {
                writer.writeAttribute(name, (String)value);
                continue;
            }
            if (!(value instanceof JSONObject)) continue;
            JSONObject valueObj = (JSONObject)value;
            String namespace = null;
            JSONObject valueAttrs = valueObj.getJSONObject("attributes");
            Iterator i$ = valueAttrs.keySet().iterator();
            if (i$.hasNext()) {
                Object vkey = i$.next();
                namespace = valueAttrs.getString((String)vkey);
            }
            String[] namesplit = name.split(":", 2);
            writer.writeAttribute(namesplit[1], namespace, namesplit[0], valueObj.getString("value"));
        }
    }

    private static void writeJsonExtensions(JSONArray array, StreamWriter writer) {
        for (int n = 0; n < array.size(); ++n) {
            JSONObject object = array.getJSONObject(n);
            JsonObjectResponseContext.writeJsonObject(object, writer);
        }
    }

    private static void writeJsonObject(JSONObject object, StreamWriter writer) {
        String name;
        String[] namesplit;
        Object vkey;
        String svkey;
        String namespace = null;
        JSONObject valueAttrs = object.getJSONObject("attributes");
        Iterator i$ = valueAttrs.keySet().iterator();
        if (i$.hasNext() && (svkey = (String)(vkey = i$.next())).startsWith("xmlns:")) {
            namespace = valueAttrs.getString(svkey);
        }
        if ((namesplit = (name = object.getString("name")).split(":", 2)).length > 1) {
            writer.startElement(namesplit[1], namespace, namesplit[0]);
        } else {
            writer.startElement(name, namespace);
        }
        JsonObjectResponseContext.writeJsonAttributes(valueAttrs, writer);
        JSONArray children = object.getJSONArray("children");
        for (int i = 0; i < children.size(); ++i) {
            Object child = children.get(i);
            if (child instanceof String) {
                writer.writeElementText((String)child);
                continue;
            }
            if (!(child instanceof JSONObject)) continue;
            JsonObjectResponseContext.writeJsonObject((JSONObject)child, writer);
        }
        writer.endElement();
    }
}

