/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.adapters.couchdb;

import com.fourspaces.couchdb.Database;
import com.fourspaces.couchdb.Document;
import com.fourspaces.couchdb.Session;
import com.fourspaces.couchdb.ViewResults;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.text.Normalizer;
import org.apache.abdera.i18n.text.Sanitizer;
import org.apache.abdera.model.AtomDate;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Link;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.adapters.couchdb.JsonObjectResponseContext;
import org.apache.abdera.protocol.server.provider.managed.FeedConfiguration;
import org.apache.abdera.protocol.server.provider.managed.ManagedCollectionAdapter;

public class CouchDbAdapter
extends ManagedCollectionAdapter {
    private final DocumentComparator sorter = new DocumentComparator();
    private final String host;
    private final int port;

    public CouchDbAdapter(Abdera abdera, FeedConfiguration config) {
        this(abdera, config, null, -1);
    }

    public CouchDbAdapter(Abdera abdera, FeedConfiguration config, String host, int port) {
        super(abdera, config);
        if (host == null && (host = (String)config.getProperty("couchdb.host")) == null) {
            host = "localhost";
        }
        if (port < 0) {
            try {
                port = Integer.parseInt((String)config.getProperty("couchdb.port"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (port < 0) {
                port = 5984;
            }
        }
        this.host = host;
        this.port = port;
    }

    private synchronized Database getDatabase(RequestContext request) {
        String name = request.getTarget().getParameter("feed");
        Session session = new Session(this.host, this.port);
        Database db = null;
        try {
            db = session.getDatabase(name);
        }
        catch (Exception e) {
            db = session.createDatabase(name);
        }
        return db;
    }

    public ResponseContext getFeed(RequestContext request) {
        Database db = this.getDatabase(request);
        ViewResults res = db.getAllDocuments();
        ArrayList<Document> entries = new ArrayList<Document>();
        List docs = res.getResults();
        for (Document doc : docs) {
            entries.add(db.getDocument(doc.getString("id")));
        }
        Collections.sort(entries, this.sorter);
        return new JsonObjectResponseContext(request.getAbdera(), this.config, (Document)res, entries.toArray(new Document[entries.size()])).setStatus(200).setEntityTag(res.getRev());
    }

    public ResponseContext deleteEntry(RequestContext request) {
        Target target = request.getTarget();
        String feed = target.getParameter("feed");
        String entry = target.getParameter("entry");
        Session session = new Session(this.host, this.port);
        Database db = session.getDatabase(feed);
        Document doc = null;
        try {
            doc = db.getDocument(entry);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (doc != null) {
            db.deleteDocument(doc);
            return ProviderHelper.nocontent();
        }
        return ProviderHelper.notfound((RequestContext)request);
    }

    private void setEditDetail(RequestContext request) throws IOException {
        Target target = request.getTarget();
        String feed = target.getParameter("feed");
        String id = target.getParameter("entry");
        Entry entry = (Entry)request.getDocument().getRoot();
        entry.setEdited(new Date());
        Link link = entry.getEditLink();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("feed", feed);
        params.put("entry", id);
        String href = request.absoluteUrlFor((Object)"entry", params);
        if (link == null) {
            entry.addLink(href, "edit");
        } else {
            link.setHref(href);
        }
    }

    public ResponseContext postEntry(RequestContext request) {
        Target target = request.getTarget();
        String feed = target.getParameter("feed");
        Session session = new Session(this.host, this.port);
        Database db = session.getDatabase(feed);
        try {
            CharArrayWriter cwriter = new CharArrayWriter();
            this.setEditDetail(request);
            request.getDocument().getRoot().writeTo("json", (Writer)cwriter);
            String json = new String(cwriter.toCharArray());
            JSONObject obj = JSONObject.fromObject((Object)json);
            String key = this.createKey(request);
            Document doc = null;
            try {
                doc = db.getDocument(key);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (doc != null) {
                return ProviderHelper.conflict((RequestContext)request, (String)"Entry with that key already exists");
            }
            doc = new Document(obj);
            doc.setId(key);
            db.saveDocument(doc);
            doc = db.getDocument(key);
            if (doc != null) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("feed", feed);
                params.put("entry", key);
                String urlFor = request.absoluteUrlFor((Object)"entry", params);
                return new JsonObjectResponseContext(request.getAbdera(), this.config, doc).setStatus(201).setEntityTag(doc.getRev()).setLocation(urlFor);
            }
            return ProviderHelper.servererror((RequestContext)request, null);
        }
        catch (IOException e) {
            return ProviderHelper.servererror((RequestContext)request, (Throwable)e);
        }
    }

    private String createKey(RequestContext request) throws IOException {
        String slug = request.getSlug();
        if (slug == null) {
            slug = ((Entry)request.getDocument().getRoot()).getTitle();
        }
        return Sanitizer.sanitize((String)slug, (String)"", (boolean)true, (Normalizer.Form)Normalizer.Form.D);
    }

    public ResponseContext getEntry(RequestContext request) {
        Target target = request.getTarget();
        String feed = target.getParameter("feed");
        String entry = target.getParameter("entry");
        Session session = new Session(this.host, this.port);
        Database db = session.getDatabase(feed);
        Document doc = null;
        try {
            doc = db.getDocument(entry);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (doc != null) {
            return new JsonObjectResponseContext(request.getAbdera(), this.config, doc).setStatus(200).setEntityTag(doc.getRev());
        }
        return ProviderHelper.notfound((RequestContext)request);
    }

    public ResponseContext putEntry(RequestContext request) {
        Target target = request.getTarget();
        String feed = target.getParameter("feed");
        Session session = new Session(this.host, this.port);
        Database db = session.getDatabase(feed);
        try {
            CharArrayWriter cwriter = new CharArrayWriter();
            this.setEditDetail(request);
            request.getDocument().getRoot().writeTo("json", (Writer)cwriter);
            String json = new String(cwriter.toCharArray());
            JSONObject obj = JSONObject.fromObject((Object)json);
            String key = target.getParameter("entry");
            Document doc = null;
            try {
                doc = db.getDocument(key);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (doc == null) {
                return ProviderHelper.notfound((RequestContext)request);
            }
            db.deleteDocument(doc);
            doc = new Document(obj);
            doc.setId(key);
            db.saveDocument(doc);
            doc = db.getDocument(key);
            if (doc != null) {
                return new JsonObjectResponseContext(request.getAbdera(), this.config, doc).setStatus(200).setEntityTag(doc.getRev());
            }
            return ProviderHelper.servererror((RequestContext)request, null);
        }
        catch (IOException e) {
            return ProviderHelper.servererror((RequestContext)request, (Throwable)e);
        }
    }

    public ResponseContext getCategories(RequestContext request) {
        return ProviderHelper.notfound((RequestContext)request);
    }

    public ResponseContext extensionRequest(RequestContext request) {
        return ProviderHelper.notfound((RequestContext)request);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DocumentComparator
    implements Comparator<Document> {
        private DocumentComparator() {
        }

        @Override
        public int compare(Document doc1, Document doc2) {
            Date d2;
            String ed1 = doc1.getString("edited");
            String ed2 = doc2.getString("edited");
            Date d1 = AtomDate.parse((String)ed1);
            if (d1.before(d2 = AtomDate.parse((String)ed2))) {
                return 1;
            }
            if (d1.after(d2)) {
                return -1;
            }
            return 0;
        }
    }
}

