/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.sharing;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.sharing.Conflicts;
import org.apache.abdera.ext.sharing.History;
import org.apache.abdera.ext.sharing.Sharing;
import org.apache.abdera.ext.sharing.Sync;
import org.apache.abdera.ext.sharing.Unpublished;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharingHelper {
    public static final String SSENS = "http://feedsync.org/2007/feedsync";
    public static final String SSEPFX = "sx";
    public static final QName SSE_SHARING = new QName("http://feedsync.org/2007/feedsync", "sharing", "sx");
    public static final QName SSE_RELATED = new QName("http://feedsync.org/2007/feedsync", "related", "sx");
    public static final QName SSE_CONFLICTS = new QName("http://feedsync.org/2007/feedsync", "conflicts", "sx");
    public static final QName SSE_HISTORY = new QName("http://feedsync.org/2007/feedsync", "history", "sx");
    public static final QName SSE_SYNC = new QName("http://feedsync.org/2007/feedsync", "sync", "sx");
    public static final QName SSE_UNPUBLISHED = new QName("http://feedsync.org/2007/feedsync", "unpublished", "sx");

    protected static boolean isTrue(String value) {
        return value.equalsIgnoreCase("true") || value.equals("1") || value.equals("-1") || value.equals("yes");
    }

    public static <T extends Source> Sharing getSharing(T source) {
        return SharingHelper.getSharing(source, false);
    }

    public static <T extends Source> Sharing getSharing(T source, boolean create) {
        Sharing sharing = (Sharing)source.getExtension(SSE_SHARING);
        if (sharing == null && create) {
            sharing = (Sharing)source.addExtension(SSE_SHARING);
        }
        return sharing;
    }

    public static <T extends Source> boolean hasSharing(T source) {
        return SharingHelper.getSharing(source) != null;
    }

    public static Unpublished getUnpublished(Feed feed) {
        return SharingHelper.getUnpublished(feed, false);
    }

    public static Unpublished getUnpublished(Feed feed, boolean create) {
        Unpublished unpub = (Unpublished)feed.getExtension(SSE_UNPUBLISHED);
        if (unpub == null && create) {
            unpub = (Unpublished)feed.addExtension(SSE_UNPUBLISHED);
        }
        return unpub;
    }

    public static Sync getSync(Entry entry) {
        return SharingHelper.getSync(entry, false);
    }

    public static Sync getSync(Entry entry, boolean create) {
        Sync sync = (Sync)entry.getExtension(SSE_SYNC);
        if (sync == null && create) {
            sync = (Sync)entry.addExtension(SSE_SYNC);
        }
        return sync;
    }

    public static boolean hasSync(Entry entry) {
        return SharingHelper.getSync(entry, false) != null;
    }

    public static Entry createEntry(Abdera abdera, String by) {
        return SharingHelper.createEntry(abdera, by, null);
    }

    public static Entry createEntry(Abdera abdera, String by, Feed feed) {
        Entry entry = feed != null ? feed.addEntry() : abdera.newEntry();
        entry.newId();
        Sync sync = SharingHelper.getSync(entry, true);
        sync.setId(entry.getId().toString());
        sync.setUpdates(1);
        History history = sync.addHistory();
        history.setSequence(sync.getUpdates());
        history.setWhen(new Date());
        history.setBy(by);
        return entry;
    }

    public static void deleteEntry(Entry entry, String by) {
        Sync sync = SharingHelper.getSync(entry, true);
        sync.incrementUpdates();
        sync.setDeleted(true);
        History history = sync.addHistory();
        history.setSequence(sync.getUpdates());
        history.setWhen(new Date());
        history.setBy(by);
    }

    public static void updateEntry(Entry entry, String by) {
        Sync sync = SharingHelper.getSync(entry, true);
        sync.incrementUpdates();
        History history = sync.addHistory();
        history.setSequence(sync.getUpdates());
        history.setWhen(new Date());
        history.setBy(by);
    }

    public static Map<String, Entry> getSyncIdMap(Feed feed) {
        HashMap<String, Entry> entries = new HashMap<String, Entry>();
        for (Entry entry : feed.getEntries()) {
            String id;
            Sync sync = SharingHelper.getSync(entry, false);
            if (sync == null || (id = sync.getId()) == null) continue;
            entries.put(id, entry);
        }
        return entries;
    }

    public static boolean isSubsumed(Sync s1, Sync s2) {
        if (s1 == null && s2 == null) {
            return false;
        }
        if (s1 == null && s2 != null) {
            return true;
        }
        if (s1 != null && s2 == null) {
            return false;
        }
        if (s1.equals(s2)) {
            return false;
        }
        if (!s1.getId().equals(s2.getId())) {
            return false;
        }
        History h1 = (History)s1.getFirstChild(SSE_HISTORY);
        for (History h2 : s2.getHistory()) {
            if (!SharingHelper.isSubsumed(h1, h2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubsumed(History h1, History h2) {
        if (h1 == null && h2 == null) {
            return false;
        }
        if (h1 == null && h2 != null) {
            return true;
        }
        if (h1 != null && h2 == null) {
            return false;
        }
        if (h1.equals(h2)) {
            return false;
        }
        String h1by = h1.getBy();
        String h2by = h2.getBy();
        return h1by != null ? h2by != null && h1by.equals(h2by) && h2.getSequence() >= h1.getSequence() : h2by == null && h1.getWhen().equals(h2.getWhen()) && h1.getSequence() == h2.getSequence();
    }

    public static Sync pickWinner(Sync s1, Sync s2) {
        if (s1 == null && s2 == null) {
            return null;
        }
        if (s1 == null && s2 != null) {
            return s2;
        }
        if (s1 != null && s2 == null) {
            return s1;
        }
        if (s1.equals(s2)) {
            return s1;
        }
        if (!s1.getId().equals(s2.getId())) {
            return null;
        }
        if (s1.getUpdates() > s2.getUpdates()) {
            return s1;
        }
        if (s1.getUpdates() == s2.getUpdates()) {
            History h1 = s1.getTopmostHistory();
            History h2 = s2.getTopmostHistory();
            Date d1 = h1.getWhen();
            Date d2 = h2.getWhen();
            if (d1 != null && d2 == null) {
                return s1;
            }
            if (d1.after(d2)) {
                return s1;
            }
            if (d1.equals(d2)) {
                String b1 = h1.getBy();
                String b2 = h2.getBy();
                if (b1 != null && b2 == null) {
                    return s1;
                }
                if (b1.compareTo(b2) > 0) {
                    return s1;
                }
            }
        }
        return s2;
    }

    private static List<Entry> getConflicts(Entry entry) {
        Conflicts conflicts;
        ArrayList<Entry> list = new ArrayList<Entry>();
        Sync sync = SharingHelper.getSync(entry, false);
        if (sync != null && (conflicts = sync.getConflicts(false)) != null) {
            list.addAll(conflicts.getEntries());
        }
        list.add(entry);
        return list;
    }

    private static Entry compareConflicts(Entry w, List<Entry> outerList, List<Entry> innerList, List<Entry> results) {
        Entry[] outer = outerList.toArray(new Entry[outerList.size()]);
        Entry[] inner = innerList.toArray(new Entry[innerList.size()]);
        for (Entry x : outer) {
            Sync s1 = SharingHelper.getSync(x, false);
            boolean ok = true;
            for (Entry y : inner) {
                Sync s2 = SharingHelper.getSync(y, false);
                if (!SharingHelper.isSubsumed(s1, s2)) continue;
                outerList.remove(s1);
                ok = false;
                break;
            }
            if (!ok) continue;
            results.add(x);
            if (w == null) {
                w = x;
                continue;
            }
            Sync s2 = SharingHelper.getSync(w);
            if (SharingHelper.pickWinner(s1, s2) != s1) continue;
            w = x;
        }
        return w;
    }

    public static void mergeFeeds(Feed source, Feed dest) {
        Map<String, Entry> destentries = SharingHelper.getSyncIdMap(dest);
        for (Entry entry : source.getEntries()) {
            String id;
            Sync s2 = SharingHelper.getSync(entry, false);
            if (s2 == null || (id = s2.getId()) == null) continue;
            Entry existing = destentries.get(id);
            if (existing == null) {
                Entry e = (Entry)entry.clone();
                dest.addEntry(e);
                continue;
            }
            Sync s1 = SharingHelper.getSync(existing, false);
            List<Entry> c1 = SharingHelper.getConflicts(existing);
            List<Entry> c2 = SharingHelper.getConflicts(entry);
            ArrayList<Entry> m = new ArrayList<Entry>();
            Entry w = null;
            w = SharingHelper.compareConflicts(w, c1, c2, m);
            w = SharingHelper.compareConflicts(w, c2, c1, m);
            if (s1.isNoConflicts()) {
                return;
            }
            if (m.size() <= 0) continue;
            Sync sync = SharingHelper.getSync(w, true);
            sync.setConflicts(null);
            Conflicts conflicts = sync.getConflicts(true);
            for (Entry e : m) {
                if (e == w) continue;
                conflicts.addEntry(e);
            }
        }
    }

    private static void mergeConflictItems(Entry entry, List<Entry> conflicts) {
        Sync sync = SharingHelper.getSync(entry, true);
        for (Entry x : conflicts) {
            History[] history;
            Sync xsync = SharingHelper.getSync(x, false);
            if (xsync == null) continue;
            List<History> list = xsync.getHistory();
            for (History h1 : history = list.toArray(new History[list.size()])) {
                h1 = (History)h1.clone();
                h1.discard();
                boolean ok = true;
                for (History h2 : sync.getHistory()) {
                    if (!SharingHelper.isSubsumed(h1, h2)) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                sync.addHistory(h1);
            }
        }
    }

    public static Entry resolveConflicts(Entry entry, ConflictResolver resolver, String by) {
        List<Entry> conflicts = SharingHelper.getConflicts(entry);
        entry = resolver.resolve(entry, conflicts);
        SharingHelper.updateEntry(entry, by);
        SharingHelper.mergeConflictItems(entry, conflicts);
        return entry;
    }

    public static Entry unpublish(Entry entry) {
        if (entry == null) {
            return null;
        }
        Object base = entry.getParentElement();
        if (base == null || !(base instanceof Feed)) {
            return null;
        }
        Feed feed = (Feed)base;
        Unpublished unpub = SharingHelper.getUnpublished(feed, true);
        Entry newentry = (Entry)entry.clone();
        unpub.addExtension(newentry);
        entry.discard();
        return newentry;
    }

    public static Entry republish(Entry entry) {
        if (entry == null) {
            return null;
        }
        Object base = entry.getParentElement();
        if (base == null || !(base instanceof Unpublished)) {
            return null;
        }
        Unpublished unpub = (Unpublished)base;
        Feed feed = (Feed)unpub.getParentElement();
        Entry newentry = (Entry)entry.clone();
        feed.addEntry(newentry);
        entry.discard();
        return newentry;
    }

    public static void publish(Feed feed, Date expires, boolean initial) {
        if (initial) {
            Sharing sharing = SharingHelper.getSharing(feed, true);
            Date since = SharingHelper.getMin(feed);
            Date until = SharingHelper.getMax(feed);
            sharing.setSince(since);
            sharing.setUntil(until);
            sharing.setExpires(expires);
        } else {
            Sharing sharing = SharingHelper.getSharing(feed, false);
            if (sharing != null) {
                sharing.setExpires(expires);
            } else {
                SharingHelper.publish(feed, expires, true);
            }
        }
    }

    private static Date getMax(Feed feed) {
        Date d = null;
        for (Entry entry : feed.getEntries()) {
            Date updated = entry.getUpdated();
            if (d == null) {
                d = updated;
            }
            if (!updated.after(d)) continue;
            d = updated;
        }
        return d;
    }

    private static Date getMin(Feed feed) {
        Date d = null;
        for (Entry entry : feed.getEntries()) {
            Date updated = entry.getUpdated();
            if (d == null) {
                d = updated;
            }
            if (!updated.before(d)) continue;
            d = updated;
        }
        return d;
    }

    public static boolean hasConflicts(Entry entry) {
        Conflicts conflicts;
        Sync sync = SharingHelper.getSync(entry);
        return sync != null && (conflicts = sync.getConflicts()) != null && conflicts.getEntries().size() > 0;
    }

    public static boolean isValidEndpointIdentifier(String id) {
        if (id == null) {
            return false;
        }
        char[] chars = id.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (SharingHelper.is_alphanum(c) || SharingHelper.is_reserved_or_other(c) || SharingHelper.is_hex(chars, i)) continue;
            return false;
        }
        return true;
    }

    private static boolean is_alphanum(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    private static boolean is_reserved_or_other(char c) {
        return c == '/' || c == '?' || c == '#' || c == '(' || c == ')' || c == '+' || c == ',' || c == '-' || c == '.' || c == ':' || c == '=' || c == '@' || c == ';' || c == '$' || c == '_' || c == '!' || c == '*' || c == '\'';
    }

    private static boolean is_hex(char[] chars, int i) {
        if (chars[i] == '%') {
            if (i + 2 > chars.length) {
                return false;
            }
            return SharingHelper.is_hex(chars[i], chars[i + 1], chars[i + 2]);
        }
        return false;
    }

    private static boolean is_hexdigit(char c) {
        return c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    private static boolean is_hex(char c, char c2, char c3) {
        return c == '%' && SharingHelper.is_hexdigit(c2) && SharingHelper.is_hexdigit(c3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ConflictResolver {
        public Entry resolve(Entry var1, List<Entry> var2);
    }
}

