/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.cache;

import java.lang.reflect.Method;
import java.util.Map;
import org.aoju.bus.cache.CacheX;
import org.aoju.bus.cache.Complex;
import org.aoju.bus.cache.Context;
import org.aoju.bus.cache.Module;
import org.aoju.bus.cache.annotation.Cached;
import org.aoju.bus.cache.annotation.CachedGet;
import org.aoju.bus.cache.annotation.Invalid;
import org.aoju.bus.proxy.invoker.InvocationInvoker;
import org.aoju.bus.proxy.invoker.ProxyChain;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class AspectjCacheProxy {
    private Complex core;

    public AspectjCacheProxy(Map<String, CacheX> caches) {
        this(Context.newConfig(caches));
    }

    public AspectjCacheProxy(Context config) {
        this.core = Module.coreInstance((Context)config);
    }

    @Around(value="@annotation(org.aoju.bus.cache.annotation.CachedGet)")
    public Object read(ProceedingJoinPoint point) throws Throwable {
        Method method = this.getMethod((JoinPoint)point);
        CachedGet cachedGet = method.getAnnotation(CachedGet.class);
        return this.core.read(cachedGet, method, (ProxyChain)new InvocationInvoker(point));
    }

    @Around(value="@annotation(org.aoju.bus.cache.annotation.Cached)")
    public Object readWrite(ProceedingJoinPoint point) throws Throwable {
        Method method = this.getMethod((JoinPoint)point);
        Cached cached = method.getAnnotation(Cached.class);
        return this.core.readWrite(cached, method, (ProxyChain)new InvocationInvoker(point));
    }

    @After(value="@annotation(org.aoju.bus.cache.annotation.Invalid)")
    public void remove(JoinPoint point) throws Throwable {
        Method method = this.getMethod(point);
        Invalid invalid = method.getAnnotation(Invalid.class);
        this.core.remove(invalid, method, point.getArgs());
    }

    private Method getMethod(JoinPoint point) throws NoSuchMethodException {
        MethodSignature ms = (MethodSignature)point.getSignature();
        Method method = ms.getMethod();
        if (method.getDeclaringClass().isInterface()) {
            method = point.getTarget().getClass().getDeclaredMethod(ms.getName(), method.getParameterTypes());
        }
        return method;
    }
}

