/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter;

import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Types;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.starter.SpringHolder;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.stereotype.Component;

@Component
public class SpringBuilder
implements ApplicationContextAware {
    private static ConfigurableApplicationContext context;

    public static ConfigurableApplicationContext getContext() {
        return context;
    }

    public static void setContext(ConfigurableApplicationContext context) {
        Assert.notNull((Object)context, (String)"Could not found context for spring.", (Object[])new Object[0]);
        SpringBuilder.context = context;
        SpringHolder.alive = true;
    }

    public static ListableBeanFactory getBeanFactory() {
        return null == context.getBeanFactory() ? context : context.getBeanFactory();
    }

    public static <T> T getBean(String name) {
        return (T)SpringBuilder.getBeanFactory().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)SpringBuilder.getBeanFactory().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringBuilder.getBeanFactory().getBean(name, clazz);
    }

    public static <T> T getBean(Types<T> reference) {
        ParameterizedType parameterizedType = (ParameterizedType)reference.getType();
        Class rawType = (Class)parameterizedType.getRawType();
        Class[] genericTypes = (Class[])Arrays.stream(parameterizedType.getActualTypeArguments()).map(type -> (Class)type).toArray(Class[]::new);
        String[] beanNames = SpringBuilder.getBeanFactory().getBeanNamesForType(ResolvableType.forClassWithGenerics((Class)rawType, (Class[])genericTypes));
        return SpringBuilder.getBean(beanNames[0], rawType);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) {
        return SpringBuilder.getBeanFactory().getBeansOfType(type);
    }

    public static String[] getBeanNamesForType(Class<?> type) {
        return SpringBuilder.getBeanFactory().getBeanNamesForType(type);
    }

    public static String getProperty(String key) {
        if (null == context) {
            return null;
        }
        return context.getEnvironment().getProperty(key);
    }

    public static String[] getActiveProfiles() {
        if (null == context) {
            return null;
        }
        return context.getEnvironment().getActiveProfiles();
    }

    public static String getActiveProfile() {
        Object[] activeProfiles = SpringBuilder.getActiveProfiles();
        return ArrayKit.isNotEmpty((Object[])activeProfiles) ? activeProfiles[0] : null;
    }

    public static void registerBeanDefinition(Class clazz) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)SpringBuilder.getBeanFactory();
        beanFactory.registerBeanDefinition(StringKit.lowerFirst((CharSequence)clazz.getSimpleName()), (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition((Class)clazz).getBeanDefinition());
    }

    public static void registerSingleton(Class clazz) {
        try {
            SpringBuilder.registerSingleton(clazz, clazz.newInstance());
        }
        catch (InstantiationException e) {
            Logger.error((String)e.getMessage(), (Object[])new Object[]{e});
        }
        catch (IllegalAccessException e) {
            Logger.error((String)e.getMessage(), (Object[])new Object[]{e});
        }
    }

    public static void registerSingleton(Class clazz, Object bean) {
        ConfigurableListableBeanFactory factory = (ConfigurableListableBeanFactory)SpringBuilder.getBeanFactory();
        factory.autowireBean(bean);
        factory.registerSingleton(StringKit.lowerFirst((CharSequence)clazz.getSimpleName()), bean);
    }

    public static void unRegisterSingleton(String beanName) {
        ConfigurableListableBeanFactory factory = (ConfigurableListableBeanFactory)SpringBuilder.getBeanFactory();
        if (!(factory instanceof DefaultSingletonBeanRegistry)) {
            throw new InstrumentException("Can not unregister bean, the factory is not a DefaultSingletonBeanRegistry!");
        }
        DefaultSingletonBeanRegistry registry = (DefaultSingletonBeanRegistry)factory;
        registry.destroySingleton(beanName);
    }

    public static void refreshContext() {
        if (SpringHolder.alive) {
            context.refresh();
        }
    }

    public static void removeContext() {
        if (SpringHolder.alive) {
            context.close();
            context = null;
            SpringHolder.alive = false;
        }
    }

    public static String getApplicationName() {
        return SpringBuilder.getProperty("spring.application.name");
    }

    public static boolean isDemoMode() {
        return SpringBuilder.isTestMode() || SpringBuilder.isDevMode();
    }

    public static boolean isDevMode() {
        return "dev".equalsIgnoreCase(SpringBuilder.getActiveProfile());
    }

    public static boolean isTestMode() {
        return "test".equalsIgnoreCase(SpringBuilder.getActiveProfile());
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        System.setProperty("user.timezone", "Asia/Shanghai");
        context = (ConfigurableApplicationContext)applicationContext;
    }
}

