/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.wrapper;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.starter.wrapper.CacheRequestWrapper;
import org.aoju.bus.starter.wrapper.CacheResponseWrapper;
import org.aoju.bus.starter.wrapper.WrapperProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.filter.OncePerRequestFilter;

@EnableConfigurationProperties(value={WrapperProperties.class})
public class WrapperConfiguration {
    @Autowired
    WrapperProperties properties;

    @Bean(value={"registrationBodyCacheFilter"})
    public FilterRegistrationBean registrationBodyCacheFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setEnabled(this.properties.getEnabled().booleanValue());
        registrationBean.setOrder(this.properties.getOrder());
        registrationBean.setFilter((Filter)new BodyCacheFilter());
        if (!StringKit.isEmpty((CharSequence)this.properties.getName())) {
            registrationBean.setName(this.properties.getName());
        }
        if (MapKit.isNotEmpty(this.properties.getInitParameters())) {
            registrationBean.setInitParameters(this.properties.getInitParameters());
        }
        if (ObjectKit.isNotEmpty(this.properties.getServletRegistrationBeans())) {
            registrationBean.setServletRegistrationBeans(this.properties.getServletRegistrationBeans());
        }
        if (!CollKit.isEmpty(this.properties.getServletNames())) {
            registrationBean.setServletNames(this.properties.getServletNames());
        }
        return registrationBean;
    }

    private static class BodyCacheFilter
    extends OncePerRequestFilter {
        private BodyCacheFilter() {
        }

        protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
            String method = request.getMethod();
            if (("POST".equals(method) || "PATCH".equals(method) || "PUT".equals(method)) && !(request instanceof CacheRequestWrapper)) {
                request = new CacheRequestWrapper((HttpServletRequest)request);
            }
            if (!(response instanceof CacheResponseWrapper)) {
                response = new CacheResponseWrapper((HttpServletResponse)response);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

